/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service;

import org.apache.cxf.common.xmlschema.InvalidXmlSchemaReferenceException;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class ServiceModelSchemaValidator
extends ServiceModelVisitor {
    private SchemaCollection schemaCollection;
    private StringBuilder complaints;

    public ServiceModelSchemaValidator(ServiceInfo serviceInfo) {
        super(serviceInfo);
        this.schemaCollection = serviceInfo.getXmlSchemaCollection();
        this.complaints = new StringBuilder();
    }

    public String getComplaints() {
        return this.complaints.toString();
    }

    public void begin(MessagePartInfo part) {
        if (part.isElement()) {
            try {
                this.schemaCollection.validateElementName(part.getName(), part.getElementQName());
            }
            catch (InvalidXmlSchemaReferenceException ixsre) {
                this.complaints.append(part.getName() + " part element name " + ixsre.getMessage() + "\n");
            }
        } else if (part.getTypeQName() == null) {
            this.complaints.append(part.getName() + " part type QName null.\n");
        } else {
            try {
                this.schemaCollection.validateTypeName(part.getName(), part.getTypeQName());
            }
            catch (InvalidXmlSchemaReferenceException ixsre) {
                this.complaints.append(part.getName() + " part type name " + ixsre.getMessage() + "\n");
            }
        }
    }
}

