/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;

public class ChainInitiationObserver
implements MessageObserver {
    protected Endpoint endpoint;
    protected Bus bus;
    private PhaseChainCache chainCache = new PhaseChainCache();

    public ChainInitiationObserver(Endpoint endpoint, Bus bus) {
        this.endpoint = endpoint;
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message m) {
        Bus origBus = BusFactory.getThreadDefaultBus(false);
        BusFactory.setThreadDefaultBus(this.bus);
        try {
            Message message = this.getBinding().createMessage(m);
            Exchange exchange = message.getExchange();
            if (exchange == null) {
                exchange = new ExchangeImpl();
                exchange.setInMessage(message);
            }
            this.setExchangeProperties(exchange, message);
            PhaseInterceptorChain chain = this.chainCache.get(this.bus.getExtension(PhaseManager.class).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors(), this.endpoint.getService().getInInterceptors());
            message.setInterceptorChain(chain);
            chain.setFaultObserver(this.endpoint.getOutFaultObserver());
            chain.doIntercept(message);
        }
        finally {
            BusFactory.setThreadDefaultBus(origBus);
        }
    }

    protected Binding getBinding() {
        return this.endpoint.getBinding();
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Endpoint.class, this.endpoint);
        exchange.put(Service.class, this.endpoint.getService());
        exchange.put(Binding.class, this.getBinding());
        exchange.put(Bus.class, this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
        if (this.endpoint != null) {
            EndpointInfo endpointInfo = this.endpoint.getEndpointInfo();
            QName serviceQName = endpointInfo.getService().getName();
            exchange.put("javax.xml.ws.wsdl.service", serviceQName);
            QName interfaceQName = endpointInfo.getService().getInterface().getName();
            exchange.put("javax.xml.ws.wsdl.interface", interfaceQName);
            QName portQName = endpointInfo.getName();
            exchange.put("javax.xml.ws.wsdl.port", portQName);
            URI wsdlDescription = endpointInfo.getProperty("URI", URI.class);
            if (wsdlDescription == null) {
                String address = endpointInfo.getAddress();
                try {
                    wsdlDescription = new URI(address + "?wsdl");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                endpointInfo.setProperty("URI", wsdlDescription);
            }
            exchange.put("javax.xml.ws.wsdl.description", wsdlDescription);
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }
}

