/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;

public class PooledSession {
    private final Session theSession;
    private Destination theDestination;
    private final MessageProducer theProducer;
    private MessageConsumer theConsumer;
    private String correlationID;

    PooledSession(Session session, Destination destination, MessageProducer producer, MessageConsumer consumer) {
        this.theSession = session;
        this.theDestination = destination;
        this.theProducer = producer;
        this.theConsumer = consumer;
    }

    Session session() {
        return this.theSession;
    }

    Destination destination() {
        return this.theDestination;
    }

    void destination(Destination destination) {
        this.theDestination = destination;
    }

    MessageProducer producer() {
        return this.theProducer;
    }

    MessageConsumer consumer() {
        return this.theConsumer;
    }

    String getCorrelationID() throws JMSException {
        String selector;
        if (this.correlationID == null && this.theConsumer != null && (selector = this.theConsumer.getMessageSelector()) != null && selector.startsWith("JMSCorrelationID")) {
            int i = selector.indexOf(39);
            this.correlationID = selector.substring(i + 1, selector.length() - 1);
        }
        return this.correlationID;
    }

    void consumer(MessageConsumer consumer) {
        this.theConsumer = consumer;
    }

    void close() throws JMSException {
        if (this.theProducer != null) {
            this.theProducer.close();
        }
        if (this.theConsumer != null) {
            this.theConsumer.close();
        }
        if (this.theDestination instanceof TemporaryQueue) {
            ((TemporaryQueue)this.theDestination).delete();
        }
        if (this.theSession != null) {
            this.theSession.close();
        }
    }
}

