/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.workqueue.AutomaticWorkQueue;

public class AutomaticWorkQueueImpl
extends ThreadPoolExecutor
implements AutomaticWorkQueue {
    static final int DEFAULT_MAX_QUEUE_SIZE = 128;
    private static final Logger LOG = LogUtils.getL7dLogger(AutomaticWorkQueueImpl.class);
    int maxQueueSize;

    AutomaticWorkQueueImpl(int mqs, int initialThreads, int highWaterMark, int lowWaterMark, long dequeueTimeout) {
        super(-1 == lowWaterMark ? Integer.MAX_VALUE : lowWaterMark, -1 == highWaterMark ? Integer.MAX_VALUE : highWaterMark, TimeUnit.MILLISECONDS.toMillis(dequeueTimeout), TimeUnit.MILLISECONDS, mqs == -1 ? new ArrayBlockingQueue<Runnable>(128) : new ArrayBlockingQueue(mqs));
        this.maxQueueSize = mqs == -1 ? 128 : mqs;
        lowWaterMark = -1 == lowWaterMark ? Integer.MAX_VALUE : lowWaterMark;
        highWaterMark = -1 == highWaterMark ? Integer.MAX_VALUE : highWaterMark;
        StringBuffer buf = new StringBuffer();
        buf.append("Constructing automatic work queue with:\n");
        buf.append("max queue size: " + this.maxQueueSize + "\n");
        buf.append("initialThreads: " + initialThreads + "\n");
        buf.append("lowWaterMark: " + lowWaterMark + "\n");
        buf.append("highWaterMark: " + highWaterMark + "\n");
        LOG.fine(buf.toString());
        if (initialThreads > highWaterMark) {
            initialThreads = highWaterMark;
        }
        if (initialThreads < Integer.MAX_VALUE && initialThreads > 0) {
            this.setCorePoolSize(initialThreads);
            int started = this.prestartAllCoreThreads();
            if (started < initialThreads) {
                LOG.log(Level.WARNING, "THREAD_START_FAILURE_MSG", new Object[]{started, initialThreads});
            }
            this.setCorePoolSize(lowWaterMark);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append(" [queue size: ");
        buf.append(this.getSize());
        buf.append(", max size: ");
        buf.append(this.maxQueueSize);
        buf.append(", threads: ");
        buf.append(this.getPoolSize());
        buf.append(", active threads: ");
        buf.append(this.getActiveCount());
        buf.append(", low water mark: ");
        buf.append(this.getLowWaterMark());
        buf.append(", high water mark: ");
        buf.append(this.getHighWaterMark());
        buf.append("]");
        return buf.toString();
    }

    public void execute(Runnable work, long timeout) {
        try {
            this.execute(work);
        }
        catch (RejectedExecutionException ree) {
            try {
                this.getQueue().offer(work, timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                throw new RejectedExecutionException(ie);
            }
        }
    }

    public void schedule(final Runnable work, final long delay) {
        this.execute(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                work.run();
            }
        });
    }

    public void shutdown(boolean processRemainingWorkItems) {
        if (!processRemainingWorkItems) {
            this.getQueue().clear();
        }
        this.shutdown();
    }

    long getMaxSize() {
        return this.maxQueueSize;
    }

    public long getSize() {
        return this.getQueue().size();
    }

    public boolean isEmpty() {
        return this.getQueue().size() == 0;
    }

    boolean isFull() {
        return this.getQueue().remainingCapacity() == 0;
    }

    int getHighWaterMark() {
        int hwm = this.getMaximumPoolSize();
        return hwm == Integer.MAX_VALUE ? -1 : hwm;
    }

    int getLowWaterMark() {
        int lwm = this.getCorePoolSize();
        return lwm == Integer.MAX_VALUE ? -1 : lwm;
    }

    void setHighWaterMark(int hwm) {
        this.setMaximumPoolSize(hwm < 0 ? Integer.MAX_VALUE : hwm);
    }

    void setLowWaterMark(int lwm) {
        this.setCorePoolSize(lwm < 0 ? 0 : lwm);
    }
}

