/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl.WSDLConstants;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceWSDLBuilder {
    private final Map<String, String> ns2prefix;
    private Definition definition;
    private final List<ServiceInfo> services;
    private boolean useSchemaImports;
    private String baseFileName;
    private int xsdCount;
    private final Bus bus;

    public ServiceWSDLBuilder(Bus b, List<ServiceInfo> services) {
        this.services = services;
        this.bus = b;
        this.ns2prefix = new HashMap<String, String>();
    }

    public ServiceWSDLBuilder(Bus b, ServiceInfo ... services) {
        this(b, Arrays.asList(services));
    }

    public void setUseSchemaImports(boolean b) {
        this.useSchemaImports = b;
    }

    public void setBaseFileName(String s) {
        this.baseFileName = s;
    }

    public Definition build() throws WSDLException {
        this.useSchemaImports = false;
        return this.build(null);
    }

    public Definition build(Map<String, SchemaInfo> imports) throws WSDLException {
        try {
            this.definition = this.services.get(0).getProperty(WSDLServiceBuilder.WSDL_DEFINITION, Definition.class);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (this.definition == null) {
            ServiceInfo si = this.services.get(0);
            this.definition = this.newDefinition(si.getName(), si.getTargetNamespace());
            this.addNamespace("tns", si.getTargetNamespace(), this.definition);
            this.addExtensibiltyElements((ElementExtensible)this.definition, this.getWSDL11Extensors(si));
            HashSet<PortType> portTypes = new HashSet<PortType>();
            for (ServiceInfo service : this.services) {
                Definition portTypeDef = this.definition;
                if (!this.isSameTNS(service)) {
                    portTypeDef = this.newDefinition(service.getInterface().getName(), service.getInterface().getName().getNamespaceURI());
                    Import wsdlImport = this.definition.createImport();
                    String tns = service.getInterface().getName().getNamespaceURI();
                    wsdlImport.setDefinition(portTypeDef);
                    wsdlImport.setNamespaceURI(tns);
                    wsdlImport.setLocationURI(service.getInterface().getName().getLocalPart() + ".wsdl");
                    this.definition.addImport(wsdlImport);
                    this.addNamespace(this.getPrefix(tns), tns, this.definition);
                }
                portTypes.add(this.buildPortType(service.getInterface(), portTypeDef));
                if (service.getSchemas() == null || service.getSchemas().size() <= 0) continue;
                this.buildTypes(service.getSchemas(), imports, portTypeDef);
            }
            for (ServiceInfo service : this.services) {
                this.buildBinding(service.getBindings(), portTypes);
                this.buildService(service);
            }
        }
        return this.definition;
    }

    private boolean isSameTNS(ServiceInfo service) {
        return service.getName().getNamespaceURI().equals(service.getInterface().getName().getNamespaceURI());
    }

    private Definition newDefinition(QName name, String targetNamespace) {
        Definition d = this.bus.getExtension(WSDLManager.class).getWSDLFactory().newDefinition();
        d.setExtensionRegistry(this.bus.getExtension(WSDLManager.class).getExtensionRegistry());
        d.setQName(name);
        d.setTargetNamespace(targetNamespace);
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema", d);
        return d;
    }

    public List<ExtensibilityElement> getWSDL11Extensors(AbstractPropertiesHolder holder) {
        return holder.getExtensors(ExtensibilityElement.class);
    }

    protected void addExtensibiltyElements(ElementExtensible elementExtensible, List<ExtensibilityElement> extensibilityElements) {
        if (extensibilityElements != null) {
            for (ExtensibilityElement element : extensibilityElements) {
                QName qn = element.getElementType();
                this.addNamespace(qn.getNamespaceURI());
                elementExtensible.addExtensibilityElement(element);
            }
        }
    }

    protected void addRequiredSchemaImports(SchemaInfo schemaInfo) {
        Element schemaElement = schemaInfo.getElement();
        String schemaNamespace = schemaInfo.getNamespaceURI();
        HashMap<String, String> queryPrefixMap = new HashMap<String, String>();
        queryPrefixMap.put("xs", "http://www.w3.org/2001/XMLSchema");
        XPathUtils xpu = new XPathUtils(queryPrefixMap);
        NamespacePrefixList schemaPrefixes = schemaInfo.getSchema().getNamespaceContext();
        for (String prefix : schemaPrefixes.getDeclaredPrefixes()) {
            String namespace = schemaPrefixes.getNamespaceURI(prefix);
            if (namespace.equals(schemaNamespace) || namespace.equals("http://www.w3.org/2001/XMLSchema") || xpu.isExist("xs:import[@namespace='" + namespace + "']", schemaElement, XPathConstants.NODE)) continue;
            Element importElement = XMLUtils.createElementNS(schemaElement.getOwnerDocument(), "http://www.w3.org/2001/XMLSchema", "import");
            importElement.setAttribute("namespace", namespace);
            schemaElement.insertBefore(importElement, schemaElement.getFirstChild());
        }
    }

    protected void buildTypes(Collection<SchemaInfo> schemas, Map<String, SchemaInfo> imports, Definition def) {
        Types types = def.createTypes();
        Document doc = null;
        try {
            doc = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("DOM configuration problem", e);
        }
        Element nd = XMLUtils.createElementNS(doc, new QName("http://www.w3.org/2001/XMLSchema", "schema"));
        nd.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
        doc.appendChild(nd);
        for (SchemaInfo schemaInfo : schemas) {
            if (!this.useSchemaImports) {
                SchemaImpl schemaImpl = new SchemaImpl();
                schemaImpl.setRequired(Boolean.valueOf(true));
                schemaImpl.setElementType(WSDLConstants.SCHEMA_QNAME);
                schemaImpl.setElement(schemaInfo.getElement());
                types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
            } else {
                String name = this.baseFileName + "_schema" + ++this.xsdCount + ".xsd";
                Element imp = XMLUtils.createElementNS(doc, new QName("http://www.w3.org/2001/XMLSchema", "import"));
                imp.setAttribute("schemaLocation", name);
                imp.setAttribute("namespace", schemaInfo.getNamespaceURI());
                nd.appendChild(imp);
                imports.put(name, schemaInfo);
            }
            this.addRequiredSchemaImports(schemaInfo);
        }
        if (this.useSchemaImports) {
            SchemaImpl schemaImpl = new SchemaImpl();
            schemaImpl.setRequired(Boolean.valueOf(true));
            schemaImpl.setElementType(WSDLConstants.SCHEMA_QNAME);
            schemaImpl.setElement(nd);
            types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
        }
        def.setTypes(types);
    }

    protected void buildBinding(Collection<BindingInfo> bindingInfos, Collection<PortType> portTypes) {
        Binding binding = null;
        for (BindingInfo bindingInfo : bindingInfos) {
            binding = this.definition.createBinding();
            binding.setUndefined(false);
            for (PortType portType : portTypes) {
                if (!portType.getQName().equals(bindingInfo.getInterface().getName())) continue;
                binding.setPortType(portType);
                break;
            }
            binding.setQName(bindingInfo.getName());
            this.buildBindingOperation(this.definition, binding, bindingInfo.getOperations());
            this.addExtensibiltyElements((ElementExtensible)binding, this.getWSDL11Extensors(bindingInfo));
            this.definition.addBinding(binding);
        }
    }

    protected void buildBindingOperation(Definition def, Binding binding, Collection<BindingOperationInfo> bindingOperationInfos) {
        BindingOperation bindingOperation = null;
        for (BindingOperationInfo bindingOperationInfo : bindingOperationInfos) {
            bindingOperation = def.createBindingOperation();
            bindingOperation.setName(bindingOperationInfo.getName().getLocalPart());
            for (Operation operation : CastUtils.cast(binding.getPortType().getOperations(), Operation.class)) {
                if (!operation.getName().equals(bindingOperation.getName())) continue;
                bindingOperation.setOperation(operation);
                break;
            }
            this.buildBindingInput(def, bindingOperation, bindingOperationInfo.getInput());
            this.buildBindingOutput(def, bindingOperation, bindingOperationInfo.getOutput());
            this.buildBindingFault(def, bindingOperation, bindingOperationInfo.getFaults());
            this.addExtensibiltyElements((ElementExtensible)bindingOperation, this.getWSDL11Extensors(bindingOperationInfo));
            binding.addBindingOperation(bindingOperation);
        }
    }

    protected void buildBindingFault(Definition def, BindingOperation bindingOperation, Collection<BindingFaultInfo> bindingFaultInfos) {
        BindingFault bindingFault = null;
        for (BindingFaultInfo bindingFaultInfo : bindingFaultInfos) {
            bindingFault = def.createBindingFault();
            bindingFault.setName(bindingFaultInfo.getFaultInfo().getFaultName().getLocalPart());
            bindingOperation.addBindingFault(bindingFault);
            this.addExtensibiltyElements((ElementExtensible)bindingFault, this.getWSDL11Extensors(bindingFaultInfo));
        }
    }

    protected void buildBindingInput(Definition def, BindingOperation bindingOperation, BindingMessageInfo bindingMessageInfo) {
        BindingInput bindingInput = null;
        if (bindingMessageInfo != null) {
            bindingInput = def.createBindingInput();
            bindingInput.setName(bindingMessageInfo.getMessageInfo().getName().getLocalPart());
            bindingOperation.setBindingInput(bindingInput);
            this.addExtensibiltyElements((ElementExtensible)bindingInput, this.getWSDL11Extensors(bindingMessageInfo));
        }
    }

    protected void buildBindingOutput(Definition def, BindingOperation bindingOperation, BindingMessageInfo bindingMessageInfo) {
        BindingOutput bindingOutput = null;
        if (bindingMessageInfo != null) {
            bindingOutput = def.createBindingOutput();
            bindingOutput.setName(bindingMessageInfo.getMessageInfo().getName().getLocalPart());
            bindingOperation.setBindingOutput(bindingOutput);
            this.addExtensibiltyElements((ElementExtensible)bindingOutput, this.getWSDL11Extensors(bindingMessageInfo));
        }
    }

    protected void buildService(ServiceInfo serviceInfo) {
        Service serv = this.definition.createService();
        serv.setQName(serviceInfo.getName());
        this.addNamespace(serviceInfo.getName().getNamespaceURI());
        this.definition.addService(serv);
        for (EndpointInfo ei : serviceInfo.getEndpoints()) {
            this.addNamespace(ei.getTransportId());
            Port port = this.definition.createPort();
            port.setName(ei.getName().getLocalPart());
            port.setBinding(this.definition.getBinding(ei.getBinding().getName()));
            this.addExtensibiltyElements((ElementExtensible)port, this.getWSDL11Extensors(ei));
            serv.addPort(port);
        }
    }

    protected PortType buildPortType(InterfaceInfo intf, Definition def) {
        PortType portType = null;
        try {
            portType = intf.getProperty(WSDLServiceBuilder.WSDL_PORTTYPE, PortType.class);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (portType == null) {
            portType = def.createPortType();
            portType.setQName(intf.getName());
            this.addNamespace(intf.getName().getNamespaceURI(), def);
            portType.setUndefined(false);
            this.buildPortTypeOperation(portType, intf.getOperations(), def);
        }
        def.addPortType(portType);
        return portType;
    }

    protected void addNamespace(String namespaceURI, Definition def) {
        this.addNamespace(this.getPrefix(namespaceURI), namespaceURI, def);
    }

    protected void addNamespace(String namespaceURI) {
        this.addNamespace(this.getPrefix(namespaceURI), namespaceURI);
    }

    protected void addNamespace(String prefix, String namespaceURI) {
        this.addNamespace(prefix, namespaceURI, this.definition);
    }

    protected void addNamespace(String prefix, String namespaceURI, Definition def) {
        this.ns2prefix.put(namespaceURI, prefix);
        def.addNamespace(prefix, namespaceURI);
    }

    protected void buildPortTypeOperation(PortType portType, Collection<OperationInfo> operationInfos, Definition def) {
        for (OperationInfo operationInfo : operationInfos) {
            Operation operation = null;
            try {
                operation = operationInfo.getProperty(WSDLServiceBuilder.WSDL_OPERATION, Operation.class);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (operation == null) {
                operation = def.createOperation();
                operation.setUndefined(false);
                operation.setName(operationInfo.getName().getLocalPart());
                this.addNamespace(operationInfo.getName().getNamespaceURI(), def);
                if (operationInfo.isOneWay()) {
                    operation.setStyle(OperationType.ONE_WAY);
                }
                Input input = def.createInput();
                input.setName(operationInfo.getInputName());
                Message message = def.createMessage();
                this.buildMessage(message, operationInfo.getInput(), def);
                input.setMessage(message);
                operation.setInput(input);
                if (operationInfo.getOutput() != null) {
                    Output output = def.createOutput();
                    output.setName(operationInfo.getOutputName());
                    message = def.createMessage();
                    this.buildMessage(message, operationInfo.getOutput(), def);
                    output.setMessage(message);
                    operation.setOutput(output);
                }
                Collection<FaultInfo> faults = operationInfo.getFaults();
                Fault fault = null;
                for (FaultInfo faultInfo : faults) {
                    fault = def.createFault();
                    fault.setName(faultInfo.getFaultName().getLocalPart());
                    message = def.createMessage();
                    this.buildMessage(message, faultInfo, def);
                    fault.setMessage(message);
                    operation.addFault(fault);
                }
            }
            portType.addOperation(operation);
        }
    }

    private String getPrefix(String ns) {
        for (String namespace : WSDLConstants.NS_PREFIX_PAIR.keySet()) {
            if (!namespace.equals(ns)) continue;
            return WSDLConstants.NS_PREFIX_PAIR.get(namespace);
        }
        String prefix = this.ns2prefix.get(ns);
        if (prefix == null) {
            prefix = this.getNewPrefix();
            this.ns2prefix.put(ns, prefix);
        }
        return prefix;
    }

    private String getNewPrefix() {
        String prefix = "ns1";
        int i = 0;
        while (this.ns2prefix.containsValue(prefix)) {
            prefix = "ns" + ++i;
        }
        return prefix;
    }

    protected void buildMessage(Message message, AbstractMessageContainer messageContainer, Definition def) {
        message.setQName(messageContainer.getName());
        message.setUndefined(false);
        def.addMessage(message);
        List<MessagePartInfo> messageParts = messageContainer.getMessageParts();
        Part messagePart = null;
        for (MessagePartInfo messagePartInfo : messageParts) {
            messagePart = def.createPart();
            messagePart.setName(messagePartInfo.getName().getLocalPart());
            if (messagePartInfo.isElement()) {
                messagePart.setElementName(messagePartInfo.getElementQName());
                this.addNamespace(messagePartInfo.getElementQName().getNamespaceURI(), def);
            } else if (messagePartInfo.getTypeQName() != null) {
                messagePart.setTypeName(messagePartInfo.getTypeQName());
                this.addNamespace(messagePartInfo.getTypeQName().getNamespaceURI(), def);
            }
            message.addPart(messagePart);
        }
    }
}

