/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class MimeBodyPartInputStream
extends InputStream {
    PushbackInputStream inStream;
    boolean boundaryFound;
    byte[] boundary;

    public MimeBodyPartInputStream(PushbackInputStream inStreamParam, byte[] boundaryParam) {
        this.inStream = inStreamParam;
        this.boundary = boundaryParam;
    }

    public int read() throws IOException {
        int boundaryIndex;
        boolean needUnread0d0a = false;
        if (this.boundaryFound) {
            return -1;
        }
        int value = this.inStream.read();
        if (value == 13) {
            value = this.inStream.read();
            if (value != 10) {
                this.inStream.unread(value);
                return 13;
            }
            value = this.inStream.read();
            if ((byte)value != this.boundary[0]) {
                this.inStream.unread(value);
                this.inStream.unread(10);
                return 13;
            }
            needUnread0d0a = true;
        } else if ((byte)value != this.boundary[0]) {
            return value;
        }
        for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
            value = this.inStream.read();
        }
        if (boundaryIndex == this.boundary.length) {
            this.boundaryFound = true;
            if (this.inStream.read() == 45 && value == 45) {
                this.inStream.read();
                this.inStream.read();
            }
            return -1;
        }
        if (value != -1) {
            this.inStream.unread(value);
        }
        if (needUnread0d0a) {
            this.inStream.unread(this.boundary, 0, boundaryIndex);
            this.inStream.unread(10);
            value = 13;
        } else {
            this.inStream.unread(this.boundary, 1, boundaryIndex - 1);
            value = this.boundary[0];
        }
        return value;
    }
}

