/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.ClientBehaviorPolicyType;
import org.apache.cxf.transport.jms.ClientConfig;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSProviderHub;
import org.apache.cxf.transport.jms.JMSSessionFactory;
import org.apache.cxf.transport.jms.JMSTransport;
import org.apache.cxf.transport.jms.JMSTransportBase;
import org.apache.cxf.transport.jms.PooledSession;
import org.apache.cxf.transport.jms.SessionPoolType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JMSConduit
extends AbstractConduit
implements Configurable,
JMSTransport {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".jms-conduit-base";
    private static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    protected final JMSTransportBase base;
    protected ClientConfig clientConfig;
    protected ClientBehaviorPolicyType runtimePolicy;
    protected AddressType address;
    protected SessionPoolType sessionPool;

    public JMSConduit(Bus b, EndpointInfo endpointInfo) {
        this(b, endpointInfo, null);
    }

    public JMSConduit(Bus b, EndpointInfo endpointInfo, EndpointReferenceType target) {
        super(target);
        this.base = new JMSTransportBase(b, endpointInfo, false, BASE_BEAN_NAME_SUFFIX, this);
        this.initConfig();
    }

    public void prepare(org.apache.cxf.message.Message message) throws IOException {
        this.getLogger().log(Level.FINE, "JMSConduit send message");
        try {
            if (null == this.base.sessionFactory) {
                JMSProviderHub.connect(this);
            }
        }
        catch (JMSException jmsex) {
            this.getLogger().log(Level.WARNING, "JMS connect failed with JMSException : ", jmsex);
            throw new IOException(jmsex.toString());
        }
        catch (NamingException ne) {
            this.getLogger().log(Level.WARNING, "JMS connect failed with NamingException : ", ne);
            throw new IOException(ne.toString());
        }
        if (this.base.sessionFactory == null) {
            throw new IllegalStateException("JMSClientTransport not connected");
        }
        try {
            boolean isOneWay = false;
            Exchange ex = message.getExchange();
            if (null != ex) {
                isOneWay = ex.isOneWay();
            }
            PooledSession pooledSession = this.base.sessionFactory.get(!isOneWay);
            message.put("jms.pooled.session", pooledSession);
        }
        catch (JMSException jmsex) {
            throw new IOException(jmsex.getMessage());
        }
        message.setContent(OutputStream.class, new JMSOutputStream(message));
    }

    public void close() {
        this.getLogger().log(Level.FINE, "JMSConduit closed ");
        if (this.base.sessionFactory != null) {
            this.base.sessionFactory.shutdown();
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    private Object receive(PooledSession pooledSession, org.apache.cxf.message.Message outMessage) throws JMSException {
        Object result = null;
        long timeout = this.getClientConfig().getClientReceiveTimeout();
        Long receiveTimeout = (Long)outMessage.get("org.apache.cxf.jms.client.timeout");
        if (receiveTimeout != null) {
            timeout = receiveTimeout;
        }
        Message jmsMessage = pooledSession.consumer().receive(timeout);
        this.getLogger().log(Level.FINE, "client received reply: ", jmsMessage);
        if (jmsMessage != null) {
            this.base.populateIncomingContext(jmsMessage, outMessage, "org.apache.cxf.jms.client.response.headers");
            result = this.base.unmarshal(jmsMessage);
            return result;
        }
        String error = "JMSClientTransport.receive() timed out. No message available.";
        this.getLogger().log(Level.SEVERE, error);
        throw new JMSException(error);
    }

    public void connected(javax.jms.Destination target, javax.jms.Destination reply, JMSSessionFactory factory) {
        this.base.connected(target, reply, factory);
    }

    public String getBeanName() {
        return this.base.endpointInfo.getName().toString() + ".jms-conduit";
    }

    private void initConfig() {
        this.address = this.base.endpointInfo.getTraversedExtensor(new AddressType(), AddressType.class);
        this.sessionPool = this.base.endpointInfo.getTraversedExtensor(new SessionPoolType(), SessionPoolType.class);
        this.clientConfig = this.base.endpointInfo.getTraversedExtensor(new ClientConfig(), ClientConfig.class);
        this.runtimePolicy = this.base.endpointInfo.getTraversedExtensor(new ClientBehaviorPolicyType(), ClientBehaviorPolicyType.class);
        Configurer configurer = this.base.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(this);
        }
    }

    private boolean isTextPayload() {
        return "text".equals(this.getRuntimePolicy().getMessageType().value());
    }

    public AddressType getJMSAddress() {
        return this.address;
    }

    public void setJMSAddress(AddressType a) {
        this.address = a;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public ClientBehaviorPolicyType getRuntimePolicy() {
        return this.runtimePolicy;
    }

    public void setRuntimePolicy(ClientBehaviorPolicyType runtimePolicy) {
        this.runtimePolicy = runtimePolicy;
    }

    public SessionPoolType getSessionPool() {
        return this.sessionPool;
    }

    public void setSessionPool(SessionPoolType sessionPool) {
        this.sessionPool = sessionPool;
    }

    protected class DecoupledDestination
    implements Destination {
        protected MessageObserver decoupledMessageObserver;
        private EndpointReferenceType address;

        DecoupledDestination(EndpointReferenceType ref, MessageObserver incomingObserver) {
            this.address = ref;
            this.decoupledMessageObserver = incomingObserver;
        }

        public EndpointReferenceType getAddress() {
            return this.address;
        }

        public Conduit getBackChannel(org.apache.cxf.message.Message inMessage, org.apache.cxf.message.Message partialResponse, EndpointReferenceType addr) throws IOException {
            return null;
        }

        public void shutdown() {
        }

        public synchronized void setMessageObserver(MessageObserver observer) {
            this.decoupledMessageObserver = observer;
        }

        public synchronized MessageObserver getMessageObserver() {
            return this.decoupledMessageObserver;
        }
    }

    private class JMSOutputStream
    extends CachedOutputStream {
        private org.apache.cxf.message.Message outMessage;
        private Message jmsMessage;
        private PooledSession pooledSession;
        private boolean isOneWay;

        public JMSOutputStream(org.apache.cxf.message.Message m) {
            this.outMessage = m;
            this.pooledSession = (PooledSession)this.outMessage.get("jms.pooled.session");
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            try {
                this.isOneWay = this.outMessage.getExchange().isOneWay();
                this.commitOutputMessage();
                if (!this.isOneWay) {
                    this.handleResponse();
                }
                JMSConduit.this.base.sessionFactory.recycle(this.pooledSession);
            }
            catch (JMSException jmsex) {
                JMSConduit.this.getLogger().log(Level.WARNING, "JMS connect failed with JMSException : ", jmsex);
                throw new IOException(jmsex.toString());
            }
        }

        protected void onWrite() throws IOException {
        }

        private void commitOutputMessage() throws JMSException {
            String id;
            javax.jms.Destination replyTo = this.pooledSession.destination();
            if (this.isOneWay && JMSConduit.this.getJMSAddress().getJndiReplyDestinationName() == null) {
                replyTo = null;
            }
            Object request = null;
            try {
                if (JMSConduit.this.isTextPayload()) {
                    StringBuilder builder = new StringBuilder(2048);
                    this.writeCacheTo(builder);
                    request = builder.toString();
                } else {
                    request = this.getBytes();
                }
            }
            catch (IOException ex) {
                JMSException ex2 = new JMSException("Error creating request");
                ex2.setLinkedException((Exception)ex);
                throw ex2;
            }
            if (JMSConduit.this.getLogger().isLoggable(Level.FINE)) {
                JMSConduit.this.getLogger().log(Level.FINE, "Conduit Request is :[" + request + "]");
            }
            this.jmsMessage = JMSConduit.this.base.marshal(request, this.pooledSession.session(), replyTo, JMSConduit.this.getRuntimePolicy().getMessageType().value());
            JMSMessageHeadersType headers = (JMSMessageHeadersType)this.outMessage.get("org.apache.cxf.jms.client.request.headers");
            int deliveryMode = JMSConduit.this.base.getJMSDeliveryMode(headers);
            int priority = JMSConduit.this.base.getJMSPriority(headers);
            String correlationID = JMSConduit.this.base.getCorrelationId(headers);
            long ttl = JMSConduit.this.base.getTimeToLive(headers);
            if (ttl <= 0L) {
                ttl = JMSConduit.this.getClientConfig().getMessageTimeToLive();
            }
            JMSConduit.this.base.setMessageProperties(headers, this.jmsMessage);
            Map<String, List<String>> protHeaders = CastUtils.cast((Map)this.outMessage.get(org.apache.cxf.message.Message.PROTOCOL_HEADERS));
            JMSConduit.this.base.addProtocolHeaders(this.jmsMessage, protHeaders);
            if (!this.isOneWay && (id = this.pooledSession.getCorrelationID()) != null) {
                if (correlationID != null) {
                    String error = "User cannot set JMSCorrelationID when making a request/reply invocation using a static replyTo Queue.";
                    throw new JMSException(error);
                }
                correlationID = id;
            }
            if (correlationID != null) {
                this.jmsMessage.setJMSCorrelationID(correlationID);
            }
            JMSConduit.this.getLogger().log(Level.FINE, "client sending request: ", this.jmsMessage);
            if (JMSConduit.this.base.isDestinationStyleQueue()) {
                QueueSender sender = (QueueSender)this.pooledSession.producer();
                sender.setTimeToLive(ttl);
                sender.send((Queue)JMSConduit.this.base.targetDestination, this.jmsMessage, deliveryMode, priority, ttl);
            } else {
                TopicPublisher publisher = (TopicPublisher)this.pooledSession.producer();
                publisher.setTimeToLive(ttl);
                publisher.publish((Topic)JMSConduit.this.base.targetDestination, this.jmsMessage, deliveryMode, priority, ttl);
            }
        }

        private void handleResponse() throws IOException {
            Object response = null;
            MessageImpl inMessage = new MessageImpl();
            this.outMessage.getExchange().setInMessage(inMessage);
            try {
                response = JMSConduit.this.receive(this.pooledSession, this.outMessage);
            }
            catch (JMSException jmsex) {
                JMSConduit.this.getLogger().log(Level.FINE, "JMS connect failed with JMSException : ", jmsex);
                throw new IOException(jmsex.toString());
            }
            inMessage.put("org.apache.cxf.jms.client.response.headers", this.outMessage.get("org.apache.cxf.jms.client.response.headers"));
            JMSConduit.this.getLogger().log(Level.FINE, "The Response Message is : [" + response + "]");
            byte[] bytes = null;
            if (response instanceof String) {
                String requestString = (String)response;
                bytes = requestString.getBytes();
            } else {
                bytes = (byte[])response;
            }
            inMessage.setContent(InputStream.class, new ByteArrayInputStream(bytes));
            JMSConduit.this.getLogger().log(Level.FINE, "incoming observer is " + JMSConduit.this.incomingObserver);
            JMSConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

