/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractObservable;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public abstract class AbstractDestination
extends AbstractObservable
implements Destination {
    protected final EndpointReferenceType reference;
    protected final EndpointInfo endpointInfo;
    protected final Bus bus;

    public AbstractDestination(EndpointReferenceType ref, EndpointInfo ei) {
        this(null, ref, ei);
    }

    public AbstractDestination(Bus b, EndpointReferenceType ref, EndpointInfo ei) {
        this.reference = ref;
        this.endpointInfo = ei;
        this.bus = b;
    }

    public EndpointReferenceType getAddress() {
        return this.reference;
    }

    public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType address) throws IOException {
        EndpointReferenceType target;
        Conduit backChannel = null;
        Exchange ex = inMessage.getExchange();
        EndpointReferenceType endpointReferenceType = target = address != null ? address : ex.get(EndpointReferenceType.class);
        if (target == null) {
            backChannel = this.getInbuiltBackChannel(inMessage);
        } else if (partialResponse != null) {
            if (this.markPartialResponse(partialResponse, target)) {
                backChannel = this.getInbuiltBackChannel(inMessage);
            }
        } else {
            ConduitInitiator conduitInitiator = this.getConduitInitiator();
            if (conduitInitiator != null) {
                backChannel = conduitInitiator.getConduit(this.endpointInfo, target);
                backChannel.setMessageObserver(new MessageObserver(){

                    public void onMessage(Message m) {
                        if (m.getContentFormats().contains(InputStream.class)) {
                            InputStream is = m.getContent(InputStream.class);
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }
        return backChannel;
    }

    public void shutdown() {
    }

    protected boolean markPartialResponse(Message partialResponse, EndpointReferenceType decoupledTarget) {
        return false;
    }

    protected ConduitInitiator getConduitInitiator() {
        return null;
    }

    protected abstract Conduit getInbuiltBackChannel(Message var1);

    protected abstract class AbstractBackChannelConduit
    extends AbstractConduit {
        public AbstractBackChannelConduit() {
            super(EndpointReferenceUtils.getAnonymousEndpointReference());
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        protected Logger getLogger() {
            return AbstractDestination.this.getLogger();
        }
    }
}

