/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.tools.wsdlto.databinding.jaxb;
import com.sun.tools.xjc.api.ErrorListener;

import org.apache.cxf.tools.common.ToolException;

public class JAXBBindErrorListener implements ErrorListener {
    private boolean isVerbose;
    private String prefix = "Thrown by JAXB : ";

    public JAXBBindErrorListener(boolean verbose) {
        isVerbose = verbose;
    }

    public void error(org.xml.sax.SAXParseException exception) {
        throw new ToolException(prefix + exception.getLocalizedMessage(), exception);

    }

    public void fatalError(org.xml.sax.SAXParseException exception) {
        throw new ToolException(prefix + exception.getLocalizedMessage(), exception);
    }

    public void info(org.xml.sax.SAXParseException exception) {
        if (this.isVerbose) {
            System.out.println("JAXB Info: " + exception.toString());
        }
    }

    public void warning(org.xml.sax.SAXParseException exception) {
        if (this.isVerbose) {
            System.err.println("JAXB parsing schema warning " + exception.toString());
        }
    }
}
