/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.CertificateConstraintsType;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.apache.cxf.transport.http.CXFAuthenticator;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.DigestAuthSupplier;
import org.apache.cxf.transport.http.HttpAuthSupplier;
import org.apache.cxf.transport.http.HttpBasicAuthSupplier;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.HttpURLConnectionInfo;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.PatternBuilder;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transport.https.CertConstraints;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;
import org.apache.cxf.transport.https.CertConstraintsJaxBUtils;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.apache.cxf.version.Version;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConduit
extends AbstractConduit
implements Configurable,
Assertor {
    public static final String KEY_HTTP_CONNECTION = "http.connection";
    private static final String KEY_VISITED_URLS = "VisitedURLs";
    private static final String KEY_AUTH_URLS = "AuthURLs";
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
    private static final String SC_HTTP_CONDUIT_SUFFIX = ".http-conduit";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    protected HttpURLConnectionFactory connectionFactory;
    private final Bus bus;
    private final EndpointInfo endpointInfo;
    private URL defaultEndpointURL;
    private String defaultEndpointURLString;
    private boolean fromEndpointReferenceType;
    private Destination decoupledDestination;
    private MessageObserver decoupledObserver;
    private int decoupledDestinationRefCount;
    private HTTPClientPolicy clientSidePolicy;
    private HTTPClientPolicy systemProxyConfiguration;
    private AuthorizationPolicy authorizationPolicy;
    private ProxyAuthorizationPolicy proxyAuthorizationPolicy;
    private TLSClientParameters tlsClientParameters;
    private MessageTrustDecider trustDecider;
    private HttpAuthSupplier authSupplier;
    private boolean configFinalized;
    private Map<String, Cookie> sessionCookies = new ConcurrentHashMap<String, Cookie>();
    private boolean maintainSession;
    private CertConstraints certConstraints;

    public HTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        this(b, ei, null);
    }

    public HTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(HTTPConduit.getTargetReference(ei, t, b));
        this.bus = b;
        this.endpointInfo = ei;
        if (t != null) {
            this.fromEndpointReferenceType = true;
        }
        this.initializeConfig();
        CXFAuthenticator.addAuthenticator();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public final String getConduitName() {
        return this.endpointInfo.getName() + SC_HTTP_CONDUIT_SUFFIX;
    }

    private void initializeConfig() {
        PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
        if (null != pe && pe.isEnabled() && this.endpointInfo.getService() != null) {
            this.clientSidePolicy = PolicyUtils.getClient(pe, this.endpointInfo, this);
        }
    }

    protected void finalizeConfig() {
        String proxyHost;
        if (this.clientSidePolicy == null) {
            this.clientSidePolicy = this.endpointInfo.getTraversedExtensor(new HTTPClientPolicy(), HTTPClientPolicy.class);
        }
        if (this.authorizationPolicy == null) {
            this.authorizationPolicy = this.endpointInfo.getTraversedExtensor(new AuthorizationPolicy(), AuthorizationPolicy.class);
        }
        if (this.proxyAuthorizationPolicy == null) {
            this.proxyAuthorizationPolicy = this.endpointInfo.getTraversedExtensor(new ProxyAuthorizationPolicy(), ProxyAuthorizationPolicy.class);
        }
        if (this.tlsClientParameters == null) {
            this.tlsClientParameters = this.endpointInfo.getTraversedExtensor(null, TLSClientParameters.class);
        }
        if (this.trustDecider == null) {
            this.trustDecider = this.endpointInfo.getTraversedExtensor(null, MessageTrustDecider.class);
        }
        if (this.authSupplier == null) {
            this.authSupplier = this.endpointInfo.getTraversedExtensor(null, HttpAuthSupplier.class);
        }
        if (this.trustDecider == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No Trust Decider configured for Conduit '" + this.getConduitName() + "'");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Message Trust Decider of class '" + this.trustDecider.getClass().getName() + "' with logical name of '" + this.trustDecider.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.authSupplier == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No Auth Supplier configured for Conduit '" + this.getConduitName() + "'");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "HttpAuthSupplier of class '" + this.authSupplier.getClass().getName() + "' with logical name of '" + this.authSupplier.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.tlsClientParameters != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for TLS " + "keyManagers " + Arrays.toString(this.tlsClientParameters.getKeyManagers()) + "trustManagers " + Arrays.toString(this.tlsClientParameters.getTrustManagers()) + "secureRandom " + this.tlsClientParameters.getSecureRandom() + "Disable Common Name (CN) Check: " + this.tlsClientParameters.isDisableCNCheck());
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for plain http.");
        }
        if ((proxyHost = System.getProperty(HTTP_PROXY_HOST)) != null) {
            this.systemProxyConfiguration = new HTTPClientPolicy();
            this.systemProxyConfiguration.setProxyServer(proxyHost);
            this.systemProxyConfiguration.setProxyServerType(ProxyServerType.HTTP);
            String proxyPort = System.getProperty(HTTP_PROXY_PORT, "8080");
            this.systemProxyConfiguration.setProxyServerPort(Integer.valueOf(proxyPort));
            String nonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
            if (!StringUtils.isEmpty(nonProxyHosts)) {
                Pattern pattern = PatternBuilder.build(nonProxyHosts);
                this.systemProxyConfiguration.setNonProxyHosts(pattern);
            }
        }
        this.retrieveConnectionFactory(this.getAddress());
        this.configFinalized = true;
    }

    public Map<String, Cookie> getCookies() {
        return this.sessionCookies;
    }

    protected synchronized void retrieveConnectionFactory() {
        this.connectionFactory = AbstractHTTPTransportFactory.getConnectionFactory(this, this.getAddress());
    }

    protected synchronized void retrieveConnectionFactory(String url) {
        this.connectionFactory = AbstractHTTPTransportFactory.getConnectionFactory(this, url);
    }

    protected synchronized HttpURLConnectionFactory getConnectionFactory(URL url) {
        if (this.connectionFactory == null || !url.getProtocol().equals(this.connectionFactory.getProtocol())) {
            this.retrieveConnectionFactory(url.toString());
        }
        return this.connectionFactory;
    }

    @Override
    public void prepare(Message message) throws IOException {
        Object obj;
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        URL currentURL = this.setupURL(message);
        boolean needToCacheRequest = false;
        HTTPClientPolicy csPolicy = this.getClient(message);
        HttpURLConnectionFactory f = this.getConnectionFactory(currentURL);
        HttpURLConnection connection = f.createConnection(this.getProxy(csPolicy, currentURL), currentURL);
        connection.setDoOutput(true);
        long timeout = csPolicy.getConnectionTimeout();
        if (message.get("javax.xml.ws.client.connectionTimeout") != null) {
            obj = message.get("javax.xml.ws.client.connectionTimeout");
            try {
                timeout = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_FORMAT", new Object[]{"javax.xml.ws.client.connectionTimeout", obj.toString()});
            }
        }
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        connection.setConnectTimeout((int)timeout);
        timeout = csPolicy.getReceiveTimeout();
        if (message.get("javax.xml.ws.client.receiveTimeout") != null) {
            obj = message.get("javax.xml.ws.client.receiveTimeout");
            try {
                timeout = Long.parseLong(obj.toString());
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, "INVALID_TIMEOUT_FORMAT", new Object[]{"javax.xml.ws.client.receiveTimeout", obj.toString()});
            }
        }
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        connection.setReadTimeout((int)timeout);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get("org.apache.cxf.request.method");
        if (null != httpRequestMethod) {
            connection.setRequestMethod(httpRequestMethod);
        } else {
            connection.setRequestMethod("POST");
        }
        boolean isChunking = false;
        int chunkThreshold = 0;
        if (this.authSupplier != null) {
            String auth = this.authSupplier.getPreemptiveAuthorization(this, currentURL, message);
            if (auth == null || this.authSupplier.requiresRequestCaching()) {
                needToCacheRequest = true;
                isChunking = false;
                LOG.log(Level.FINE, "Auth Supplier, but no Premeptive User Pass or Digest auth (nonce may be stale) We must cache request.");
            }
            message.put("AUTH_VALUE", auth);
        }
        if (csPolicy.isAutoRedirect()) {
            needToCacheRequest = true;
            LOG.log(Level.FINE, "AutoRedirect is turned on.");
        }
        if (csPolicy.getMaxRetransmits() > 0) {
            needToCacheRequest = true;
            LOG.log(Level.FINE, "MaxRetransmits is set > 0.");
        }
        if (connection.getRequestMethod().equals("POST") && csPolicy.isAllowChunking()) {
            isChunking = true;
            chunkThreshold = csPolicy.getChunkingThreshold();
            if (chunkThreshold <= 0) {
                chunkThreshold = 0;
                connection.setChunkedStreamingMode(-1);
            }
        }
        this.maintainSession = Boolean.TRUE.equals((Boolean)message.get(Message.MAINTAIN_SESSION));
        if (this.maintainSession && this.sessionCookies.size() > 0) {
            List<Object> cookies = null;
            for (String s : headers.keySet()) {
                if (!"Cookie".equalsIgnoreCase(s)) continue;
                cookies = headers.remove(s);
                break;
            }
            cookies = cookies == null ? new ArrayList() : new ArrayList(cookies);
            headers.put("Cookie", cookies);
            for (Cookie c : this.sessionCookies.values()) {
                cookies.add(c.requestCookieHeader());
            }
        }
        message.put(KEY_HTTP_CONNECTION, connection);
        if (this.certConstraints != null) {
            message.put(CertConstraints.class.getName(), this.certConstraints);
            message.getInterceptorChain().add(CertConstraintsInterceptor.INSTANCE);
        }
        this.setHeadersByPolicy(message, currentURL, headers);
        message.setContent(OutputStream.class, new WrappedOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Message msg) throws IOException {
        InputStream in = msg.getContent(InputStream.class);
        try {
            if (in != null) {
                byte[] buffer = new byte[1024];
                for (int count = 0; in.read(buffer) != -1 && count < 25; ++count) {
                }
            }
        }
        finally {
            super.close(msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeTrustDecision(Message message, HttpURLConnection connection) throws IOException {
        MessageTrustDecider decider2 = message.get(MessageTrustDecider.class);
        if (this.trustDecider != null || decider2 != null) {
            try {
                connection.connect();
                HttpURLConnectionInfo info = this.getConnectionFactory(connection.getURL()).getConnectionInfo(connection);
                if (this.trustDecider != null) {
                    this.trustDecider.establishTrust(this.getConduitName(), info, message);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Trust Decider " + this.trustDecider.getLogicalName() + " considers Conduit " + this.getConduitName() + " trusted.");
                    }
                }
                if (decider2 == null) return;
                decider2.establishTrust(this.getConduitName(), info, message);
                if (!LOG.isLoggable(Level.FINE)) return;
                LOG.log(Level.FINE, "Trust Decider " + decider2.getLogicalName() + " considers Conduit " + this.getConduitName() + " trusted.");
                return;
            }
            catch (UntrustedURLConnectionIOException untrustedEx) {
                connection.disconnect();
                if (!LOG.isLoggable(Level.FINE)) throw untrustedEx;
                LOG.log(Level.FINE, "Trust Decider " + this.trustDecider.getLogicalName() + " considers Conduit " + this.getConduitName() + " untrusted.", untrustedEx);
                throw untrustedEx;
            }
        } else {
            if (!LOG.isLoggable(Level.FINE)) return;
            LOG.log(Level.FINE, "No Trust Decider for Conduit '" + this.getConduitName() + "'. An afirmative Trust Decision is assumed.");
        }
    }

    private URL setupURL(Message message) throws MalformedURLException {
        String result = (String)message.get(Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get(Message.PATH_INFO);
        String queryString = (String)message.get(Message.QUERY_STRING);
        if (result == null) {
            if (pathInfo == null && queryString == null) {
                URL url = this.getURL();
                message.put(Message.ENDPOINT_ADDRESS, this.defaultEndpointURLString);
                return url;
            }
            result = this.getURL().toString();
            message.put(Message.ENDPOINT_ADDRESS, result);
        }
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return new URL(result);
    }

    @Override
    public synchronized Destination getBackChannel() {
        if (this.decoupledDestination == null && this.getClient().getDecoupledEndpoint() != null) {
            this.setUpDecoupledDestination();
        }
        return this.decoupledDestination;
    }

    @Override
    public void close() {
        if (this.defaultEndpointURL != null) {
            try {
                URLConnection connect = this.defaultEndpointURL.openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.decoupledDestination != null) {
            this.releaseDecoupledDestination();
        }
    }

    protected String getAddress() {
        if (this.defaultEndpointURL != null) {
            return this.defaultEndpointURLString;
        }
        if (this.fromEndpointReferenceType) {
            return this.getTarget().getAddress().getValue();
        }
        return this.endpointInfo.getAddress();
    }

    protected URL getURL() throws MalformedURLException {
        if (this.defaultEndpointURL == null) {
            return this.getURL(true);
        }
        return this.defaultEndpointURL;
    }

    protected synchronized URL getURL(boolean createOnDemand) throws MalformedURLException {
        if (this.defaultEndpointURL == null && createOnDemand) {
            if (this.fromEndpointReferenceType && this.getTarget().getAddress().getValue() != null) {
                this.defaultEndpointURL = new URL(this.getTarget().getAddress().getValue());
                this.defaultEndpointURLString = this.defaultEndpointURL.toExternalForm();
                return this.defaultEndpointURL;
            }
            if (this.endpointInfo.getAddress() == null) {
                throw new MalformedURLException("Invalid address. Endpoint address cannot be null.");
            }
            this.defaultEndpointURL = new URL(this.endpointInfo.getAddress());
            this.defaultEndpointURLString = this.defaultEndpointURL.toExternalForm();
        }
        return this.defaultEndpointURL;
    }

    private Map<String, List<String>> getSetProtocolHeaders(Message message) {
        Map<String, List<String>> headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (null == headers) {
            headers = new LinkedHashMap();
        } else if (headers instanceof HashMap) {
            headers = new LinkedHashMap(headers);
        }
        message.put(Message.PROTOCOL_HEADERS, headers);
        return headers;
    }

    private void transferProtocolHeadersToURLConnection(Message message, URLConnection connection) {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        for (String header : headers.keySet()) {
            List<String> headerList = headers.get(header);
            if ("Content-Type".equalsIgnoreCase(header)) continue;
            if ("Cookie".equalsIgnoreCase(header)) {
                for (String s : headerList) {
                    connection.addRequestProperty("Cookie", s);
                }
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < headerList.size(); ++i) {
                b.append(headerList.get(i));
                if (i + 1 >= headerList.size()) continue;
                b.append(',');
            }
            connection.setRequestProperty(header, b.toString());
        }
        if (!connection.getRequestProperties().containsKey("User-Agent")) {
            connection.addRequestProperty("User-Agent", Version.getCompleteVersionString());
        }
    }

    private void logProtocolHeaders(Level level, Message message) {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        for (String header : headers.keySet()) {
            List<String> headerList = headers.get(header);
            for (String value : headerList) {
                LOG.log(level, header + ": " + value);
            }
        }
    }

    private void setURLRequestHeaders(Message message) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.get(KEY_HTTP_CONNECTION);
        String ct = (String)message.get("Content-Type");
        String enc = (String)message.get(Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
                ct = ct + "; charset=" + enc;
            }
        } else {
            ct = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        connection.setRequestProperty("Content-Type", ct);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + connection.getRequestMethod() + " Message with Headers to " + connection.getURL() + " Conduit :" + this.getConduitName() + "\nContent-Type: " + ct + "\n");
            this.logProtocolHeaders(Level.FINE, message);
        }
        this.transferProtocolHeadersToURLConnection(message, connection);
    }

    private void setUpDecoupledDestination() {
        EndpointReferenceType reference = EndpointReferenceUtils.getEndpointReference(this.getClient().getDecoupledEndpoint());
        if (reference != null) {
            String decoupledAddress = reference.getAddress().getValue();
            LOG.info("creating decoupled endpoint: " + decoupledAddress);
            try {
                this.decoupledDestination = this.getDestination(decoupledAddress);
                this.duplicateDecoupledDestination();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "decoupled endpoint creation failed: ", e);
            }
        }
    }

    private Destination getDestination(String address) throws IOException {
        Destination destination = null;
        DestinationFactoryManager factoryManager = this.bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory factory = factoryManager.getDestinationFactoryForUri(address);
        if (factory != null) {
            EndpointInfo ei = new EndpointInfo();
            ei.setAddress(address);
            destination = factory.getDestination(ei);
            this.decoupledObserver = new InterposedMessageObserver();
            destination.setMessageObserver(this.decoupledObserver);
        }
        return destination;
    }

    protected MessageObserver getDecoupledObserver() {
        return this.decoupledObserver;
    }

    private synchronized void duplicateDecoupledDestination() {
        ++this.decoupledDestinationRefCount;
    }

    private synchronized void releaseDecoupledDestination() {
        if (--this.decoupledDestinationRefCount == 0) {
            LOG.log(Level.FINE, "shutting down decoupled destination");
            this.decoupledDestination.shutdown();
            this.decoupledDestination.setMessageObserver(null);
        }
    }

    private boolean isOneway(Exchange exchange) {
        return exchange != null && exchange.isOneWay();
    }

    private boolean isDecoupled() {
        return this.decoupledDestination != null;
    }

    protected static InputStream getPartialResponse(HttpURLConnection connection, int responseCode) throws IOException {
        InputStream in = null;
        if (responseCode == 202 || responseCode == 200) {
            if (connection.getContentLength() > 0) {
                in = connection.getInputStream();
            } else if (HTTPConduit.hasChunkedResponse(connection) || HTTPConduit.hasEofTerminatedResponse(connection)) {
                in = HTTPConduit.getNonEmptyContent(connection);
            }
        }
        return in;
    }

    private static boolean hasChunkedResponse(HttpURLConnection connection) {
        return "chunked".equalsIgnoreCase(connection.getHeaderField("Transfer-Encoding"));
    }

    private static boolean hasEofTerminatedResponse(HttpURLConnection connection) {
        return "close".equalsIgnoreCase(connection.getHeaderField("Connection"));
    }

    private static InputStream getNonEmptyContent(HttpURLConnection connection) {
        PushbackInputStream in = null;
        try {
            PushbackInputStream pin = new PushbackInputStream(connection.getInputStream());
            int c = pin.read();
            if (c != -1) {
                pin.unread((byte)c);
                in = pin;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return in;
    }

    private Proxy getProxy(HTTPClientPolicy policy, URL currentUrl) {
        if (policy != null) {
            if (policy.isSetProxyServer() && !StringUtils.isEmpty(policy.getProxyServer())) {
                return this.getProxy(policy, currentUrl.getHost());
            }
            return this.getSystemProxy(currentUrl.getHost());
        }
        return this.getSystemProxy(currentUrl.getHost());
    }

    private Proxy getSystemProxy(String hostname) {
        if (this.systemProxyConfiguration != null) {
            return this.getProxy(this.systemProxyConfiguration, hostname);
        }
        return null;
    }

    private Proxy getProxy(HTTPClientPolicy policy, String hostname) {
        Pattern pattern;
        if (policy.isSetNonProxyHosts() && (pattern = policy.getNonProxyHosts()).matcher(hostname).matches()) {
            return null;
        }
        return this.createProxy(policy);
    }

    private Proxy createProxy(HTTPClientPolicy policy) {
        return new Proxy(Proxy.Type.valueOf(policy.getProxyServerType().toString()), new InetSocketAddress(policy.getProxyServer(), policy.getProxyServerPort()));
    }

    private void setHeadersByAuthorizationPolicy(Message message, URL url, Map<String, List<String>> headers) {
        AuthorizationPolicy authPolicy = this.getAuthorization();
        AuthorizationPolicy newPolicy = message.get(AuthorizationPolicy.class);
        String authString = null;
        if (this.authSupplier != null && (newPolicy == null || !"Basic".equals(newPolicy.getAuthorizationType()) && newPolicy.getAuthorization() == null)) {
            authString = (String)message.get("AUTH_VALUE");
            if (authString == null) {
                authString = this.authSupplier.getPreemptiveAuthorization(this, url, message);
            } else {
                message.remove("AUTH_VALUE");
            }
            if (authString != null) {
                headers.put("Authorization", HTTPConduit.createMutableList(authString));
            }
            return;
        }
        String userName = null;
        String passwd = null;
        if (null != newPolicy) {
            userName = newPolicy.getUserName();
            passwd = newPolicy.getPassword();
        }
        if (userName == null && authPolicy != null && authPolicy.isSetUserName()) {
            userName = authPolicy.getUserName();
        }
        if (userName != null) {
            if (passwd == null && authPolicy != null && authPolicy.isSetPassword()) {
                passwd = authPolicy.getPassword();
            }
            this.setBasicAuthHeader(userName, passwd, headers);
        } else if (authPolicy != null && authPolicy.isSetAuthorizationType() && authPolicy.isSetAuthorization()) {
            String type = authPolicy.getAuthorizationType();
            type = type + " ";
            type = type + authPolicy.getAuthorization();
            headers.put("Authorization", HTTPConduit.createMutableList(type));
        }
        ProxyAuthorizationPolicy proxyAuthPolicy = this.getProxyAuthorization();
        if (proxyAuthPolicy != null && proxyAuthPolicy.isSetUserName()) {
            userName = proxyAuthPolicy.getUserName();
            if (userName != null) {
                passwd = "";
                if (proxyAuthPolicy.isSetPassword()) {
                    passwd = proxyAuthPolicy.getPassword();
                }
                this.setProxyBasicAuthHeader(userName, passwd, headers);
            } else if (proxyAuthPolicy.isSetAuthorizationType() && proxyAuthPolicy.isSetAuthorization()) {
                String type = proxyAuthPolicy.getAuthorizationType();
                type = type + " ";
                type = type + proxyAuthPolicy.getAuthorization();
                headers.put("Proxy-Authorization", HTTPConduit.createMutableList(type));
            }
        }
    }

    private static List<String> createMutableList(String val) {
        return new ArrayList<String>(Arrays.asList(val));
    }

    private void setHeadersByClientPolicy(Message message, Map<String, List<String>> headers) {
        HTTPClientPolicy policy = this.getClient(message);
        if (policy == null) {
            return;
        }
        if (policy.isSetCacheControl()) {
            headers.put("Cache-Control", HTTPConduit.createMutableList(policy.getCacheControl().value()));
        }
        if (policy.isSetHost()) {
            headers.put("Host", HTTPConduit.createMutableList(policy.getHost()));
        }
        if (policy.isSetConnection()) {
            headers.put("Connection", HTTPConduit.createMutableList(policy.getConnection().value()));
        }
        if (policy.isSetAccept()) {
            headers.put("Accept", HTTPConduit.createMutableList(policy.getAccept()));
        } else if (!headers.containsKey("Accept")) {
            headers.put("Accept", HTTPConduit.createMutableList("*/*"));
        }
        if (policy.isSetAcceptEncoding()) {
            headers.put("Accept-Encoding", HTTPConduit.createMutableList(policy.getAcceptEncoding()));
        }
        if (policy.isSetAcceptLanguage()) {
            headers.put("Accept-Language", HTTPConduit.createMutableList(policy.getAcceptLanguage()));
        }
        if (policy.isSetContentType()) {
            message.put("Content-Type", policy.getContentType());
        }
        if (policy.isSetCookie()) {
            headers.put("Cookie", HTTPConduit.createMutableList(policy.getCookie()));
        }
        if (policy.isSetBrowserType()) {
            headers.put("BrowserType", HTTPConduit.createMutableList(policy.getBrowserType()));
        }
        if (policy.isSetReferer()) {
            headers.put("Referer", HTTPConduit.createMutableList(policy.getReferer()));
        }
    }

    private void setHeadersByPolicy(Message message, URL url, Map<String, List<String>> headers) {
        this.setHeadersByAuthorizationPolicy(message, url, headers);
        this.setHeadersByClientPolicy(message, headers);
    }

    @Override
    public String getBeanName() {
        if (this.endpointInfo.getName() != null) {
            return this.endpointInfo.getName().toString() + SC_HTTP_CONDUIT_SUFFIX;
        }
        return null;
    }

    public AuthorizationPolicy getAuthorization() {
        return this.authorizationPolicy;
    }

    public void setAuthorization(AuthorizationPolicy authorization) {
        this.authorizationPolicy = authorization;
    }

    public HTTPClientPolicy getClient(Message message) {
        return PolicyUtils.getClient(message, this.clientSidePolicy);
    }

    public HTTPClientPolicy getClient() {
        return this.clientSidePolicy;
    }

    public void setClient(HTTPClientPolicy client) {
        this.clientSidePolicy = client;
    }

    public ProxyAuthorizationPolicy getProxyAuthorization() {
        return this.proxyAuthorizationPolicy;
    }

    public void setProxyAuthorization(ProxyAuthorizationPolicy proxyAuthorization) {
        this.proxyAuthorizationPolicy = proxyAuthorization;
    }

    public TLSClientParameters getTlsClientParameters() {
        return this.tlsClientParameters;
    }

    public void setTlsClientParameters(TLSClientParameters params) {
        this.tlsClientParameters = params;
        if (this.tlsClientParameters != null) {
            CertificateConstraintsType constraints;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re) configured for TLS " + "keyManagers " + Arrays.toString(this.tlsClientParameters.getKeyManagers()) + "trustManagers " + Arrays.toString(this.tlsClientParameters.getTrustManagers()) + "secureRandom " + this.tlsClientParameters.getSecureRandom());
            }
            if ((constraints = params.getCertConstraints()) != null) {
                this.certConstraints = CertConstraintsJaxBUtils.createCertConstraints(constraints);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re)configured for plain http.");
        }
        if (this.configFinalized) {
            this.retrieveConnectionFactory(this.getAddress());
        }
    }

    public MessageTrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    public void setTrustDecider(MessageTrustDecider decider) {
        this.trustDecider = decider;
    }

    public HttpAuthSupplier getAuthSupplier() {
        return this.authSupplier;
    }

    public void setAuthSupplier(HttpAuthSupplier supplier) {
        this.authSupplier = supplier;
    }

    private HttpURLConnection processRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        int responseCode = connection.getResponseCode();
        if (message != null && message.getExchange() != null) {
            message.getExchange().put(Message.RESPONSE_CODE, responseCode);
        }
        switch (responseCode) {
            case 301: 
            case 302: {
                connection = this.redirectRetransmit(connection, message, cachedStream);
                break;
            }
            case 401: {
                connection = this.authorizationRetransmit(connection, message, cachedStream);
                break;
            }
        }
        return connection;
    }

    private HttpURLConnection redirectRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (!this.getClient(message).isAutoRedirect()) {
            return connection;
        }
        Set<String> visitedURLs = this.getSetVisitedURLs(message);
        String lastURL = connection.getURL().toString();
        visitedURLs.add(lastURL);
        String newURL = this.extractLocation(connection.getHeaderFields());
        if (newURL != null) {
            if (visitedURLs.contains(newURL)) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Redirect loop detected on Conduit \"" + this.getConduitName() + "\" on '" + newURL + "'");
                }
                throw new IOException("Redirect loop detected on Conduit \"" + this.getConduitName() + "\" on '" + newURL + "'");
            }
            Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
            headers.remove("Authorization");
            headers.remove("Proxy-Authorization");
            URL url = new URL(newURL);
            this.setHeadersByAuthorizationPolicy(message, url, headers);
            connection = this.retransmit(connection, url, message, cachedStream);
        }
        return connection;
    }

    private Set<String> getSetAuthoriationURLs(Message message) {
        HashSet authURLs = (HashSet)message.get(KEY_AUTH_URLS);
        if (authURLs == null) {
            authURLs = new HashSet();
            message.put(KEY_AUTH_URLS, authURLs);
        }
        return authURLs;
    }

    private Set<String> getSetVisitedURLs(Message message) {
        HashSet visitedURLs = (HashSet)message.get(KEY_VISITED_URLS);
        if (visitedURLs == null) {
            visitedURLs = new HashSet();
            message.put(KEY_VISITED_URLS, visitedURLs);
        }
        return visitedURLs;
    }

    private HttpURLConnection authorizationRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (this.authSupplier == null) {
            String auth = connection.getHeaderField("WWW-Authenticate");
            if (auth.startsWith("Digest ")) {
                this.authSupplier = new DigestAuthSupplier();
            } else {
                return connection;
            }
        }
        URL currentURL = connection.getURL();
        String realm = this.extractAuthorizationRealm(connection.getHeaderFields());
        Set<String> authURLs = this.getSetAuthoriationURLs(message);
        if (authURLs.contains(currentURL.toString() + realm)) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Authorization loop detected on Conduit \"" + this.getConduitName() + "\" on URL \"" + "\" with realm \"" + realm + "\"");
            }
            throw new IOException("Authorization loop detected on Conduit \"" + this.getConduitName() + "\" on URL \"" + "\" with realm \"" + realm + "\"");
        }
        String up = this.authSupplier.getAuthorizationForRealm(this, currentURL, message, realm, connection.getHeaderField("WWW-Authenticate"));
        if (up == null) {
            return connection;
        }
        authURLs.add(currentURL.toString() + realm);
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        headers.put("Authorization", HTTPConduit.createMutableList(up));
        return this.retransmit(connection, currentURL, message, cachedStream);
    }

    private HttpURLConnection retransmit(HttpURLConnection connection, URL newURL, Message message, CacheAndWriteOutputStream stream) throws IOException {
        connection.disconnect();
        HTTPClientPolicy cp = this.getClient(message);
        connection = this.getConnectionFactory(newURL).createConnection(this.getProxy(cp, newURL), newURL);
        connection.setDoOutput(true);
        connection.setConnectTimeout((int)cp.getConnectionTimeout());
        connection.setReadTimeout((int)cp.getReceiveTimeout());
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get("org.apache.cxf.request.method");
        if (null != httpRequestMethod) {
            connection.setRequestMethod(httpRequestMethod);
        } else {
            connection.setRequestMethod("POST");
        }
        message.put(KEY_HTTP_CONNECTION, connection);
        connection.setFixedLengthStreamingMode(stream.size());
        this.setURLRequestHeaders(message);
        this.makeTrustDecision(message, connection);
        if (connection.getRequestMethod().equals("GET")) {
            return connection;
        }
        OutputStream out = connection.getOutputStream();
        stream.writeCacheTo(out);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Conduit \"" + this.getConduitName() + "\" Retransmit message to: " + connection.getURL() + ": " + new String(stream.getBytes()));
        }
        return connection;
    }

    private String extractAuthorizationRealm(Map<String, List<String>> headers) {
        List<String> auth = headers.get("WWW-Authenticate");
        if (auth != null) {
            for (String a : auth) {
                int idx = a.indexOf("realm=");
                if (idx == -1) continue;
                if ((a = a.substring(idx + 6)).charAt(0) == '\"') {
                    a = a.substring(1, a.indexOf(34, 1));
                } else if (a.contains(",")) {
                    a = a.substring(0, a.indexOf(44));
                }
                return a;
            }
        }
        return null;
    }

    private String extractLocation(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> head : headers.entrySet()) {
            List<String> locs;
            if (!"Location".equalsIgnoreCase(head.getKey()) || (locs = head.getValue()) == null || locs.size() <= 0) continue;
            return locs.get(0);
        }
        return null;
    }

    private void setBasicAuthHeader(String userid, String password, Map<String, List<String>> headers) {
        String userpass = userid;
        userpass = userpass + ":";
        if (password != null) {
            userpass = userpass + password;
        }
        String token = Base64Utility.encode(userpass.getBytes());
        headers.put("Authorization", HTTPConduit.createMutableList("Basic " + token));
    }

    private void setProxyBasicAuthHeader(String userid, String password, Map<String, List<String>> headers) {
        String userpass = userid;
        userpass = userpass + ":";
        if (password != null) {
            userpass = userpass + password;
        }
        String token = Base64Utility.encode(userpass.getBytes());
        headers.put("Proxy-Authorization", HTTPConduit.createMutableList("Basic " + token));
    }

    @Override
    public void assertMessage(Message message) {
        PolicyUtils.assertClientPolicy(message, this.clientSidePolicy);
    }

    @Override
    public boolean canAssert(QName type) {
        return PolicyUtils.HTTPCLIENTPOLICY_ASSERTION_QNAME.equals(type);
    }

    @Deprecated
    public void setBasicAuthSupplier(HttpBasicAuthSupplier basicAuthSupplier) {
        this.setAuthSupplier(basicAuthSupplier);
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange(new ExchangeImpl());
            inMessage.getExchange().put(Bus.class, HTTPConduit.this.bus);
            inMessage.put("decoupled.channel.message", Boolean.TRUE);
            HTTPConduit.this.getSetProtocolHeaders(inMessage);
            inMessage.put(Message.RESPONSE_CODE, 200);
            inMessage.remove("HTTP.REQUEST");
            inMessage.remove("HTTP.RESPONSE");
            inMessage.remove("org.apache.cxf.async.post.response.dispatch");
            try {
                InputStream in = inMessage.getContent(InputStream.class);
                if (in != null) {
                    CachedOutputStream cos = new CachedOutputStream();
                    IOUtils.copy(in, cos);
                    inMessage.setContent(InputStream.class, cos.getInputStream());
                }
                HTTPConduit.this.incomingObserver.onMessage(inMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WrappedOutputStream
    extends AbstractThresholdOutputStream {
        protected HttpURLConnection connection;
        protected boolean cachingForRetransmission;
        protected final boolean chunking;
        protected CacheAndWriteOutputStream cachedStream;
        protected Message outMessage;

        protected WrappedOutputStream(Message m, HttpURLConnection c, boolean possibleRetransmit, boolean isChunking, int chunkThreshold) {
            super(chunkThreshold);
            this.outMessage = m;
            this.connection = c;
            this.cachingForRetransmission = possibleRetransmit;
            this.chunking = isChunking;
        }

        @Override
        public void thresholdNotReached() {
            if (this.chunking) {
                this.connection.setFixedLengthStreamingMode(this.buffer.size());
            }
        }

        @Override
        public void thresholdReached() {
            if (this.chunking) {
                this.connection.setChunkedStreamingMode(-1);
            }
        }

        @Override
        protected void onFirstWrite() throws IOException {
            try {
                this.handleHeadersTrustCaching();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("HTTPS hostname wrong:")) {
                    throw new IOException("The https URL hostname does not match the Common Name (CN) on the server certificate.  To disable this check (NOT recommended for production) set the CXF client TLS configuration property \"disableCNCheck\" to true.");
                }
                throw e;
            }
        }

        protected void handleHeadersTrustCaching() throws IOException {
            HTTPConduit.this.setURLRequestHeaders(this.outMessage);
            HTTPConduit.this.makeTrustDecision(this.outMessage, this.connection);
            if (!"POST".equals(this.connection.getRequestMethod()) && !"PUT".equals(this.connection.getRequestMethod())) {
                return;
            }
            if (this.outMessage.get("org.apache.cxf.post.empty") != null) {
                return;
            }
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(this.connection.getOutputStream());
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = this.connection.getOutputStream();
            }
        }

        @Override
        public void flush() throws IOException {
            if (!this.chunking) {
                super.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                if (this.buffer != null && this.buffer.size() > 0) {
                    this.thresholdNotReached();
                    LoadingByteArrayOutputStream tmp = this.buffer;
                    this.buffer = null;
                    super.write(tmp.getRawBytes(), 0, tmp.size());
                }
                if (!this.written) {
                    this.handleHeadersTrustCaching();
                }
                if (!this.cachingForRetransmission) {
                    super.close();
                } else if (this.cachedStream != null) {
                    super.flush();
                    this.cachedStream.getOut().close();
                    this.cachedStream.closeFlowthroughStream();
                }
                try {
                    this.handleResponse();
                }
                finally {
                    if (this.cachingForRetransmission && this.cachedStream != null) {
                        this.cachedStream.close();
                    }
                }
            }
            catch (HttpRetryException e) {
                String msg = "HTTP response '" + e.responseCode() + ": " + this.connection.getResponseMessage() + "' invoking " + this.connection.getURL();
                switch (e.responseCode()) {
                    case 301: 
                    case 302: {
                        msg = msg + " that returned location header '" + e.getLocation() + "'";
                        break;
                    }
                    case 401: {
                        if (HTTPConduit.this.authorizationPolicy == null || HTTPConduit.this.authorizationPolicy.getUserName() == null) {
                            msg = msg + " with NO authorization username configured in conduit " + HTTPConduit.this.getConduitName();
                            break;
                        }
                        msg = msg + " with authorization username '" + HTTPConduit.this.authorizationPolicy.getUserName() + "'";
                        break;
                    }
                    case 407: {
                        msg = HTTPConduit.this.proxyAuthorizationPolicy == null || HTTPConduit.this.proxyAuthorizationPolicy.getUserName() == null ? msg + " with NO proxy authorization configured in conduit " + HTTPConduit.this.getConduitName() : msg + " with proxy authorization username '" + HTTPConduit.this.proxyAuthorizationPolicy.getUserName() + "'";
                        if (HTTPConduit.this.clientSidePolicy == null || HTTPConduit.this.clientSidePolicy.getProxyServer() == null) {
                            if (this.connection.usingProxy()) {
                                msg = msg + " using a proxy even if NONE is configured in CXF conduit " + HTTPConduit.this.getConduitName() + " (maybe one is configured by java.net.ProxySelector)";
                                break;
                            }
                            msg = msg + " but NO proxy was used by the connection (none configured in cxf conduit and none selected by java.net.ProxySelector)";
                            break;
                        }
                        msg = msg + " using " + (Object)((Object)HTTPConduit.this.clientSidePolicy.getProxyServerType()) + " proxy " + HTTPConduit.this.clientSidePolicy.getProxyServer() + ":" + HTTPConduit.this.clientSidePolicy.getProxyServerPort();
                        break;
                    }
                }
                throw (IOException)new IOException(msg).initCause(e);
            }
            catch (IOException e) {
                String url = this.connection.getURL().toString();
                String origMessage = e.getMessage();
                if (origMessage != null && origMessage.contains(url)) {
                    throw e;
                }
                throw this.mapException(e.getClass().getSimpleName() + " invoking " + this.connection.getURL() + ": " + e.getMessage(), e, IOException.class);
            }
            catch (RuntimeException e) {
                throw this.mapException(e.getClass().getSimpleName() + " invoking " + this.connection.getURL() + ": " + e.getMessage(), e, RuntimeException.class);
            }
        }

        private <T extends Exception> T mapException(String msg, T ex, Class<T> cls) {
            Object ex2 = ex;
            try {
                ex2 = (Exception)cls.cast(ex.getClass().getConstructor(String.class).newInstance(msg));
                ((Throwable)ex2).initCause(ex);
            }
            catch (Throwable e) {
                ex2 = ex;
            }
            return (T)ex2;
        }

        protected void handleRetransmits() throws IOException {
            if (this.cachedStream != null) {
                int maxRetransmits;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Conduit \"" + HTTPConduit.this.getConduitName() + "\" Transmit cached message to: " + this.connection.getURL() + ": " + new String(this.cachedStream.getBytes()));
                }
                HttpURLConnection oldcon = this.connection;
                HTTPClientPolicy policy = HTTPConduit.this.getClient(this.outMessage);
                int n = maxRetransmits = policy == null ? -1 : policy.getMaxRetransmits();
                if (maxRetransmits == 0) {
                    return;
                }
                int nretransmits = 0;
                this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                while (this.connection != oldcon) {
                    oldcon = this.connection;
                    if (maxRetransmits >= 0 && ++nretransmits >= maxRetransmits) continue;
                    this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                }
            }
        }

        protected void handleResponse() throws IOException {
            this.handleRetransmits();
            if (this.outMessage == null || this.outMessage.getExchange() == null || this.outMessage.getExchange().isSynchronous()) {
                this.handleResponseInternal();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            WrappedOutputStream.this.handleResponseInternal();
                        }
                        catch (Exception e) {
                            ((PhaseInterceptorChain)WrappedOutputStream.this.outMessage.getInterceptorChain()).abort();
                            ((PhaseInterceptorChain)WrappedOutputStream.this.outMessage.getInterceptorChain()).unwind(WrappedOutputStream.this.outMessage);
                            WrappedOutputStream.this.outMessage.setContent(Exception.class, e);
                            WrappedOutputStream.this.outMessage.getInterceptorChain().getFaultObserver().onMessage(WrappedOutputStream.this.outMessage);
                        }
                    }
                };
                Executor ex = this.outMessage.getExchange().get(Executor.class);
                if (ex == null) {
                    WorkQueueManager mgr = this.outMessage.getExchange().get(Bus.class).getExtension(WorkQueueManager.class);
                    ex = mgr.getNamedWorkQueue("http-conduit");
                    if (ex == null) {
                        ex = mgr.getAutomaticWorkQueue();
                    }
                } else {
                    this.outMessage.getExchange().put(Executor.class.getName() + ".USING_SPECIFIED", Boolean.TRUE);
                }
                ex.execute(runnable);
            }
        }

        protected void handleResponseInternal() throws IOException {
            Exchange exchange = this.outMessage.getExchange();
            int responseCode = this.connection.getResponseCode();
            if (this.outMessage != null && exchange != null) {
                exchange.put(Message.RESPONSE_CODE, responseCode);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Response Code: " + responseCode + " Conduit: " + HTTPConduit.this.getConduitName());
                LOG.fine("Content length: " + this.connection.getContentLength());
                Map<String, List<String>> headerFields = this.connection.getHeaderFields();
                if (null != headerFields) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("Header fields: ");
                    buf.append(System.getProperty("line.separator"));
                    for (String h : headerFields.keySet()) {
                        buf.append("    ");
                        buf.append(h);
                        buf.append(": ");
                        buf.append(headerFields.get(h));
                        buf.append(System.getProperty("line.separator"));
                    }
                    LOG.fine(buf.toString());
                }
            }
            if (responseCode == 404 && !MessageUtils.isTrue(this.outMessage.getContextualProperty("org.apache.cxf.http.no_io_exceptions"))) {
                throw new IOException("HTTP response '" + responseCode + ": " + this.connection.getResponseMessage() + "'");
            }
            InputStream in = null;
            if (HTTPConduit.this.isOneway(exchange) || HTTPConduit.this.isDecoupled()) {
                in = HTTPConduit.getPartialResponse(this.connection, responseCode);
                if (in == null) {
                    this.connection.getInputStream().close();
                    return;
                }
            } else {
                this.outMessage.removeContent(OutputStream.class);
                if (this.cachingForRetransmission && this.cachedStream != null) {
                    this.cachedStream.close();
                }
                this.cachedStream = null;
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            Map<String, List<String>> origHeaders = this.connection.getHeaderFields();
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (String key : this.connection.getHeaderFields().keySet()) {
                if (key == null) continue;
                headers.put(HttpHeaderHelper.getHeaderKey(key), origHeaders.get(key));
            }
            inMessage.put(Message.PROTOCOL_HEADERS, headers);
            inMessage.put(Message.RESPONSE_CODE, responseCode);
            String ct = this.connection.getContentType();
            inMessage.put("Content-Type", ct);
            String charset = HttpHeaderHelper.findCharset(ct);
            String normalizedEncoding = HttpHeaderHelper.mapCharset(charset);
            if (normalizedEncoding == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, charset).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put(Message.ENCODING, normalizedEncoding);
            if (HTTPConduit.this.maintainSession) {
                for (Map.Entry<String, List<String>> h : this.connection.getHeaderFields().entrySet()) {
                    if (!"Set-Cookie".equalsIgnoreCase(h.getKey())) continue;
                    Cookie.handleSetCookie(HTTPConduit.this.sessionCookies, h.getValue());
                }
            }
            if (responseCode != 404) {
                in = in == null ? (this.connection.getErrorStream() == null ? this.connection.getInputStream() : this.connection.getErrorStream()) : in;
            }
            inMessage.setContent(InputStream.class, in);
            HTTPConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

