/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

public class Jsr250BeanPostProcessor
implements DestructionAwareBeanPostProcessor,
Ordered,
ApplicationContextAware {
    private ResourceManager resourceManager;
    private List<ResourceResolver> resolvers;
    private ApplicationContext context;
    private boolean isProcessing = true;

    Jsr250BeanPostProcessor() {
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.context = arg0;
        try {
            Class<?> cls = Class.forName("org.springframework.context.annotation.CommonAnnotationBeanPostProcessor");
            this.isProcessing = this.context.getBeanNamesForType(cls, true, false).length == 0;
        }
        catch (ClassNotFoundException e) {
            this.isProcessing = true;
        }
    }

    public int getOrder() {
        return 1010;
    }

    public Object postProcessAfterInitialization(Object bean, String beanId) throws BeansException {
        if (!this.isProcessing) {
            return bean;
        }
        if (bean != null) {
            new ResourceInjector(this.resourceManager, this.resolvers).construct(bean);
        }
        if (bean instanceof ResourceManager) {
            this.resourceManager = (ResourceManager)bean;
            Map mp = CastUtils.cast(this.context.getBeansOfType(ResourceResolver.class));
            Collection resolvs = CastUtils.cast(mp.values());
            this.resolvers = new ArrayList<ResourceResolver>(this.resourceManager.getResourceResolvers());
            this.resolvers.addAll(resolvs);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanId) throws BeansException {
        if (!this.isProcessing) {
            return bean;
        }
        if (bean != null) {
            new ResourceInjector(this.resourceManager, this.resolvers).inject(bean);
        }
        return bean;
    }

    public void postProcessBeforeDestruction(Object bean, String beanId) {
        if (!this.isProcessing) {
            return;
        }
        if (bean != null) {
            new ResourceInjector(this.resourceManager, this.resolvers).destroy(bean);
        }
    }
}

