/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import com.sun.xml.fastinfoset.stax.factory.StAXInputFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIStaxInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String FI_GET_SUPPORTED = "org.apache.cxf.fastinfoset.get.supported";
    XMLInputFactory factory = new StAXInputFactory();

    public FIStaxInInterceptor() {
        this("post-stream");
    }

    public FIStaxInInterceptor(String phase) {
        super(phase);
        this.addBefore(StaxInInterceptor.class.getName());
    }

    @Override
    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey("org.apache.cxf.client"));
    }

    @Override
    public void handleMessage(Message message) {
        if (message.getContentFormats().contains(XMLStreamReader.class) || !this.isHttpVerbSupported(message)) {
            return;
        }
        String ct = (String)message.get("Content-Type");
        if (ct != null && ct.indexOf("fastinfoset") != -1) {
            message.put(XMLInputFactory.class.getName(), this.factory);
            ct = ct.replace("fastinfoset", "xml");
            if (ct.contains("application/xml")) {
                ct = ct.replace("application/xml", "text/xml");
            }
            message.put("Content-Type", ct);
            message.getExchange().put("org.apache.cxf.fastinfoset.enabled", Boolean.TRUE);
            if (this.isRequestor(message)) {
                Endpoint ep = message.getExchange().get(Endpoint.class);
                ep.put("org.apache.cxf.fastinfoset.enabled", Boolean.TRUE);
            }
        }
    }

    protected boolean isHttpVerbSupported(Message message) {
        if (this.isGET(message)) {
            return this.isRequestor(message) && MessageUtils.isTrue(message.getContextualProperty(FI_GET_SUPPORTED));
        }
        return true;
    }
}

