/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.tools.xjc.api.ErrorListener;
import org.apache.cxf.tools.common.ToolException;
import org.xml.sax.SAXParseException;

public class JAXBBindErrorListener
implements ErrorListener {
    private boolean isVerbose;
    private String prefix = "Thrown by JAXB : ";

    public JAXBBindErrorListener(boolean verbose) {
        this.isVerbose = verbose;
    }

    public void error(SAXParseException exception) {
        if (exception.getLineNumber() > 0) {
            throw new ToolException(this.prefix + exception.getLocalizedMessage() + " at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + " of schema " + exception.getSystemId(), (Throwable)exception);
        }
        throw new ToolException(this.prefix + this.mapMessage(exception.getLocalizedMessage()), (Throwable)exception);
    }

    public void fatalError(SAXParseException exception) {
        throw new ToolException(this.prefix + exception.getLocalizedMessage() + " of schema " + exception.getSystemId(), (Throwable)exception);
    }

    public void info(SAXParseException exception) {
        if (this.isVerbose) {
            System.out.println("JAXB Info: " + exception.toString() + " in schema " + exception.getSystemId());
        }
    }

    public void warning(SAXParseException exception) {
        if (this.isVerbose) {
            System.err.println("JAXB parsing schema warning " + exception.toString() + " in schema " + exception.getSystemId());
        }
    }

    private String mapMessage(String msg) {
        if (msg.contains("Use a class customization to resolve") && msg.contains("with the same name")) {
            int idx = msg.lastIndexOf("class customization") + 19;
            msg = msg.substring(0, idx) + " or the -autoNameResolution option" + msg.substring(idx);
        }
        return msg;
    }
}

