/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extension {
    private String className;
    private Class<?> clazz;
    private String interfaceName;
    private boolean deferred;
    private Collection<String> namespaces = new ArrayList<String>();
    private Object obj;

    public String getName() {
        return StringUtils.isEmpty(this.interfaceName) ? this.className : this.interfaceName;
    }

    public Object getLoadedObject() {
        return this.obj;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("class: ");
        buf.append(this.className);
        buf.append(", interface: ");
        buf.append(this.interfaceName);
        buf.append(", deferred: ");
        buf.append(this.deferred ? "true" : "false");
        buf.append(", namespaces: (");
        int n = 0;
        for (String ns : this.namespaces) {
            if (n > 0) {
                buf.append(", ");
            }
            buf.append(ns);
            ++n;
        }
        buf.append(")");
        return buf.toString();
    }

    Class<?> getClassObject(ClassLoader cl) {
        if (this.clazz == null) {
            try {
                this.clazz = cl.loadClass(this.className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    this.clazz = this.getClass().getClassLoader().loadClass(this.className);
                }
                catch (ClassNotFoundException nex) {
                    throw new ExtensionException(nex);
                }
            }
        }
        return this.clazz;
    }

    String getClassname() {
        return this.className;
    }

    void setClassname(String i) {
        this.clazz = null;
        this.className = i;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String i) {
        this.interfaceName = i;
    }

    boolean isDeferred() {
        return this.deferred;
    }

    void setDeferred(boolean d) {
        this.deferred = d;
    }

    Collection<String> getNamespaces() {
        return this.namespaces;
    }

    Object load(ClassLoader cl, Bus b) {
        try {
            Class<?> cls = this.getClassObject(cl);
            try {
                if (b != null) {
                    Constructor<?> con = cls.getConstructor(Bus.class);
                    this.obj = con.newInstance(b);
                    return this.obj;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.obj = cls.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new ExtensionException(ex);
        }
        catch (InstantiationException ex) {
            throw new ExtensionException(ex);
        }
        return this.obj;
    }

    Class loadInterface(ClassLoader cl) {
        Class<?> cls = null;
        try {
            cls = cl.loadClass(this.interfaceName);
        }
        catch (ClassNotFoundException ex) {
            try {
                cls = this.getClass().getClassLoader().loadClass(this.interfaceName);
            }
            catch (ClassNotFoundException nex) {
                throw new ExtensionException(nex);
            }
        }
        return cls;
    }
}

