/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.math.BigDecimal;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.wsdl.Anonfixed;
import org.apache.cxf.binding.corba.wsdl.Fixed;
import org.omg.CORBA.TypeCode;

public final class CorbaFixedHandler
extends CorbaObjectHandler {
    private final long digits;
    private final long scale;
    private BigDecimal value;

    public CorbaFixedHandler(QName fixedName, QName fixedIdlType, TypeCode fixedTC, Object fixedType) {
        super(fixedName, fixedIdlType, fixedTC, fixedType);
        if (fixedType instanceof Fixed) {
            this.digits = ((Fixed)fixedType).getDigits();
            this.scale = ((Fixed)fixedType).getScale();
        } else if (fixedType instanceof Anonfixed) {
            this.digits = ((Anonfixed)fixedType).getDigits();
            this.scale = ((Anonfixed)fixedType).getScale();
        } else {
            this.digits = 0L;
            this.scale = 0L;
        }
    }

    public long getDigits() {
        return this.digits;
    }

    public long getScale() {
        return this.scale;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String getValueData() {
        return this.value.toString();
    }

    public void setValue(BigDecimal val) {
        this.value = val;
    }

    public void setValueFromData(String data) {
        this.value = new BigDecimal(data);
    }

    public void clear() {
        this.value = null;
    }
}

