/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.cxf.BusException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public abstract class AbstractConduitSelector
implements ConduitSelector {
    protected static final String KEEP_CONDUIT_ALIVE = "KeepConduitAlive";
    protected Conduit selectedConduit;
    protected Endpoint endpoint;

    public AbstractConduitSelector(Conduit c) {
        this.selectedConduit = c;
    }

    protected synchronized Conduit getSelectedConduit(Message message) {
        if (this.selectedConduit == null) {
            Exchange exchange = message.getExchange();
            EndpointInfo ei = this.endpoint.getEndpointInfo();
            String transportID = ei.getTransportId();
            try {
                ConduitInitiatorManager conduitInitiatorMgr = exchange.getBus().getExtension(ConduitInitiatorManager.class);
                if (conduitInitiatorMgr != null) {
                    ConduitInitiator conduitInitiator = conduitInitiatorMgr.getConduitInitiator(transportID);
                    if (conduitInitiator != null) {
                        String add = (String)message.get(Message.ENDPOINT_ADDRESS);
                        if (StringUtils.isEmpty(add) || add.equals(ei.getAddress())) {
                            this.replaceEndpointAddressPropertyIfNeeded(message, add);
                            this.selectedConduit = conduitInitiator.getConduit(ei);
                        } else {
                            EndpointReferenceType epr = new EndpointReferenceType();
                            AttributedURIType ad = new AttributedURIType();
                            ad.setValue(add);
                            epr.setAddress(ad);
                            this.selectedConduit = conduitInitiator.getConduit(ei, epr);
                        }
                        MessageObserver observer = exchange.get(MessageObserver.class);
                        if (observer != null) {
                            this.selectedConduit.setMessageObserver(observer);
                        } else {
                            this.getLogger().warning("MessageObserver not found");
                        }
                    } else {
                        this.getLogger().warning("ConduitInitiator not found: " + ei.getAddress());
                    }
                } else {
                    this.getLogger().warning("ConduitInitiatorManager not found");
                }
            }
            catch (BusException ex) {
                throw new Fault(ex);
            }
            catch (IOException ex) {
                throw new Fault(ex);
            }
        }
        return this.selectedConduit;
    }

    protected void replaceEndpointAddressPropertyIfNeeded(Message message, String endpointAddress) {
        String basePath;
        String requestURI = (String)message.get("org.apache.cxf.request.uri");
        if (requestURI != null && !requestURI.startsWith(endpointAddress) && (basePath = (String)message.get(Message.BASE_PATH)) != null && requestURI.startsWith(basePath)) {
            String pathInfo = requestURI.substring(basePath.length());
            String slash = "/";
            boolean startsWithSlash = pathInfo.startsWith("/");
            endpointAddress = endpointAddress.endsWith("/") ? endpointAddress + (startsWithSlash ? pathInfo.substring(1) : pathInfo) : endpointAddress + (startsWithSlash ? pathInfo : "/" + pathInfo);
            message.put(Message.ENDPOINT_ADDRESS, endpointAddress);
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint ep) {
        this.endpoint = ep;
    }

    public void complete(Exchange exchange) {
        if (MessageUtils.isTrue(exchange.get(KEEP_CONDUIT_ALIVE))) {
            return;
        }
        try {
            if (exchange.getInMessage() != null) {
                this.getSelectedConduit(exchange.getInMessage()).close(exchange.getInMessage());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract Logger getLogger();
}

