/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.util.Arrays;

public class FourSpacePrettyPrinter
extends DefaultPrettyPrinter {
    public FourSpacePrettyPrinter() {
        this._objectIndenter = Lf4SpacesIndenter.INSTANCE;
    }

    public static class Lf4SpacesIndenter
    extends DefaultPrettyPrinter.NopIndenter {
        public static final Lf4SpacesIndenter INSTANCE = new Lf4SpacesIndenter();
        private static final String SYS_LF;
        private static int spacecount;
        private static char[] spaces;

        public boolean isInline() {
            return false;
        }

        public void writeIndentation(JsonGenerator jg, int level) throws IOException, JsonGenerationException {
            jg.writeRaw(SYS_LF);
            if (level > 0) {
                level *= 4;
                while (level > spacecount) {
                    jg.writeRaw(spaces, 0, spacecount);
                    level -= spaces.length;
                }
                jg.writeRaw(spaces, 0, level);
            }
        }

        static {
            spacecount = 64;
            spaces = new char[spacecount];
            String lf = null;
            try {
                lf = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SYS_LF = lf == null ? "\n" : lf;
            Arrays.fill(spaces, ' ');
        }
    }
}

