/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class CodegenUtils {
    static long timestamp;

    private CodegenUtils() {
    }

    public static long getCodegenTimestamp() {
        if (timestamp != 0L) {
            return timestamp;
        }
        CodegenUtils.getClassTime(CodegenUtils.class);
        return timestamp;
    }

    private static void getClassTime(Class class1) {
        String str = "/" + class1.getName().replace('.', '/') + ".class";
        URL url = class1.getResource(str);
        if (url != null) {
            while ("jar".equals(url.getProtocol())) {
                str = url.getPath();
                if (str.lastIndexOf("!") != -1) {
                    str = str.substring(0, str.lastIndexOf("!"));
                }
                try {
                    url = new URL(str);
                }
                catch (MalformedURLException e) {
                    return;
                }
            }
            try {
                if (url.getPath().endsWith(".class")) {
                    timestamp = new File(url.toURI()).lastModified();
                } else {
                    JarFile jar = new JarFile(url.getPath());
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (entry.isDirectory() || entry.getName().startsWith("META") || entry.getTime() <= timestamp) continue;
                        timestamp = entry.getTime();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

