/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.rmi.PortableRemoteObject;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.binding.soap.SoapBindingFactory;
import org.apache.cxf.binding.soap.SoapDestinationFactory;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JAXWSMethodInvoker;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;
import org.apache.cxf.jca.core.resourceadapter.UriHandlerInit;
import org.apache.cxf.jca.cxf.ManagedConnectionFactoryImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServerFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLManagerImpl;

public class JCABusFactory {
    private static final Logger LOG = Logger.getLogger(JCABusFactory.class.getName());
    private Bus bus;
    private BusFactory bf;
    private List<Server> servantsCache = new ArrayList<Server>();
    private InitialContext jndiContext;
    private ClassLoader appserverClassLoader;
    private ManagedConnectionFactoryImpl mcf;
    private Object raBootstrapContext;

    public JCABusFactory(ManagedConnectionFactoryImpl aMcf) {
        this.mcf = aMcf;
    }

    protected String[] getBusArgs() throws ResourceException {
        String busId = this.mcf.getConfigurationScope();
        LOG.config("BUSid=" + busId);
        String[] busArgs = new String[]{"-BUSid", busId};
        return busArgs;
    }

    protected Bus createBus(ClassLoader loader) throws ResourceException {
        try {
            Class<?> busClazz = Class.forName(this.getBusClassName(), true, loader);
            this.bf = (BusFactory)busClazz.newInstance();
            this.bus = this.bf.getDefaultBus();
        }
        catch (Exception ex) {
            throw new ResourceAdapterInternalException("Failed to initialize cxf runtime", ex);
        }
        return this.bus;
    }

    protected void initBus() throws ResourceException {
        try {
            SoapBindingFactory bindingFactory = new SoapBindingFactory();
            ((BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class)).registerBindingFactory("http://schemas.xmlsoap.org/wsdl/soap/", (BindingFactory)bindingFactory);
            DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
            SoapDestinationFactory soapDF = new SoapDestinationFactory();
            soapDF.setBus(this.bus);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/", (DestinationFactory)soapDF);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/soap/", (DestinationFactory)soapDF);
            HTTPTransportFactory httpTransport = new HTTPTransportFactory();
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/http", (DestinationFactory)httpTransport);
            ConduitInitiatorManager extension = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
            extension.registerConduitInitiator("http://schemas.xmlsoap.org/wsdl/soap/http", (ConduitInitiator)httpTransport);
            extension.registerConduitInitiator("http://schemas.xmlsoap.org/http/http", (ConduitInitiator)httpTransport);
            this.bus.setExtension((Object)new WSDLManagerImpl(), WSDLManager.class);
        }
        catch (Exception ex) {
            throw new ResourceAdapterInternalException("Failed to initialize cxf runtime", ex);
        }
    }

    protected synchronized void init() throws ResourceException {
        LOG.config("initialising... the bus");
        new UriHandlerInit();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            this.bus = this.createBus(cl);
            this.initBus();
            this.initialiseServants();
        }
        catch (Exception ex) {
            if (ex instanceof ResourceAdapterInternalException) {
                throw (ResourceException)ex;
            }
            ex.printStackTrace();
            throw new ResourceAdapterInternalException("Failed to initialize connector runtime", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    void initialiseServants() throws ResourceException {
        if (this.isMonitorEJBServicePropertiesEnabled()) {
            LOG.info("ejb service properties update enabled. ");
            this.startPropertiesMonitorThread();
        } else {
            URL propsUrl = this.mcf.getEJBServicePropertiesURLInstance();
            if (propsUrl != null) {
                this.initialiseServantsFromProperties(this.loadProperties(propsUrl), false);
            }
        }
    }

    void initialiseServantsFromProperties(Properties ejbServants, boolean abortOnFailure) throws ResourceException {
        try {
            this.jndiContext = new InitialContext();
        }
        catch (NamingException ne) {
            throw new ResourceAdapterInternalException("Failed to construct InitialContext for EJBServant(s) jndi lookup, reason: " + ne, ne);
        }
        this.deregisterServants(this.bus);
        LOG.config("Initialising EJB endpoints...");
        Enumeration<Object> keys = ejbServants.keys();
        while (keys.hasMoreElements()) {
            String jndiName = (String)keys.nextElement();
            String serviceName = ejbServants.getProperty(jndiName);
            LOG.config("Found ejb endpoint: jndi name=" + jndiName + ", wsdl service=" + serviceName);
            try {
                this.initialiseServant(jndiName, serviceName);
            }
            catch (ResourceException re) {
                LOG.warning("Error initialising servant with jndi name " + jndiName + " and service name " + serviceName + " Exception:" + re.getMessage());
                if (!abortOnFailure) continue;
                throw re;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialiseServant(String jndiName, String serviceName) throws ResourceException {
        Server servant = null;
        EJBObject ejb = null;
        QName serviceQName = null;
        String nameSpace = "";
        String interfaceName = "";
        String packageName = "";
        Class<?> interfaceClass = null;
        ClassLoader ejbClassLoader = null;
        ClassLoader currentThreadContextClassLoader = null;
        try {
            if ("".equals(serviceName)) {
                throw new ResourceAdapterInternalException("A WSDL service QName must be specified as the value of the EJB JNDI name key: " + jndiName);
            }
            serviceQName = this.serviceQNameFromString(serviceName);
            this.serviceQNameFromString(serviceName);
            ejb = this.getEJBObject(jndiName);
            ejbClassLoader = ejb.getClass().getClassLoader();
            currentThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ejbClassLoader);
            Thread.currentThread().setContextClassLoader(currentThreadContextClassLoader);
            nameSpace = serviceQName.getNamespaceURI();
            packageName = PackageUtils.parsePackageName((String)nameSpace, null);
            interfaceName = jndiName.substring(0, jndiName.length() - 4);
            interfaceName = packageName + "." + interfaceName;
            interfaceClass = Class.forName(interfaceName);
            servant = this.publishServantWithoutWSDL(ejb, jndiName, nameSpace, interfaceClass);
        }
        catch (Exception e) {
            throw new ResourceAdapterInternalException(e.getMessage());
        }
        List<Server> list = this.servantsCache;
        synchronized (list) {
            if (servant != null) {
                this.servantsCache.add(servant);
            }
        }
    }

    public Server publishServantWithoutWSDL(EJBObject ejb, String jndiName, String nameSpace, Class interfaceClass) throws Exception {
        String hostName = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        String address = "http://" + hostName + ":9999/" + jndiName;
        JaxWsServiceFactoryBean bean = new JaxWsServiceFactoryBean();
        Service service = this.createService(interfaceClass, (ReflectionServiceFactoryBean)bean);
        service.setInvoker((Invoker)new JAXWSMethodInvoker((Object)ejb));
        ServerFactoryBean svrFactory = new ServerFactoryBean();
        return this.createServer(svrFactory, (ReflectionServiceFactoryBean)bean, address);
    }

    protected Service createService(Class interfaceClass, ReflectionServiceFactoryBean serviceFactory) throws JAXBException {
        serviceFactory.setDataBinding((DataBinding)new JAXBDataBinding());
        serviceFactory.setBus(this.bus);
        serviceFactory.setServiceClass(interfaceClass);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("test", "test");
        serviceFactory.setProperties(props);
        return serviceFactory.create();
    }

    protected Server createServer(ServerFactoryBean serverFactory, ReflectionServiceFactoryBean serviceFactory, String address) {
        serverFactory.setAddress(address);
        serverFactory.setTransportId("http://schemas.xmlsoap.org/soap/http");
        serverFactory.setServiceFactory(serviceFactory);
        serverFactory.setBus(this.bus);
        return serverFactory.create();
    }

    private EJBObject getEJBObject(String jndi) throws BusException {
        try {
            EJBHome home = this.getEJBHome(this.jndiContext, jndi);
            Method createMethod = home.getClass().getMethod("create", new Class[0]);
            return (EJBObject)createMethod.invoke((Object)home, new Object[0]);
        }
        catch (NamingException e) {
            throw new BusException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BusException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BusException((Throwable)e);
        }
        catch (InvocationTargetException itex) {
            Throwable thrownException = itex.getTargetException();
            throw new BusException(thrownException);
        }
    }

    protected EJBHome getEJBHome(Context ejbContext, String jndiName) throws NamingException {
        Object obj = ejbContext.lookup(jndiName);
        return (EJBHome)PortableRemoteObject.narrow((Object)obj, EJBHome.class);
    }

    void startPropertiesMonitorThread() throws ResourceException {
        Integer pollIntervalInteger = this.mcf.getEJBServicePropertiesPollInterval();
        int pollInterval = pollIntervalInteger;
        LOG.info("ejb service properties poll interval is : " + pollInterval + " seconds");
        EJBServicePropertiesMonitorRunnable r = new EJBServicePropertiesMonitorRunnable(pollInterval);
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
    }

    boolean isMonitorEJBServicePropertiesEnabled() throws ResourceException {
        boolean retVal = false;
        if (this.mcf.getMonitorEJBServiceProperties().booleanValue()) {
            URL url = this.mcf.getEJBServicePropertiesURLInstance();
            if (url == null) {
                throw new ResourceAdapterInternalException("MonitorEJBServiceProperties property is set to true, but EJBServicePropertiesURL is not set. Both properties must be set to enable monitoring.");
            }
            retVal = this.isFileURL(url);
        }
        return retVal;
    }

    boolean isFileURL(URL url) {
        return url != null && "file".equals(url.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterServants(Bus aBus) {
        List<Server> list = this.servantsCache;
        synchronized (list) {
            if (!this.servantsCache.isEmpty()) {
                for (Server servant : this.servantsCache) {
                    servant.stop();
                }
                this.servantsCache.clear();
            }
        }
    }

    Properties loadProperties(URL propsUrl) throws ResourceException {
        Properties props = null;
        InputStream istream = null;
        LOG.info("loadProperties, url=" + propsUrl);
        try {
            istream = propsUrl.openStream();
        }
        catch (IOException ioe) {
            throw new ResourceAdapterInternalException("Failed to openStream to URL, value=" + propsUrl + ", reason:" + ioe, ioe);
        }
        try {
            props = new Properties();
            props.load(istream);
        }
        catch (IOException ioe) {
            props = null;
            throw new ResourceAdapterInternalException("Failed to load properties from " + propsUrl, ioe);
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException ignored) {}
        }
        return props;
    }

    QName serviceQNameFromString(String qns) throws ResourceAdapterInternalException {
        String lp = null;
        String nameSpace = null;
        try {
            StringTokenizer st = new StringTokenizer(qns, "{},@", true);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if ("{".equals(t)) {
                    nameSpace = st.nextToken();
                    st.nextToken();
                    continue;
                }
                if (",".equals(t)) {
                    st.nextToken();
                    continue;
                }
                if ("@".equals(t)) {
                    st.nextToken();
                    continue;
                }
                lp = t;
            }
        }
        catch (NoSuchElementException nsee) {
            throw new ResourceAdapterInternalException("Incomplete QName, string is not in expected format: [{namespace}]local part[@ wsdl location url]. value:" + qns, nsee);
        }
        LOG.fine("QN=" + qns + ", ns=" + nameSpace + ", lp=" + lp);
        return new QName(nameSpace, lp);
    }

    String portNameFromString(String qns) throws ResourceAdapterInternalException {
        String portName = null;
        try {
            StringTokenizer st = new StringTokenizer(qns, ",@", true);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (!",".equals(t)) continue;
                if (portName != null) {
                    throw new ResourceAdapterInternalException("portName already set, string is not in expected format: [{namespace}]serviceName[,portName][@ wsdl location url]. value:" + qns);
                }
                portName = st.nextToken();
                if (!"@".equals(portName)) continue;
                throw new ResourceAdapterInternalException("Empty portName, string is not in expected format: [{namespace}]serviceName[,portName][@ wsdl location url]. value:" + qns);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new ResourceAdapterInternalException("Incomplete QName, string is not in expected format: [{namespace}]serviceName[,portName][@ wsdl location url]. value:" + qns, nsee);
        }
        return portName;
    }

    String wsdlLocFromString(String qns) {
        String wloc = null;
        StringTokenizer st = new StringTokenizer(qns, "@", true);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!"@".equals(t)) continue;
            wloc = st.nextToken();
        }
        return wloc;
    }

    private String getBusClassName() {
        return System.getProperty("test.bus.class", "org.apache.cxf.bus.spring.SpringBusFactory");
    }

    protected List getRegisteredServants() {
        return this.servantsCache;
    }

    public ClassLoader getAppserverClassLoader() {
        return this.appserverClassLoader;
    }

    public void setAppserverClassLoader(ClassLoader classLoader) {
        this.appserverClassLoader = classLoader;
    }

    public InitialContext getInitialContext() {
        return this.jndiContext;
    }

    public Object getBootstrapContext() {
        return this.raBootstrapContext;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public void create(ClassLoader classLoader, Object context) throws ResourceException {
        this.appserverClassLoader = classLoader;
        this.raBootstrapContext = context;
        this.init();
    }

    protected void setBootstrapContext(Object ctx) {
        this.raBootstrapContext = ctx;
    }

    class EJBServicePropertiesMonitorRunnable
    implements Runnable {
        private long previousModificationTime;
        private final int pollIntervalSeconds;
        private final File propsFile;
        private boolean continuing = true;

        EJBServicePropertiesMonitorRunnable(int pollInterval) throws ResourceException {
            this.pollIntervalSeconds = pollInterval;
            this.propsFile = new File(JCABusFactory.this.mcf.getEJBServicePropertiesURLInstance().getPath());
        }

        public void setContinue(boolean c) {
            this.continuing = c;
        }

        public void run() {
            do {
                try {
                    if (this.isPropertiesFileModified()) {
                        LOG.info("ejbServicePropertiesFile modified, initialising/updating servants");
                        JCABusFactory.this.initialiseServantsFromProperties(JCABusFactory.this.loadProperties(this.propsFile.toURI().toURL()), false);
                    }
                    Thread.sleep(this.pollIntervalSeconds * 1000);
                }
                catch (Exception e) {
                    LOG.info("MonitorThread: failed to initialiseServantsFromProperties with properties absolute path=" + this.propsFile.getAbsolutePath() + ", reason: " + e.toString());
                }
            } while (this.continuing);
        }

        protected boolean isPropertiesFileModified() throws ResourceException {
            long currentModificationTime;
            boolean fileModified = false;
            if (this.propsFile.exists() && (currentModificationTime = this.propsFile.lastModified()) > this.previousModificationTime) {
                this.previousModificationTime = currentModificationTime;
                fileModified = true;
            }
            return fileModified;
        }
    }
}

