/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.servant;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jca.servant.AbstractServant;

public class EJBServant
extends AbstractServant {
    public static final String INITIAL_CONTEXT_PROPS_FILE = "initial_context.properties";
    private static final Logger LOG = Logger.getLogger(EJBServant.class.getName());
    protected Properties props;
    private EJBObject ejb;
    private String jndiLookup;

    public EJBServant(String wsdlLoc, Bus bus, String jndiName, Properties initialContextProps) {
        super(wsdlLoc, bus);
        this.props = initialContextProps;
        this.jndiLookup = jndiName;
    }

    public EJBServant(String wsdlLoc, Bus bus, String jndiName) throws Exception {
        super(wsdlLoc, bus);
        this.props = this.getContextProperties(jndiName, INITIAL_CONTEXT_PROPS_FILE);
        this.jndiLookup = jndiName;
    }

    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            Class[] argsClass;
            if (args != null) {
                argsClass = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    argsClass[i] = args[i].getClass();
                }
            } else {
                argsClass = null;
            }
            Method tMethod = this.ejb.getClass().getMethod(method.getName(), argsClass);
            result = tMethod.invoke((Object)this.ejb, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }

    synchronized void resetCacheTarget() {
        this.ejb = null;
    }

    public void setProperties(Properties p) {
        this.props = p;
    }

    public synchronized Object getTargetObject() throws BusException {
        if (this.ejb == null) {
            try {
                Context ejbContext = this.getInitialContext(this.props);
                if (ejbContext == null) {
                    Message mg = new Message("Can't get InitialContext", LOG, new Object[0]);
                    throw new BusException(mg);
                }
                EJBHome home = this.getEJBHome(ejbContext, this.jndiLookup);
                Method createMethod = home.getClass().getMethod("create", new Class[0]);
                this.ejb = (EJBObject)createMethod.invoke((Object)home, new Object[0]);
            }
            catch (NamingException e) {
                throw new BusException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new BusException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new BusException((Throwable)e);
            }
            catch (InvocationTargetException itex) {
                Throwable thrownException = itex.getTargetException();
                throw new BusException(thrownException);
            }
        }
        return this.ejb;
    }

    protected final Properties getContextProperties(String jndiName, String defaultPropsName) throws Exception {
        InputStream istream = this.getClass().getClassLoader().getResourceAsStream(jndiName + "_" + defaultPropsName);
        if (istream == null) {
            istream = this.getClass().getClassLoader().getResourceAsStream(defaultPropsName);
        }
        Properties properties = new Properties();
        if (istream != null) {
            properties.load(istream);
            istream.close();
        } else {
            LOG.fine("Properties " + defaultPropsName + " or " + jndiName + defaultPropsName + "  not found in ClassPath");
        }
        return properties;
    }

    public Context getInitialContext(Properties propers) throws NamingException {
        return new InitialContext(propers);
    }

    protected EJBHome getEJBHome(Context ejbContext, String jndiName) throws NamingException {
        Object obj = ejbContext.lookup(jndiName);
        return (EJBHome)PortableRemoteObject.narrow((Object)obj, EJBHome.class);
    }
}

