/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.wsdl2java.processor.WSDLToJavaProcessor;

public class WSDLToJava
extends AbstractCXFToolContainer {
    private static final String TOOL_NAME = "wsdl2java";
    private static final String DEFAULT_NS2PACKAGE = "http://www.w3.org/2005/08/addressing";
    private static String[] args;

    public WSDLToJava(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    private Set getArrayKeys() {
        HashSet<String> set = new HashSet<String>();
        set.add("binding");
        set.add("packagename");
        set.add("nexclude");
        return set;
    }

    public void execute(boolean exitOnFinish) {
        block9: {
            WSDLToJavaProcessor processor = new WSDLToJavaProcessor();
            try {
                super.execute(exitOnFinish);
                if (!this.hasInfoOption()) {
                    ToolContext env = new ToolContext();
                    env.setParameters(this.getParametersMap(this.getArrayKeys()));
                    if (env.get("outputdir") == null) {
                        env.put("outputdir", (Object)".");
                    }
                    if (env.containsKey("ant")) {
                        this.setAntProperties(env);
                        this.setLibraryReferences(env);
                    }
                    if (this.isVerboseOn()) {
                        env.put("verbose", (Object)Boolean.TRUE);
                    }
                    env.put("args", (Object)args);
                    this.validate(env);
                    this.setExcludePackageAndNamespaces(env);
                    this.loadDefaultNSPackageMapping(env);
                    this.setPackageAndNamespaces(env);
                    processor.setEnvironment(env);
                    processor.process();
                }
            }
            catch (ToolException ex) {
                System.err.println("Error : " + ex.getMessage());
                if (ex.getCause() instanceof BadUsageException) {
                    WSDLToJava.getInstance().printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
                }
                System.err.println();
                if (this.isVerboseOn()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                System.err.println("Error : " + ex.getMessage());
                System.err.println();
                if (!this.isVerboseOn()) break block9;
                ex.printStackTrace();
            }
        }
    }

    private void loadDefaultNSPackageMapping(ToolContext env) {
        if (!env.hasExcludeNamespace(DEFAULT_NS2PACKAGE) && env.getBooleanValue("defaultns", "true")) {
            env.loadDefaultNS2Pck(WSDLToJava.getResourceAsStream("namespace2package.cfg"));
        }
        if (env.getBooleanValue("defaultex", "true")) {
            env.loadDefaultExcludes(WSDLToJava.getResourceAsStream("wsdltojavaexclude.cfg"));
        }
    }

    private void setExcludePackageAndNamespaces(ToolContext env) {
        if (env.get("nexclude") != null) {
            String[] pns = (String[])env.get("nexclude");
            for (int j = 0; j < pns.length; ++j) {
                int pos = pns[j].indexOf("=");
                String excludePackagename = pns[j];
                if (pos != -1) {
                    String ns = pns[j].substring(0, pos);
                    excludePackagename = pns[j].substring(pos + 1);
                    env.addExcludeNamespacePackageMap(ns, excludePackagename);
                    continue;
                }
                env.addExcludeNamespacePackageMap(pns[j], null);
            }
        }
    }

    private void setPackageAndNamespaces(ToolContext env) {
        if (env.get("packagename") != null) {
            String[] pns = (String[])env.get("packagename");
            for (int j = 0; j < pns.length; ++j) {
                int pos = pns[j].indexOf("=");
                String packagename = pns[j];
                if (pos != -1) {
                    String ns = pns[j].substring(0, pos);
                    packagename = pns[j].substring(pos + 1);
                    env.addNamespacePackageMap(ns, packagename);
                    continue;
                }
                env.setPackageName(packagename);
            }
        }
    }

    private void validate(ToolContext env) throws ToolException {
        File dir;
        String clsdir;
        String outdir = (String)env.get("outputdir");
        if (outdir != null) {
            File dir2 = new File(outdir);
            if (!dir2.exists()) {
                Message msg = new Message("DIRECTORY_NOT_EXIST", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
            if (!dir2.isDirectory()) {
                Message msg = new Message("NOT_A_DIRECTORY", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
        }
        if (env.containsKey("binding")) {
            String[] bindings = (String[])env.get("binding");
            for (int i = 0; i < bindings.length; ++i) {
                File binding = new File(bindings[i]);
                if (!binding.exists()) {
                    Message msg = new Message("FILE_NOT_EXIST", LOG, new Object[]{binding});
                    throw new ToolException(msg);
                }
                if (!binding.isDirectory()) continue;
                Message msg = new Message("NOT_A_FILE", LOG, new Object[]{binding});
                throw new ToolException(msg);
            }
        }
        if (!env.optionSet("exsoapheader")) {
            env.put("exsoapheader", (Object)"false");
        }
        if (env.optionSet("compile") && (clsdir = (String)env.get("classdir")) != null && !(dir = new File(clsdir)).exists()) {
            Message msg = new Message("DIRECTORY_NOT_EXIST", LOG, new Object[]{clsdir});
            throw new ToolException(msg);
        }
    }

    protected void setAntProperties(ToolContext env) {
        String installDir = System.getProperty("install.dir");
        if (installDir != null) {
            env.put("install.dir", (Object)installDir);
        } else {
            env.put("install.dir", (Object)".");
        }
    }

    protected void setLibraryReferences(ToolContext env) {
        Properties props = this.loadProperties(WSDLToJava.getResourceAsStream("wsdltojavalib.properties"));
        if (props != null) {
            for (String string : props.keySet()) {
                env.put(string, props.get(string));
            }
        }
        env.put("ant.prop", (Object)props);
    }

    public static void main(String[] pargs) {
        args = pargs;
        try {
            ToolRunner.runTool(WSDLToJava.class, (InputStream)WSDLToJava.getResourceAsStream("wsdl2java.xml"), (boolean)false, (String[])args);
        }
        catch (BadUsageException ex) {
            WSDLToJava.getInstance().printUsageException(TOOL_NAME, ex);
        }
        catch (Exception ex) {
            System.err.println("Error : " + ex.getMessage());
            System.err.println();
            ex.printStackTrace();
        }
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }

    private static InputStream getResourceAsStream(String file) {
        return WSDLToJava.class.getResourceAsStream(file);
    }
}

