/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.databindings.jaxb;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.Property;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import com.sun.tools.xjc.api.XJC;
import com.sun.tools.xjc.api.impl.s2j.SchemaCompilerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.DataBindingGenerator;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.JAXBUtils;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.tools.wsdl2java.databindings.jaxb.JAXBBindErrorListener;
import org.apache.cxf.tools.wsdl2java.databindings.jaxb.JAXBBindingMerger;
import org.apache.cxf.tools.wsdl2java.databindings.jaxb.TypesCodeWriter;
import org.apache.cxf.tools.wsdl2java.processor.internal.ClassNameAllocatorImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBBindingGenerator
implements DataBindingGenerator {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBBindingGenerator.class);
    protected S2JJAXBModel rawJaxbModel;
    protected S2JJAXBModel rawJaxbModelGenCode;
    private boolean nestedJaxbBinding;
    private ToolContext env;
    private int fileIDX;

    public void initialize(ToolContext penv) throws ToolException {
        this.env = penv;
        SchemaCompilerImpl schemaCompiler = (SchemaCompilerImpl)XJC.createSchemaCompiler();
        ClassCollector classCollector = (ClassCollector)this.env.get("generatedClassCollector");
        ClassNameAllocatorImpl allocator = new ClassNameAllocatorImpl(classCollector);
        Map portTypeMap = (Map)this.env.get("portTypeMap");
        Definition def = (Definition)this.env.get("wsdlDefinition");
        allocator.setPortTypes(portTypeMap.values(), this.env.mapPackageName(def.getTargetNamespace()));
        schemaCompiler.setClassNameAllocator((ClassNameAllocator)allocator);
        JAXBBindErrorListener listener = new JAXBBindErrorListener(this.env);
        schemaCompiler.setErrorListener((ErrorListener)listener);
        SchemaCompilerImpl schemaCompilerGenCode = schemaCompiler;
        String excludePackageName = "";
        if (this.env.isExcludeNamespaceEnabled()) {
            schemaCompilerGenCode = (SchemaCompilerImpl)XJC.createSchemaCompiler();
            schemaCompilerGenCode.setClassNameAllocator((ClassNameAllocator)allocator);
            schemaCompilerGenCode.setErrorListener((ErrorListener)listener);
        }
        ArrayList<String> schemaSystemidList = new ArrayList<String>();
        List schemaList = this.env.getSchemaList();
        for (Schema schema : schemaList) {
            Element schemaElement = schema.getElement();
            String targetNamespace = schemaElement.getAttribute("targetNamespace");
            if (StringUtils.isEmpty((String)targetNamespace)) continue;
            if (this.env.hasExcludeNamespace(targetNamespace)) {
                excludePackageName = this.env.getExcludePackageName(targetNamespace);
                if (excludePackageName != null) {
                    this.env.getExcludePkgList().add(excludePackageName);
                } else {
                    this.env.getExcludePkgList().add(URIParserUtil.getPackageName((String)targetNamespace));
                }
            }
            this.customizeSchema(schemaElement, targetNamespace);
            String systemid = schema.getDocumentBaseURI();
            if (schemaSystemidList.contains(systemid)) {
                systemid = schema.getDocumentBaseURI() + "#" + targetNamespace;
            }
            schemaSystemidList.add(systemid);
            if (this.nestedJaxbBinding) {
                InputSource ins = this.processNestedBinding(schemaElement, systemid);
                schemaCompiler.parseSchema(ins);
                schemaCompilerGenCode.parseSchema(ins);
                continue;
            }
            schemaCompiler.parseSchema(systemid, schemaElement);
            schemaCompilerGenCode.parseSchema(systemid, schemaElement);
        }
        Collection jaxbBindingFiles = this.env.getJaxbBindingFile().values();
        for (InputSource bindingFile : jaxbBindingFiles) {
            schemaCompiler.parseSchema(bindingFile);
            if (!this.env.isExcludeNamespaceEnabled()) continue;
            schemaCompilerGenCode.parseSchema(bindingFile);
        }
        this.rawJaxbModel = schemaCompiler.bind();
        this.rawJaxbModelGenCode = this.env.isExcludeNamespaceEnabled() ? schemaCompilerGenCode.bind() : this.rawJaxbModel;
        this.addedEnumClassToCollector(schemaList, allocator);
    }

    private void addedEnumClassToCollector(List<Schema> schemaList, ClassNameAllocatorImpl allocator) {
        for (Schema schema : schemaList) {
            String packageName;
            Element schemaElement = schema.getElement();
            String targetNamespace = schemaElement.getAttribute("targetNamespace");
            if (StringUtils.isEmpty((String)targetNamespace) || this.addedToClassCollector(packageName = ProcessorUtil.parsePackageName((String)targetNamespace, null))) continue;
            allocator.assignClassName(packageName, "*");
        }
    }

    private boolean addedToClassCollector(String packageName) {
        ClassCollector classCollector = (ClassCollector)this.env.get("generatedClassCollector");
        List files = classCollector.getGeneratedFileInfo();
        for (String file : files) {
            int dotIndex;
            String sub = file.substring(0, (dotIndex = file.lastIndexOf(".")) - 1);
            if (!sub.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private InputSource processNestedBinding(Element schemaElement, String systemid) {
        String xsdFile = "schema" + this.fileIDX++;
        File file = null;
        try {
            file = File.createTempFile(xsdFile, ".xsd");
            file.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StreamResult result = new StreamResult(file);
        DOMSource source = new DOMSource(schemaElement);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        InputSource insource = null;
        insource = new InputSource(result.getSystemId());
        return insource;
    }

    public void generate() throws ToolException {
        if (this.rawJaxbModelGenCode == null) {
            return;
        }
        try {
            String dir = (String)this.env.get("outputdir");
            TypesCodeWriter fileCodeWriter = new TypesCodeWriter(new File(dir), this.env.getExcludePkgList());
            if (this.rawJaxbModelGenCode instanceof S2JJAXBModel) {
                S2JJAXBModel schem2JavaJaxbModel = this.rawJaxbModelGenCode;
                JCodeModel jcodeModel = schem2JavaJaxbModel.generateCode(null, null);
                jcodeModel.build((CodeWriter)fileCodeWriter);
                for (String str : fileCodeWriter.getExcludeFileList()) {
                    this.env.getExcludeFileList().add(str);
                }
            }
            return;
        }
        catch (IOException e) {
            Message msg = new Message("FAIL_TO_GENERATE_TYPES", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    public String getType(QName qn, boolean fullName) {
        if (this.rawJaxbModel == null) {
            return null;
        }
        Mapping mapping = this.rawJaxbModel.get(qn);
        if (mapping == null) {
            return null;
        }
        if (fullName) {
            String type = mapping.getType().getTypeClass().fullName();
            if (type == null) {
                type = mapping.getType().getTypeClass().boxify().fullName();
            }
            return type;
        }
        String type = mapping.getType().getTypeClass().name();
        if (type == null) {
            type = mapping.getType().getTypeClass().boxify().name();
        }
        return type;
    }

    public String getJavaType(QName qn, boolean boxify) {
        if (this.rawJaxbModel == null) {
            return null;
        }
        TypeAndAnnotation jtype = this.rawJaxbModel.getJavaType(qn);
        if (jtype == null || jtype.getTypeClass() == null) {
            return null;
        }
        String jtypeClass = boxify ? jtype.getTypeClass().boxify().fullName() : jtype.getTypeClass().fullName();
        return jtypeClass;
    }

    private void customizeSchema(Element schema, String targetNamespace) {
        String userPackage = this.env.mapPackageName(targetNamespace);
        if (this.env.hasExcludeNamespace(targetNamespace) && this.env.getExcludePackageName(targetNamespace) != null) {
            userPackage = this.env.getExcludePackageName(targetNamespace);
        }
        if (!this.isSchemaParsed(targetNamespace) && !StringUtils.isEmpty((String)userPackage)) {
            Node jaxbBindings = JAXBUtils.innerJaxbPackageBinding((Element)schema, (String)userPackage);
            schema.appendChild(jaxbBindings);
        }
        int nodeListLen = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import").getLength();
        for (int i = 0; i < nodeListLen; ++i) {
            this.removeImportElement(schema);
        }
        JAXBBindingMerger jaxbBindingMerger = new JAXBBindingMerger();
        jaxbBindingMerger.mergeJaxwsBinding(schema, this.env);
        if (jaxbBindingMerger.isMerged()) {
            this.nestedJaxbBinding = true;
        }
    }

    private void removeImportElement(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        if (nodeList.getLength() > 0) {
            Node importNode = nodeList.item(0);
            Node schemaNode = importNode.getParentNode();
            schemaNode.removeChild(importNode);
        }
    }

    private boolean isSchemaParsed(String targetNamespace) {
        List schemaNamespaces = (List)this.env.get("schemaTargetNameSpaces");
        if (!schemaNamespaces.contains(targetNamespace)) {
            schemaNamespaces.add(targetNamespace);
            return false;
        }
        return true;
    }

    public List<? extends Property> getBlock(Part part) {
        if (part == null) {
            return new ArrayList();
        }
        QName element = ProcessorUtil.getElementName((Part)part);
        if (element != null && this.rawJaxbModel != null) {
            Mapping mapping = this.rawJaxbModel.get(element);
            if (mapping != null) {
                return mapping.getWrapperStyleDrilldown();
            }
            Message msg = new Message("ELEMENT_MISSING", LOG, new Object[]{element.toString(), part.getName()});
            System.err.println(msg);
        }
        return new ArrayList();
    }
}

