/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.frontend.jaxws;

import java.util.Map;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.wsdl2java.frontend.jaxws.AbstractGenerator;
import org.apache.cxf.tools.wsdl2java.frontend.jaxws.HandlerConfigGenerator;

public class SEIGenerator
extends AbstractGenerator {
    private static final String SEI_TEMPLATE = "org/apache/cxf/tools/wsdl2java/frontend/jaxws/template/sei.vm";

    public SEIGenerator() {
        this.name = "sei.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genSEI") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genServer") || this.env.optionSet("genService");
    }

    private boolean hasHandlerConfig(JavaInterface intf) {
        return intf.getHandlerChains() != null;
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.getJavaModel();
        if (this.passthrough()) {
            return;
        }
        Map interfaces = javaModel.getInterfaces();
        for (String interfaceName : interfaces.keySet()) {
            JavaInterface intf = (JavaInterface)interfaces.get(interfaceName);
            if (this.hasHandlerConfig(intf)) {
                HandlerConfigGenerator handlerGen = new HandlerConfigGenerator();
                handlerGen.setJavaInterface(intf);
                handlerGen.generate(this.getEnvironment());
                if (handlerGen.getHandlerAnnotation() != null) {
                    intf.addAnnotation(handlerGen.getHandlerAnnotation().toString());
                    intf.addImport("javax.jws.HandlerChain");
                }
            }
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setCommonAttributes();
            this.doWrite(SEI_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName()));
        }
    }
}

