/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor;

import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.common.DataBindingGenerator;
import org.apache.cxf.tools.common.FrontEndGenerator;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.jaxws.CustomizationParser;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.util.WSDLExtensionRegister;
import org.apache.cxf.tools.validator.internal.WSDL11Validator;
import org.apache.cxf.tools.wsdl2java.databindings.jaxb.JAXBBindingGenerator;
import org.apache.cxf.wsdl4jutils.WSDLResolver;
import org.apache.velocity.app.Velocity;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLToProcessor
implements Processor {
    protected static final Logger LOG = LogUtils.getL7dLogger(WSDLToProcessor.class);
    protected static final String WSDL_FILE_NAME_EXT = ".wsdl";
    protected Definition wsdlDefinition;
    protected ToolContext env;
    protected WSDLFactory wsdlFactory;
    protected WSDLReader wsdlReader;
    protected S2JJAXBModel rawJaxbModel;
    protected S2JJAXBModel rawJaxbModelGenCode;
    protected ClassCollector classColletor;
    protected List<String> excludePkgList = new ArrayList<String>();
    protected List<String> excludeGenFiles;
    protected Map<QName, Service> importedServices = new HashMap<QName, Service>();
    protected Map<QName, PortType> importedPortTypes = new HashMap<QName, PortType>();
    protected List<FrontEndGenerator> generators;
    protected boolean nestedJaxbBinding;
    protected Model model;
    protected DataBindingGenerator bindingGenerator;
    protected List<Schema> schemaList = new ArrayList<Schema>();
    private List<Definition> importedDefinitions = new ArrayList<Definition>();
    private List<String> schemaTargetNamespaces = new ArrayList<String>();

    protected Writer getOutputWriter(String newNameExt) throws ToolException {
        String outputDir;
        Writer writer = null;
        String newName = null;
        if (this.env.get("outputfile") != null) {
            newName = (String)this.env.get("outputfile");
        } else {
            String oldName = (String)this.env.get("wsdlurl");
            int position = oldName.lastIndexOf("/");
            if (position < 0) {
                position = oldName.lastIndexOf("\\");
            }
            if (position >= 0) {
                oldName = oldName.substring(position + 1, oldName.length());
            }
            newName = oldName.toLowerCase().indexOf(WSDL_FILE_NAME_EXT) >= 0 ? oldName.substring(0, oldName.length() - 5) + newNameExt + WSDL_FILE_NAME_EXT : oldName + newNameExt;
        }
        if (this.env.get("outputdir") != null) {
            outputDir = (String)this.env.get("outputdir");
            if (!"/".equals(outputDir.substring(outputDir.length() - 1)) && !"\\".equals(outputDir.substring(outputDir.length() - 1))) {
                outputDir = outputDir + "/";
            }
        } else {
            outputDir = "./";
        }
        FileWriterUtil fw = new FileWriterUtil(outputDir);
        try {
            writer = fw.getWriter("", newName);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, new Object[]{this.env.get("outputdir") + System.getProperty("file.seperator") + newName});
            throw new ToolException(msg, (Throwable)ioe);
        }
        return writer;
    }

    protected void parseWSDL(String wsdlURL) throws ToolException {
        try {
            this.wsdlFactory = WSDLFactory.newInstance();
            this.wsdlReader = this.wsdlFactory.newWSDLReader();
            this.wsdlReader.setFeature("javax.wsdl.verbose", false);
            WSDLExtensionRegister register = new WSDLExtensionRegister(this.wsdlFactory, this.wsdlReader);
            register.registerExtensions();
            URIResolver resolver = new URIResolver(wsdlURL);
            InputSource insource = new InputSource(resolver.getInputStream());
            wsdlURL = resolver.getURI().toString();
            this.wsdlDefinition = this.wsdlReader.readWSDL((WSDLLocator)new WSDLResolver(wsdlURL, insource));
            this.parseImports(this.wsdlDefinition);
            this.buildImportedMaps();
        }
        catch (Exception we) {
            Message msg = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, new Object[]{wsdlURL});
            throw new ToolException(msg, (Throwable)we);
        }
    }

    private void buildImportedMaps() {
        for (Definition def : this.importedDefinitions) {
            for (QName qn : def.getServices().keySet()) {
                this.importedServices.put(qn, (Service)def.getServices().get(qn));
            }
        }
        if (this.getWSDLDefinition().getServices().size() == 0 && this.importedServices.size() == 0) {
            for (Definition def : this.importedDefinitions) {
                for (QName qn : def.getPortTypes().keySet()) {
                    this.importedPortTypes.put(qn, (PortType)def.getPortTypes().get(qn));
                }
            }
        }
    }

    private void parseImports(Definition def) {
        ArrayList importList = new ArrayList();
        Map imports = def.getImports();
        for (String uri : imports.keySet()) {
            importList.addAll((List)imports.get(uri));
        }
        for (Import impt : importList) {
            this.parseImports(impt.getDefinition());
            this.importedDefinitions.add(impt.getDefinition());
        }
    }

    private String getVelocityLogFile(String logfile) {
        String logdir = System.getProperty("user.home");
        if (logdir == null || logdir.length() == 0) {
            logdir = System.getProperty("user.dir");
        }
        return logdir + File.separator + logfile;
    }

    private void initVelocity() throws ToolException {
        try {
            Properties props = new Properties();
            String clzName = "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader";
            props.put("resource.loader", "class");
            props.put("class.resource.loader.class", clzName);
            props.put("runtime.log", this.getVelocityLogFile("velocity.log"));
            Velocity.init((Properties)props);
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_INITIALIZE_VELOCITY_ENGINE", LOG, new Object[0]);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
    }

    private void extractSchema(Definition def) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            for (Object obj : typesElement.getExtensibilityElements()) {
                if (!(obj instanceof Schema)) continue;
                Schema schema = (Schema)obj;
                this.addSchema(schema);
            }
        }
    }

    private void initDataModel() {
        this.schemaTargetNamespaces.clear();
        this.extractSchema(this.wsdlDefinition);
        for (Definition def : this.importedDefinitions) {
            this.extractSchema(def);
        }
        this.env.put("wsdlDefinition", (Object)this.wsdlDefinition);
        this.env.put("importedDefinition", this.importedDefinitions);
        this.env.put("schemaList", this.schemaList);
        this.env.put("schemaTargetNameSpaces", this.schemaTargetNamespaces);
        this.env.put("portTypeMap", this.getPortTypes(this.wsdlDefinition));
        if (this.schemaList.size() == 0) {
            if (this.env.isVerbose()) {
                System.err.println("No schema provided in the wsdl file");
            }
            return;
        }
        try {
            this.bindingGenerator = new JAXBBindingGenerator();
            this.bindingGenerator.initialize(this.env);
            this.env.put("BindingGenerator", (Object)this.bindingGenerator);
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_CREATE_DATABINDING_MODEL", LOG, new Object[]{e.getLocalizedMessage()});
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
    }

    protected Map<QName, PortType> getPortTypes(Definition definition) {
        Binding binding;
        Map portTypes = definition.getPortTypes();
        if (portTypes.size() == 0) {
            for (Service service : definition.getServices().values()) {
                for (Port port : service.getPorts().values()) {
                    binding = port.getBinding();
                    portTypes.put(binding.getPortType().getQName(), binding.getPortType());
                }
            }
        }
        if (portTypes.size() == 0) {
            for (Service service : this.importedServices.values()) {
                for (Port port : service.getPorts().values()) {
                    binding = port.getBinding();
                    portTypes.put(binding.getPortType().getQName(), binding.getPortType());
                }
            }
        }
        if (portTypes.size() == 0) {
            portTypes.putAll(this.importedPortTypes);
        }
        return portTypes;
    }

    private boolean isSchemaParsed(String targetNamespace) {
        if (!this.schemaTargetNamespaces.contains(targetNamespace)) {
            this.schemaTargetNamespaces.add(targetNamespace);
            return false;
        }
        return true;
    }

    private boolean isSchemaImported(Schema schema) {
        return this.schemaList.contains(schema);
    }

    private void addSchema(Schema schema) {
        Map imports = schema.getImports();
        if (imports != null && imports.size() > 0) {
            Set importKeys = imports.keySet();
            for (String importNamespace : importKeys) {
                if (this.isSchemaParsed(importNamespace + "?file=" + schema.getDocumentBaseURI())) continue;
                List schemaImports = (List)imports.get(importNamespace);
                for (SchemaImport schemaImport : schemaImports) {
                    Schema tempImport = schemaImport.getReferencedSchema();
                    if (tempImport == null || this.isSchemaImported(tempImport)) continue;
                    this.addSchema(tempImport);
                }
            }
        }
        if (!this.isSchemaImported(schema)) {
            this.schemaList.add(schema);
        }
    }

    public void parseCustomization(Definition def) {
        CustomizationParser customizationParser = CustomizationParser.getInstance();
        customizationParser.clean();
        if (!this.env.optionSet("binding")) {
            return;
        }
        customizationParser.parse(this.env, def);
    }

    protected void init() throws ToolException {
        this.parseWSDL((String)this.env.get("wsdlurl"));
        this.checkSupported(this.getWSDLDefinition());
        this.validateWSDL(this.getWSDLDefinition());
        this.parseCustomization(this.getWSDLDefinition());
        this.initVelocity();
        this.classColletor = new ClassCollector();
        this.env.put("generatedClassCollector", (Object)this.classColletor);
        this.initDataModel();
    }

    public Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    public void process() throws ToolException {
    }

    public void validateWSDL(Definition def) throws ToolException {
        if (this.env.validateWSDL()) {
            WSDL11Validator validator = new WSDL11Validator(def, this.env);
            validator.isValid();
        }
    }

    protected void doGeneration() throws ToolException {
        for (FrontEndGenerator plugin : this.generators) {
            plugin.generate(this.env);
        }
    }

    public void setEnvironment(ToolContext penv) {
        this.env = penv;
    }

    public ToolContext getEnvironment() {
        return this.env;
    }

    public void checkSupported(Definition def) throws ToolException {
        if (this.isRPCEncoded(this.wsdlDefinition)) {
            Message msg = new Message("UNSUPPORTED_RPC_ENCODED", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private boolean isRPCEncoded(Definition def) {
        for (Binding binding : def.getBindings().values()) {
            String bindingStyle = SOAPBindingUtil.getBindingStyle((Binding)binding);
            for (BindingOperation bop : binding.getBindingOperations()) {
                String bopStyle = SOAPBindingUtil.getSOAPOperationStyle((BindingOperation)bop);
                String outputUse = "";
                if (SOAPBindingUtil.getBindingOutputSOAPBody((BindingOperation)bop) != null) {
                    outputUse = SOAPBindingUtil.getBindingOutputSOAPBody((BindingOperation)bop).getUse();
                }
                String inputUse = "";
                if (SOAPBindingUtil.getBindingInputSOAPBody((BindingOperation)bop) != null) {
                    inputUse = SOAPBindingUtil.getBindingInputSOAPBody((BindingOperation)bop).getUse();
                }
                if (!SOAPBinding.Style.RPC.name().equalsIgnoreCase(bindingStyle) && !SOAPBinding.Style.RPC.name().equalsIgnoreCase(bopStyle) || !SOAPBinding.Use.ENCODED.name().equalsIgnoreCase(inputUse) && !SOAPBinding.Use.ENCODED.name().equalsIgnoreCase(outputUse)) continue;
                return true;
            }
        }
        return false;
    }
}

