/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import com.sun.tools.xjc.api.ClassNameAllocator;
import java.util.Collection;
import javax.wsdl.PortType;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.ProcessorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameAllocatorImpl
implements ClassNameAllocator {
    private static final String TYPE_SUFFIX = "_Type";
    private Collection<PortType> portTypes;
    private ClassCollector collector;

    public ClassNameAllocatorImpl(ClassCollector classCollector) {
        this.collector = classCollector;
    }

    private boolean isNameCollision(String packageName, String className) {
        return this.collector.containSeiClass(packageName, className);
    }

    public String assignClassName(String packageName, String className) {
        String fullClzName = className;
        if (this.isNameCollision(packageName, className)) {
            fullClzName = className + TYPE_SUFFIX;
        }
        this.collector.addTypesClassName(packageName, className, packageName + "." + fullClzName);
        return fullClzName;
    }

    public void setPortTypes(Collection<PortType> types, String packageName) {
        this.portTypes = types;
        this.setSeiClassNames(packageName);
    }

    private void setSeiClassNames(String packageName) {
        for (PortType porttype : this.portTypes) {
            String ns = porttype.getQName().getNamespaceURI();
            String type = porttype.getQName().getLocalPart();
            String pkgName = ProcessorUtil.parsePackageName((String)ns, (String)packageName);
            String className = ProcessorUtil.mangleNameToClassName((String)type);
            String fullClassName = pkgName + "." + className;
            if (packageName == null) {
                packageName = pkgName;
            }
            this.collector.addSeiClassName(packageName, className, fullClassName);
        }
    }
}

