/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.jaxws.CustomizationParser;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBinding;
import org.apache.cxf.tools.common.model.JavaAnnotation;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.wsdl2java.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdl2java.processor.internal.FaultProcessor;
import org.apache.cxf.tools.wsdl2java.processor.internal.ParameterProcessor;

public class OperationProcessor
extends AbstractProcessor {
    private JavaParameter wrapperRequest;
    private JavaParameter wrapperResponse;

    public OperationProcessor(ToolContext penv) {
        super(penv);
    }

    public void process(JavaInterface intf, Operation operation) throws ToolException {
        JavaMethod method = new JavaMethod(intf);
        method.setSoapStyle(SOAPBinding.Style.DOCUMENT);
        method.setName(ProcessorUtil.mangleNameToVariableName((String)operation.getName()));
        method.setOperationName(operation.getName());
        method.setStyle(operation.getStyle());
        if (method.getStyle() == null) {
            if (operation.getOutput() == null) {
                method.setStyle(OperationType.ONE_WAY);
            } else {
                method.setStyle(OperationType.REQUEST_RESPONSE);
            }
        }
        method.setWrapperStyle(this.isWrapperStyle(operation));
        method.setJAXWSBinding(this.customizing(intf, operation));
        this.processMethod(method, operation);
        Map faults = operation.getFaults();
        FaultProcessor faultProcessor = new FaultProcessor(this.env);
        faultProcessor.process(method, faults);
        intf.addMethod(method);
    }

    public void processMethod(JavaMethod method, Operation operation) throws ToolException {
        Message outputMessage;
        List parameterOrder = operation.getParameterOrdering();
        Message inputMessage = operation.getInput() == null ? null : operation.getInput().getMessage();
        Message message = outputMessage = operation.getOutput() == null ? null : operation.getOutput().getMessage();
        if (inputMessage == null) {
            LOG.log(Level.WARNING, "NO_INPUT_MESSAGE", new Object[]{operation.getName()});
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MEP", LOG, new Object[]{operation.getName()});
            throw new ToolException(msg);
        }
        ParameterProcessor paramProcessor = new ParameterProcessor(this.env);
        method.clear();
        paramProcessor.process(method, inputMessage, outputMessage, this.isRequestResponse(operation), parameterOrder);
        this.isWrapperStyle(operation);
        this.addWebMethodAnnotation(method);
        this.addWrapperAnnotation(method, operation);
        this.addWebResultAnnotation(method);
        this.addSOAPBindingAnnotation(method);
        if (!method.isOneWay() && method.getJAXWSBinding().isEnableAsyncMapping()) {
            this.addAsyncMethod(method);
        }
    }

    private void addSOAPBindingAnnotation(JavaMethod method) {
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && !method.isWrapperStyle()) {
            JavaAnnotation bindingAnnotation = new JavaAnnotation("SOAPBinding");
            bindingAnnotation.addArgument("parameterStyle", SOAPBindingUtil.getBindingAnnotation((String)"BARE"), "");
            method.addAnnotation("SOAPBinding", bindingAnnotation);
        }
    }

    private void addWebMethodAnnotation(JavaMethod method) {
        this.addWebMethodAnnotation(method, method.getOperationName());
    }

    private void addWebMethodAnnotation(JavaMethod method, String operationName) {
        JavaAnnotation methodAnnotation = new JavaAnnotation("WebMethod");
        methodAnnotation.addArgument("operationName", operationName);
        if (!StringUtils.isEmpty((String)method.getSoapAction())) {
            methodAnnotation.addArgument("action", method.getSoapAction());
        }
        method.addAnnotation("WebMethod", methodAnnotation);
        method.getInterface().addImport("javax.jws.WebMethod");
    }

    private void addWebResultAnnotation(JavaMethod method) {
        if (method.isOneWay()) {
            JavaAnnotation oneWayAnnotation = new JavaAnnotation("Oneway");
            method.addAnnotation("Oneway", oneWayAnnotation);
            method.getInterface().addImport("javax.jws.Oneway");
            return;
        }
        if ("void".equals(method.getReturn().getType())) {
            return;
        }
        JavaAnnotation resultAnnotation = new JavaAnnotation("WebResult");
        String targetNamespace = method.getReturn().getTargetNamespace();
        String name = "return";
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && !method.isWrapperStyle()) {
            name = method.getName() + "Response";
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC) {
            name = method.getReturn().getName();
            targetNamespace = method.getInterface().getNamespace();
        }
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT) {
            if (method.getReturn().getQName() != null) {
                name = method.getReturn().getQName().getLocalPart();
            }
            targetNamespace = method.getReturn().getTargetNamespace();
        }
        resultAnnotation.addArgument("name", name);
        resultAnnotation.addArgument("targetNamespace", targetNamespace);
        if (method.getSoapStyle() == SOAPBinding.Style.RPC || method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && !method.isWrapperStyle()) {
            resultAnnotation.addArgument("partName", method.getReturn().getName());
        }
        method.addAnnotation("WebResult", resultAnnotation);
        method.getInterface().addImport("javax.jws.WebResult");
    }

    protected void addWrapperAnnotation(JavaMethod method, Operation operation) {
        if (!this.isWrapperStyle(operation)) {
            return;
        }
        if (this.wrapperRequest != null) {
            JavaAnnotation wrapperRequestAnnotation = new JavaAnnotation("RequestWrapper");
            wrapperRequestAnnotation.addArgument("localName", this.wrapperRequest.getType());
            wrapperRequestAnnotation.addArgument("targetNamespace", this.wrapperRequest.getTargetNamespace());
            wrapperRequestAnnotation.addArgument("className", this.wrapperRequest.getClassName());
            method.addAnnotation("RequestWrapper", wrapperRequestAnnotation);
            method.getInterface().addImport("javax.xml.ws.RequestWrapper");
        }
        if (this.wrapperResponse != null) {
            JavaAnnotation wrapperResponseAnnotation = new JavaAnnotation("ResponseWrapper");
            wrapperResponseAnnotation.addArgument("localName", this.wrapperResponse.getType());
            wrapperResponseAnnotation.addArgument("targetNamespace", this.wrapperResponse.getTargetNamespace());
            wrapperResponseAnnotation.addArgument("className", this.wrapperResponse.getClassName());
            method.addAnnotation("ResponseWrapper", wrapperResponseAnnotation);
            method.getInterface().addImport("javax.xml.ws.ResponseWrapper");
        }
    }

    private boolean isWrapperStyle(Operation operation) {
        QName outputElement;
        Message inputMessage = operation.getInput() == null ? null : operation.getInput().getMessage();
        Message outputMessage = operation.getOutput() == null ? null : operation.getOutput().getMessage();
        Map inputParts = new HashMap();
        Map outputParts = new HashMap();
        if (inputMessage != null) {
            inputParts = inputMessage.getParts();
        }
        if (outputMessage != null) {
            outputParts = outputMessage.getParts();
        }
        if (inputParts.size() > 1 || outputParts.size() > 1) {
            return false;
        }
        Part inputPart = null;
        if (inputParts.size() == 1 && (inputPart = (Part)inputParts.values().iterator().next()) != null) {
            QName inputElement = inputPart.getElementName();
            if (inputElement == null) {
                return false;
            }
            if (!operation.getName().equals(inputElement.getLocalPart())) {
                return false;
            }
        }
        Part outputPart = null;
        if (outputParts.size() == 1 && (outputPart = (Part)outputParts.values().iterator().next()) != null && (outputElement = outputPart.getElementName()) == null) {
            return false;
        }
        if (this.dataBinder.getBlock(inputPart) == null || this.dataBinder.getBlock(outputPart) == null) {
            return false;
        }
        if (inputPart != null) {
            this.wrapperRequest = new JavaParameter();
            this.wrapperRequest.setName(ProcessorUtil.resolvePartName((Part)inputPart));
            this.wrapperRequest.setType(ProcessorUtil.getPartType((Part)inputPart));
            this.wrapperRequest.setTargetNamespace(ProcessorUtil.resolvePartNamespace((Part)inputPart));
            this.wrapperRequest.setClassName(ProcessorUtil.getFullClzName((Part)inputPart, (ToolContext)this.env, (ClassCollector)this.collector, (boolean)false));
        }
        if (outputPart != null) {
            this.wrapperResponse = new JavaParameter();
            this.wrapperResponse.setName(ProcessorUtil.resolvePartName((Part)outputPart));
            this.wrapperResponse.setType(ProcessorUtil.getPartType((Part)outputPart));
            this.wrapperResponse.setTargetNamespace(ProcessorUtil.resolvePartNamespace((Part)outputPart));
            this.wrapperResponse.setClassName(ProcessorUtil.getFullClzName((Part)outputPart, (ToolContext)this.env, (ClassCollector)this.collector, (boolean)false));
        }
        return true;
    }

    private boolean isRequestResponse(Operation operation) {
        if (operation.getStyle() == null) {
            return operation.getOutput() != null;
        }
        return OperationType.REQUEST_RESPONSE.equals(operation.getStyle());
    }

    private JAXWSBinding customizing(JavaInterface intf, Operation operation) {
        JAXWSBinding binding = null;
        List extElements = operation.getExtensibilityElements();
        if (extElements.size() > 0) {
            for (Object obj : extElements) {
                if (!(obj instanceof JAXWSBinding)) continue;
                binding = (JAXWSBinding)obj;
            }
        } else {
            String portTypeName = intf.getWebServiceName();
            String operationName = operation.getName();
            binding = CustomizationParser.getInstance().getPortTypeOperationExtension(portTypeName, operationName);
        }
        if (binding == null) {
            binding = new JAXWSBinding();
        }
        if (!binding.isSetAsyncMapping() && (intf.getJavaModel().getJAXWSBinding().isEnableAsyncMapping() || intf.getJAXWSBinding().isEnableAsyncMapping())) {
            binding.setEnableAsyncMapping(true);
        }
        return binding;
    }

    private void addAsyncMethod(JavaMethod method) throws ToolException {
        this.addPollingMethod(method);
        this.addCallbackMethod(method);
        method.getInterface().addImport("javax.xml.ws.AsyncHandler");
        method.getInterface().addImport("java.util.concurrent.Future");
        method.getInterface().addImport("javax.xml.ws.Response");
    }

    private void addPollingMethod(JavaMethod method) throws ToolException {
        JavaMethod pollingMethod = new JavaMethod(method.getInterface());
        pollingMethod.setName(method.getName() + "Async");
        pollingMethod.setStyle(method.getStyle());
        pollingMethod.setWrapperStyle(method.isWrapperStyle());
        pollingMethod.setSoapAction(method.getSoapAction());
        JavaReturn future = new JavaReturn();
        future.setClassName("Future<?>");
        pollingMethod.setReturn(future);
        this.addWebMethodAnnotation(pollingMethod, method.getOperationName());
        pollingMethod.addAnnotation("ResponseWrapper", (JavaAnnotation)method.getAnnotationMap().get("ResponseWrapper"));
        pollingMethod.addAnnotation("RequestWrapper", (JavaAnnotation)method.getAnnotationMap().get("RequestWrapper"));
        pollingMethod.addAnnotation("SOAPBinding", (JavaAnnotation)method.getAnnotationMap().get("SOAPBinding"));
        Iterator iter = method.getParameters().iterator();
        while (iter.hasNext()) {
            pollingMethod.addParameter((JavaParameter)iter.next());
        }
        JavaParameter asyncHandler = new JavaParameter();
        asyncHandler.setName("asyncHandler");
        asyncHandler.setClassName(this.getAsyncClassName(method, "AsyncHandler"));
        JavaAnnotation asyncHandlerAnnotation = new JavaAnnotation("WebParam");
        asyncHandlerAnnotation.addArgument("name", "asyncHandler");
        asyncHandlerAnnotation.addArgument("targetNamespace", "");
        asyncHandler.setAnnotation(asyncHandlerAnnotation);
        pollingMethod.addParameter(asyncHandler);
        method.getInterface().addMethod(pollingMethod);
    }

    private void addCallbackMethod(JavaMethod method) throws ToolException {
        JavaMethod callbackMethod = new JavaMethod(method.getInterface());
        callbackMethod.setName(method.getName() + "Async");
        callbackMethod.setStyle(method.getStyle());
        callbackMethod.setWrapperStyle(method.isWrapperStyle());
        callbackMethod.setSoapAction(method.getSoapAction());
        JavaReturn response = new JavaReturn();
        response.setClassName(this.getAsyncClassName(method, "Response"));
        callbackMethod.setReturn(response);
        this.addWebMethodAnnotation(callbackMethod, method.getOperationName());
        callbackMethod.addAnnotation("RequestWrapper", (JavaAnnotation)method.getAnnotationMap().get("RequestWrapper"));
        callbackMethod.addAnnotation("ResponseWrapper", (JavaAnnotation)method.getAnnotationMap().get("ResponseWrapper"));
        callbackMethod.addAnnotation("SOAPBinding", (JavaAnnotation)method.getAnnotationMap().get("SOAPBinding"));
        Iterator iter = method.getParameters().iterator();
        while (iter.hasNext()) {
            callbackMethod.addParameter((JavaParameter)iter.next());
        }
        method.getInterface().addMethod(callbackMethod);
    }

    private String getAsyncClassName(JavaMethod method, String clzName) {
        String response = this.wrapperResponse != null ? this.wrapperResponse.getClassName() : method.getReturn().getClassName();
        StringBuffer sb = new StringBuffer();
        sb.append(clzName);
        sb.append("<");
        sb.append(response);
        sb.append(">");
        return sb.toString();
    }
}

