/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.jaxws.CustomizationParser;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBinding;
import org.apache.cxf.tools.common.extensions.jms.JMSAddress;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.common.extensions.soap.SoapBinding;
import org.apache.cxf.tools.common.extensions.soap.SoapBody;
import org.apache.cxf.tools.common.extensions.soap.SoapHeader;
import org.apache.cxf.tools.common.extensions.soap.SoapOperation;
import org.apache.cxf.tools.common.model.JavaAnnotation;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineParser;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.wsdl2java.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdl2java.processor.internal.OperationProcessor;
import org.apache.cxf.tools.wsdl2java.processor.internal.ParameterProcessor;

public class ServiceProcessor
extends AbstractProcessor {
    private static final Logger LOG = LogUtils.getL7dLogger(CommandLineParser.class);
    private String soapOPAction = "SOAPACTION";
    private String soapOPStyle = "STYLE";
    private Definition definition;
    private BindingType bindingType;
    private final int inHEADER = 1;
    private final int outHEADER = 2;
    private final int resultHeader = 3;
    private final int noHEADER = 0;
    private Object bindingObj;

    public ServiceProcessor(ToolContext penv) {
        super(penv);
    }

    public ServiceProcessor(ToolContext penv, Definition def) {
        super(penv);
        this.definition = def;
    }

    public void process(JavaModel model) throws ToolException {
        Collection services = this.definition.getServices().values();
        if (services.size() == 0) {
            for (Binding binding : this.definition.getBindings().values()) {
                for (BindingOperation bop : binding.getBindingOperations()) {
                    this.processOperation(model, bop, binding);
                }
            }
            return;
        }
        for (Service service : services) {
            this.processService(model, service);
        }
    }

    private boolean isNameCollision(String packageName, String className) {
        if (this.env.optionSet("overwrite")) {
            return false;
        }
        return this.collector.containTypesClass(packageName, className) || this.collector.containSeiClass(packageName, className) || this.collector.containExceptionClass(packageName, className);
    }

    private void processService(JavaModel model, Service service) throws ToolException {
        JavaServiceClass sclz = new JavaServiceClass(model);
        String name = ProcessorUtil.mangleNameToClassName((String)service.getQName().getLocalPart());
        String namespace = service.getQName().getNamespaceURI();
        String packageName = ProcessorUtil.parsePackageName((String)namespace, (String)this.env.mapPackageName(namespace));
        while (this.isNameCollision(packageName, name)) {
            name = name + "_Service";
        }
        sclz.setName(name);
        sclz.setServiceName(service.getQName().getLocalPart());
        sclz.setNamespace(namespace);
        sclz.setPackageName(packageName);
        Map ports = service.getPorts();
        for (Port port : ports.values()) {
            JavaPort javaport = this.processPort(model, port);
            sclz.addPort(javaport);
        }
        model.addServiceClass(name, sclz);
    }

    private JavaPort processPort(JavaModel model, Port port) throws ToolException {
        JavaPort jport = new JavaPort(ProcessorUtil.mangleNameToClassName((String)port.getName()));
        jport.setPortName(port.getName());
        Binding binding = port.getBinding();
        jport.setBindingAdress(this.getPortAddress(port));
        jport.setBindingName(binding.getQName().getLocalPart());
        String namespace = binding.getPortType().getQName().getNamespaceURI();
        String packageName = ProcessorUtil.parsePackageName((String)namespace, (String)this.env.mapPackageName(namespace));
        jport.setPackageName(packageName);
        String portType = binding.getPortType().getQName().getLocalPart();
        jport.setPortType(portType);
        jport.setInterfaceClass(ProcessorUtil.mangleNameToClassName((String)portType));
        this.bindingType = this.getBindingType(binding);
        if (this.bindingType == null) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("BINDING_SPECIFY_ONE_PROTOCOL", LOG, new Object[]{binding.getQName()});
            throw new ToolException(msg);
        }
        if (this.isSoapBinding()) {
            SoapBinding spbd = (SoapBinding)SOAPBindingUtil.getProxy(SoapBinding.class, (Object)this.bindingObj);
            jport.setStyle(this.getSoapStyle(spbd.getStyle()));
            jport.setTransURI(spbd.getTransportURI());
        }
        for (BindingOperation bop : binding.getBindingOperations()) {
            this.processOperation(model, bop, binding);
        }
        return jport;
    }

    private SOAPBinding.Style getSoapStyle(String soapStyle) {
        if ("".equals(soapStyle)) {
            return null;
        }
        if ("RPC".equalsIgnoreCase(soapStyle)) {
            return SOAPBinding.Style.RPC;
        }
        return SOAPBinding.Style.DOCUMENT;
    }

    private SOAPBinding.Use getSoapUse(String soapUse) {
        if ("".equals(soapUse)) {
            return null;
        }
        if ("ENCODED".equalsIgnoreCase(soapUse)) {
            return SOAPBinding.Use.ENCODED;
        }
        return SOAPBinding.Use.LITERAL;
    }

    private void processOperation(JavaModel model, BindingOperation bop, Binding binding) throws ToolException {
        String portType = ProcessorUtil.mangleNameToClassName((String)binding.getPortType().getQName().getLocalPart());
        JavaInterface jf = (JavaInterface)model.getInterfaces().get(portType);
        this.doCustomizeBinding(model, jf, binding);
        if (this.isSoapBinding()) {
            SoapBinding soapBinding = (SoapBinding)this.bindingObj;
            if (this.getSoapStyle(soapBinding.getStyle()) == null) {
                jf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
            } else {
                jf.setSOAPStyle(this.getSoapStyle(soapBinding.getStyle()));
            }
        } else {
            jf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
        }
        Object[] methods = jf.getMethods().toArray();
        for (int i = 0; i < methods.length; ++i) {
            JavaAnnotation resultAnno;
            JavaMethod jm = (JavaMethod)methods[i];
            if (jm.getOperationName() == null || !jm.getOperationName().equals(bop.getName())) continue;
            if (this.isSoapBinding()) {
                this.doCustomizeOperation(jf, jm, bop);
                Map prop = this.getSoapOperationProp(bop);
                String soapAction = prop.get(this.soapOPAction) == null ? "" : (String)prop.get(this.soapOPAction);
                String soapStyle = prop.get(this.soapOPStyle) == null ? "" : (String)prop.get(this.soapOPStyle);
                jm.setSoapAction(soapAction);
                if (this.getSoapStyle(soapStyle) == null && this.bindingObj == null) {
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("BINDING_STYLE_NOT_DEFINED", LOG, new Object[0]);
                    throw new ToolException(msg);
                }
                if (this.getSoapStyle(soapStyle) == null) {
                    jm.setSoapStyle(jf.getSOAPStyle());
                } else {
                    jm.setSoapStyle(this.getSoapStyle(soapStyle));
                }
            } else {
                jm.setSoapStyle(jf.getSOAPStyle());
            }
            if (jm.getSoapStyle().equals((Object)SOAPBinding.Style.RPC)) {
                jm.getAnnotationMap().remove("SOAPBinding");
            }
            OperationProcessor processor = new OperationProcessor(this.env);
            int headerType = this.isNonWrappable(bop);
            if (jm.isWrapperStyle() && headerType > this.noHEADER) {
                jm.setWrapperStyle(false);
                processor.processMethod(jm, bop.getOperation());
                jm.getAnnotationMap().remove("ResponseWrapper");
                jm.getAnnotationMap().remove("RequestWrapper");
            } else {
                processor.processMethod(jm, bop.getOperation());
            }
            if (headerType == this.resultHeader && (resultAnno = (JavaAnnotation)jm.getAnnotationMap().get("WebResult")) != null) {
                resultAnno.addArgument("header", "true", "");
            }
            this.processParameter(jm, bop);
        }
    }

    private void setParameterAsHeader(JavaParameter parameter) {
        parameter.setHeader(true);
        parameter.getAnnotation().addArgument("header", "true", "");
    }

    private void processParameter(JavaMethod jm, BindingOperation operation) throws ToolException {
        JavaParameter jp;
        Iterator inbindings = null;
        if (operation.getBindingInput() != null) {
            inbindings = operation.getBindingInput().getExtensibilityElements().iterator();
        }
        String use = null;
        while (inbindings != null && inbindings.hasNext()) {
            Object obj = inbindings.next();
            if (SOAPBindingUtil.isSOAPBody(obj)) {
                SoapBody soapBody = SOAPBindingUtil.getSoapBody(obj);
                use = soapBody.getUse();
            }
            if (SOAPBindingUtil.isSOAPHeader(obj)) {
                SoapHeader soapHeader = SOAPBindingUtil.getSoapHeader(obj);
                boolean found = false;
                for (JavaParameter parameter : jm.getParameters()) {
                    if (!soapHeader.getPart().equals(parameter.getPartName())) continue;
                    this.setParameterAsHeader(parameter);
                    found = true;
                }
                if (Boolean.valueOf((String)this.env.get("exsoapheader")).booleanValue() && !found) {
                    ParameterProcessor processor = new ParameterProcessor(this.env);
                    Part exPart = this.definition.getMessage(soapHeader.getMessage()).getPart(soapHeader.getPart());
                    JavaType.Style jpStyle = JavaType.Style.IN;
                    if (this.isInOutParam(soapHeader.getPart(), operation.getBindingOutput())) {
                        jpStyle = JavaType.Style.INOUT;
                    }
                    jp = processor.addParameterFromBinding(jm, exPart, jpStyle);
                    if (soapHeader.getPart() != null && soapHeader.getPart().length() > 0) {
                        jp.getAnnotation().addArgument("partName", soapHeader.getPart());
                    }
                    this.setParameterAsHeader(jp);
                }
            }
            if (!(obj instanceof MIMEMultipartRelated) || !jm.getBindingExt().isEnableMime()) continue;
            LOG.warning("The MIME content in wsdl file will be ignored, current version does not support MIME content");
        }
        if (operation.getBindingOutput() != null) {
            for (Object obj : operation.getBindingOutput().getExtensibilityElements()) {
                if (SOAPBindingUtil.isSOAPHeader(obj)) {
                    SoapHeader soapHeader = SOAPBindingUtil.getSoapHeader(obj);
                    boolean found = false;
                    for (JavaParameter parameter : jm.getParameters()) {
                        if (!soapHeader.getPart().equals(parameter.getPartName())) continue;
                        this.setParameterAsHeader(parameter);
                        found = true;
                    }
                    if (jm.getReturn().getName().equals(soapHeader.getPart())) {
                        found = true;
                    }
                    if (Boolean.valueOf((String)this.env.get("exsoapheader")).booleanValue() && !found) {
                        ParameterProcessor processor = new ParameterProcessor(this.env);
                        Part exPart = this.definition.getMessage(soapHeader.getMessage()).getPart(soapHeader.getPart());
                        jp = processor.addParameterFromBinding(jm, exPart, JavaType.Style.OUT);
                        this.setParameterAsHeader(jp);
                    }
                }
                if (!(obj instanceof MIMEMultipartRelated) || !jm.getBindingExt().isEnableMime()) continue;
                LOG.warning("The MIME content in wsdl file will be ignored, current version does not support MIME content");
            }
        }
        jm.setSoapUse(this.getSoapUse(use));
        if (SOAPBinding.Style.RPC == jm.getSoapStyle() && SOAPBinding.Use.ENCODED == jm.getSoapUse()) {
            System.err.println("** Unsupported RPC-Encoded Style Use **");
        }
        if (SOAPBinding.Style.RPC == jm.getSoapStyle() && SOAPBinding.Use.LITERAL == jm.getSoapUse()) {
            return;
        }
        if (SOAPBinding.Style.DOCUMENT == jm.getSoapStyle() && SOAPBinding.Use.LITERAL == jm.getSoapUse()) {
            return;
        }
    }

    private Map getSoapOperationProp(BindingOperation bop) {
        HashMap<String, String> soapOPProp = new HashMap<String, String>();
        if (bop.getExtensibilityElements() != null) {
            for (Object obj : bop.getExtensibilityElements()) {
                if (!SOAPBindingUtil.isSOAPOperation(obj)) continue;
                SoapOperation soapOP = SOAPBindingUtil.getSoapOperation(obj);
                soapOPProp.put(this.soapOPAction, soapOP.getSoapActionURI());
                soapOPProp.put(this.soapOPStyle, soapOP.getStyle());
            }
        }
        return soapOPProp;
    }

    private String getPortAddress(Port port) {
        Iterator it = port.getExtensibilityElements().iterator();
        String address = null;
        while (it.hasNext()) {
            Object obj = it.next();
            if (SOAPBindingUtil.isSOAPAddress(obj)) {
                SoapAddress soapAddress = SOAPBindingUtil.getSoapAddress(obj);
                address = soapAddress.getLocationURI();
            }
            if (obj instanceof JMSAddress) {
                address = ((JMSAddress)obj).getAddress();
            }
            if (!(obj instanceof HTTPAddress)) continue;
            address = ((HTTPAddress)obj).getLocationURI();
        }
        return address;
    }

    private BindingType getBindingType(Binding binding) {
        Iterator it = binding.getExtensibilityElements().iterator();
        if (it.hasNext()) {
            Object obj = it.next();
            if (SOAPBindingUtil.isSOAPBinding(obj)) {
                this.bindingObj = SOAPBindingUtil.getSoapBinding(obj);
                return BindingType.SOAPBinding;
            }
            if (obj instanceof HTTPBinding) {
                this.bindingObj = (HTTPBinding)obj;
                return BindingType.HTTPBinding;
            }
            return BindingType.XMLBinding;
        }
        return null;
    }

    private int isNonWrappable(BindingOperation bop) {
        String operationName = bop.getName();
        Message bodyMessage = null;
        QName headerMessage = null;
        SoapHeader header = null;
        boolean containParts = false;
        boolean isSameMessage = false;
        boolean isNonWrappable = false;
        boolean allPartsHeader = false;
        int result = this.noHEADER;
        if (bop.getBindingInput() != null) {
            for (Object obj : bop.getBindingInput().getExtensibilityElements()) {
                if (SOAPBindingUtil.isSOAPBody(obj)) {
                    bodyMessage = this.getMessage(operationName, true);
                }
                if (!SOAPBindingUtil.isSOAPHeader(obj)) continue;
                header = SOAPBindingUtil.getSoapHeader(obj);
                headerMessage = header.getMessage();
                if (header.getPart().length() <= 0) continue;
                containParts = true;
            }
            if (headerMessage != null && bodyMessage != null && headerMessage.getNamespaceURI().equalsIgnoreCase(bodyMessage.getQName().getNamespaceURI()) && headerMessage.getLocalPart().equalsIgnoreCase(bodyMessage.getQName().getLocalPart())) {
                isSameMessage = true;
            }
            boolean bl = isNonWrappable = isSameMessage && containParts;
            if (isNonWrappable) {
                result = this.inHEADER;
            }
        }
        isSameMessage = false;
        containParts = false;
        if (bop.getBindingOutput() != null) {
            for (Object obj : bop.getBindingOutput().getExtensibilityElements()) {
                if (SOAPBindingUtil.isSOAPBody(obj)) {
                    bodyMessage = this.getMessage(operationName, false);
                }
                if (!SOAPBindingUtil.isSOAPHeader(obj)) continue;
                header = SOAPBindingUtil.getSoapHeader(obj);
                headerMessage = header.getMessage();
                if (header.getPart().length() <= 0) continue;
                containParts = true;
            }
            if (headerMessage != null && bodyMessage != null && headerMessage.getNamespaceURI().equalsIgnoreCase(bodyMessage.getQName().getNamespaceURI()) && headerMessage.getLocalPart().equalsIgnoreCase(bodyMessage.getQName().getLocalPart())) {
                isSameMessage = true;
                if (bodyMessage.getParts().size() == 1) {
                    allPartsHeader = true;
                }
            }
            boolean bl = isNonWrappable = isSameMessage && containParts;
            if (isNonWrappable && allPartsHeader) {
                result = this.resultHeader;
            }
            if (isNonWrappable && !allPartsHeader) {
                result = this.outHEADER;
            }
        }
        return result;
    }

    private Message getMessage(String operationName, boolean isIn) {
        Iterator ite = this.definition.getPortTypes().values().iterator();
        Message msg = null;
        block0: while (ite.hasNext()) {
            PortType portType = (PortType)ite.next();
            for (Operation op : portType.getOperations()) {
                if (!operationName.equals(op.getName())) continue;
                if (isIn) {
                    msg = op.getInput().getMessage();
                    continue block0;
                }
                msg = op.getOutput().getMessage();
                continue block0;
            }
        }
        return msg;
    }

    private void doCustomizeBinding(JavaModel jmodel, JavaInterface ji, Binding binding) {
        JAXWSBinding bindingExt = null;
        List extElements = binding.getExtensibilityElements();
        if (extElements.size() > 0) {
            for (Object obj : extElements) {
                if (!(obj instanceof JAXWSBinding)) continue;
                bindingExt = (JAXWSBinding)obj;
                ji.setBindingExt(bindingExt);
                return;
            }
        }
        String portTypeName = binding.getPortType().getQName().getLocalPart();
        bindingExt = CustomizationParser.getInstance().getPortTypeExtension(portTypeName);
        if (bindingExt != null) {
            if (!bindingExt.isSetMimeEnable() && jmodel.getJAXWSBinding().isSetMimeEnable() && jmodel.getJAXWSBinding().isEnableMime()) {
                bindingExt.setSetMimeEnable(true);
                bindingExt.setEnableMime(true);
            }
        } else if (jmodel.getJAXWSBinding() != null) {
            bindingExt = new JAXWSBinding();
            if (jmodel.getJAXWSBinding().isSetMimeEnable() && jmodel.getJAXWSBinding().isEnableMime()) {
                bindingExt.setSetMimeEnable(true);
                bindingExt.setEnableMime(true);
            }
        } else {
            bindingExt = new JAXWSBinding();
        }
        ji.setBindingExt(bindingExt);
    }

    private void doCustomizeOperation(JavaInterface ji, JavaMethod jm, BindingOperation bo) {
        JAXWSBinding bindingExt = null;
        List extElements = bo.getExtensibilityElements();
        if (extElements.size() > 0) {
            for (Object obj : extElements) {
                if (!(obj instanceof JAXWSBinding)) continue;
                bindingExt = (JAXWSBinding)obj;
                jm.setBindingExt(bindingExt);
                return;
            }
        }
        String portTypeName = ji.getWebServiceName();
        String operationName = bo.getName();
        bindingExt = CustomizationParser.getInstance().getPortTypeOperationExtension(portTypeName, operationName);
        if (bindingExt != null) {
            if (!bindingExt.isSetMimeEnable() && ji.getBindingExt() != null && ji.getBindingExt().isSetMimeEnable() && ji.getBindingExt().isEnableMime()) {
                bindingExt.setSetMimeEnable(true);
                bindingExt.setEnableMime(true);
            }
        } else if (ji.getBindingExt() != null) {
            bindingExt = new JAXWSBinding();
            if (ji.getBindingExt().isSetMimeEnable() && ji.getBindingExt().isEnableMime()) {
                bindingExt.setSetMimeEnable(true);
                bindingExt.setEnableMime(true);
            }
        } else {
            bindingExt = new JAXWSBinding();
        }
        jm.setBindingExt(bindingExt);
    }

    private boolean isSoapBinding() {
        return this.bindingType != null && "SOAPBinding".equals(this.bindingType.name());
    }

    private boolean isInOutParam(String inPartName, BindingOutput bop) {
        for (Object obj : bop.getExtensibilityElements()) {
            String outPartName;
            if (!SOAPBindingUtil.isSOAPHeader(obj) || !inPartName.equals(outPartName = SOAPBindingUtil.getSoapHeader(obj).getPart())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BindingType {
        HTTPBinding,
        SOAPBinding,
        XMLBinding;

    }
}

