/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalDestination;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalTransportFactory
extends AbstractTransportFactory
implements DestinationFactory,
ConduitInitiator {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/local";
    private static final Logger LOG = Logger.getLogger(LocalTransportFactory.class.getName());
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private Map<String, Destination> destinations = new HashMap<String, Destination>();

    public LocalTransportFactory() {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(TRANSPORT_ID);
        this.setTransportIds(ids);
    }

    public Destination getDestination(EndpointInfo ei) throws IOException {
        return this.getDestination(this.createReference(ei));
    }

    public Destination getDestination(EndpointReferenceType reference) throws IOException {
        Destination d = this.destinations.get(reference.getAddress().getValue());
        if (d == null) {
            d = this.createDestination(reference);
            this.destinations.put(reference.getAddress().getValue(), d);
        }
        return d;
    }

    private Destination createDestination(EndpointReferenceType reference) {
        LOG.info("Creating destination for address " + reference.getAddress().getValue());
        return new LocalDestination(this, reference);
    }

    void remove(LocalDestination destination) {
        this.destinations.remove(destination);
    }

    public Conduit getConduit(EndpointInfo ei) throws IOException {
        return new LocalConduit((LocalDestination)this.getDestination(this.createReference(ei)));
    }

    public Conduit getConduit(EndpointInfo ei, EndpointReferenceType target) throws IOException {
        return new LocalConduit((LocalDestination)this.getDestination(target));
    }

    EndpointReferenceType createReference(EndpointInfo ei) {
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(ei.getAddress());
        epr.setAddress(address);
        return epr;
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    static {
        URI_PREFIXES.add("local://");
    }
}

