/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class AttachmentSerializer {
    private static final String BODY_ATTACHMENT_ID = "root.message@cxf.apache.org";
    private Message message;
    private String bodyBoundary;
    private OutputStreamWriter writer;
    private OutputStream out;

    public AttachmentSerializer(Message messageParam) {
        this.message = messageParam;
    }

    public void writeProlog() throws IOException {
        this.bodyBoundary = AttachmentUtil.getUniqueBoundaryValue(0);
        String bodyCt = (String)this.message.get((Object)"Content-Type");
        String enc = (String)this.message.get((Object)Message.ENCODING);
        if (enc == null) {
            enc = "UTF-8";
        }
        StringBuilder ct = new StringBuilder();
        ct.append("multipart/related; ").append("type=\"application/xop+xml\"; ").append("boundary=\"").append(this.bodyBoundary).append("\"; ").append("start=\"<").append(BODY_ATTACHMENT_ID).append(">\"; ").append("start-info=\"").append(bodyCt).append("; charset=").append(enc).append("\"");
        this.message.put((Object)"Content-Type", (Object)ct.toString());
        this.out = (OutputStream)this.message.getContent(OutputStream.class);
        String encoding = (String)this.message.get((Object)Message.ENCODING);
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.writer = new OutputStreamWriter(this.out, encoding);
        this.writer.write("\r\n");
        this.writer.write("--");
        this.writer.write(this.bodyBoundary);
        StringBuilder mimeBodyCt = new StringBuilder();
        mimeBodyCt.append("application/xop+xml; charset=").append(enc).append("; type=\"").append(bodyCt).append("; charset=").append(enc).append("\"");
        this.writeHeaders(mimeBodyCt.toString(), BODY_ATTACHMENT_ID);
    }

    private void writeHeaders(String contentType, String attachmentId) throws IOException {
        this.writer.write("\r\n");
        this.writer.write("Content-Type: ");
        this.writer.write(contentType);
        this.writer.write("\r\n");
        this.writer.write("Content-Transfer-Encoding: binary\r\n");
        this.writer.write("Content-ID: <");
        this.writer.write(attachmentId);
        this.writer.write(">\r\n\r\n");
        this.writer.flush();
    }

    public void writeAttachments() throws IOException {
        for (Attachment a : this.message.getAttachments()) {
            this.writer.write("\r\n");
            this.writer.write("--");
            this.writer.write(this.bodyBoundary);
            this.writeHeaders(a.getDataHandler().getContentType(), a.getId());
            IOUtils.copy((InputStream)a.getDataHandler().getInputStream(), (OutputStream)this.out);
        }
        this.writer.write("\r\n");
        this.writer.write("--");
        this.writer.write(this.bodyBoundary);
        this.writer.write("--");
        this.writer.flush();
    }
}

