/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.UUID;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Attachment;

public final class AttachmentUtil {
    private AttachmentUtil() {
    }

    public static String createContentID(String ns) throws UnsupportedEncodingException {
        String cid = "cxf.apache.org";
        String name = UUID.randomUUID() + "@";
        if (ns != null && ns.length() > 0) {
            try {
                String host;
                URI uri = new URI(ns);
                cid = host = uri.toURL().getHost();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
            catch (MalformedURLException e) {
                cid = URLEncoder.encode(ns, "UTF-8");
            }
        }
        return name + cid;
    }

    public static String getUniqueBoundaryValue(int part) {
        StringBuffer s = new StringBuffer();
        s.append("----=_Part_").append(part++).append("_").append(s.hashCode()).append('.').append(System.currentTimeMillis());
        return s.toString();
    }

    public static String getAttchmentPartHeader(Attachment att) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(HttpHeaderHelper.getHeaderKey((String)"Content-Type") + ": " + att.getDataHandler().getContentType() + ";\r\n");
        if (att.isXOP()) {
            buffer.append("Content-Transfer-Encoding: binary\r\n");
        }
        buffer.append("Content-ID: <" + att.getId() + ">\r\n\r\n");
        return buffer.toString();
    }
}

