/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding;

import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLBindingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBindingFactory
implements BindingFactory,
WSDLBindingFactory {
    @Resource
    Bus bus;
    @Resource
    Collection<String> activationNamespaces;

    @PostConstruct
    void registerWithBindingManager() {
        BindingFactoryManager manager = (BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class);
        for (String ns : this.activationNamespaces) {
            manager.registerBindingFactory(ns, (BindingFactory)this);
        }
    }

    public BindingInfo createBindingInfo(ServiceInfo service, String namespace) {
        return new BindingInfo(service, namespace);
    }

    @Override
    public BindingInfo createBindingInfo(ServiceInfo service, Binding binding) {
        String namespace = ((ExtensibilityElement)binding.getExtensibilityElements().get(0)).getElementType().getNamespaceURI();
        BindingInfo bi = this.createBindingInfo(service, namespace);
        return this.initializeBindingInfo(service, binding, bi);
    }

    protected BindingInfo initializeBindingInfo(ServiceInfo service, Binding binding, BindingInfo bi) {
        bi.setName(binding.getQName());
        this.copyExtensors((AbstractPropertiesHolder)bi, binding.getExtensibilityElements());
        for (BindingOperation bop : CastUtils.cast((List)binding.getBindingOperations(), BindingOperation.class)) {
            BindingOperationInfo bop2;
            String inName = null;
            String outName = null;
            if (bop.getBindingInput() != null) {
                inName = bop.getBindingInput().getName();
            }
            if (bop.getBindingOutput() != null) {
                outName = bop.getBindingOutput().getName();
            }
            if ((bop2 = bi.buildOperation(new QName(service.getName().getNamespaceURI(), bop.getName()), inName, outName)) == null) continue;
            this.copyExtensors((AbstractPropertiesHolder)bop2, bop.getExtensibilityElements());
            bi.addOperation(bop2);
            if (bop.getBindingInput() != null) {
                this.copyExtensors((AbstractPropertiesHolder)bop2.getInput(), bop.getBindingInput().getExtensibilityElements());
            }
            if (bop.getBindingOutput() != null) {
                this.copyExtensors((AbstractPropertiesHolder)bop2.getOutput(), bop.getBindingOutput().getExtensibilityElements());
            }
            for (BindingFault f : CastUtils.cast(bop.getBindingFaults().values(), BindingFault.class)) {
                this.copyExtensors((AbstractPropertiesHolder)bop2.getFault(new QName(service.getTargetNamespace(), f.getName())), bop.getBindingFault(f.getName()).getExtensibilityElements());
            }
        }
        return bi;
    }

    private void copyExtensors(AbstractPropertiesHolder info, List<?> extList) {
        if (info != null) {
            for (ExtensibilityElement ext : CastUtils.cast(extList, ExtensibilityElement.class)) {
                info.addExtensor((Object)ext);
            }
        }
    }
}

