/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.cxf;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.BusState;
import org.apache.cxf.bus.cxf.extension.ExtensionManagerImpl;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.PropertiesResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.resource.SinglePropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFBusImpl
extends AbstractBasicInterceptorProvider
implements Bus {
    public static final String BUS_PROPERTY_NAME = "bus";
    private static final String BUS_ID_PROPERTY_NAME = "org.apache.cxf.bus.id";
    private static final String DEFAULT_BUS_ID = "cxf";
    private static final String BUS_EXTENSION_RESOURCE = "META-INF/bus-extensions.xml";
    private Map<Class, Object> extensions;
    private BusLifeCycleManager lifeCycleManager;
    private String id;
    private BusState state;

    protected CXFBusImpl() {
        this(new HashMap<Class, Object>());
    }

    protected CXFBusImpl(Map<Class, Object> e) {
        this(e, new HashMap<String, Object>());
    }

    protected CXFBusImpl(Map<Class, Object> e, Map<String, Object> properties) {
        Configurer configurer;
        this.extensions = e;
        if (null == this.extensions) {
            this.extensions = new HashMap<Class, Object>();
        }
        if (null == properties) {
            properties = new HashMap<String, Object>();
        }
        if (null == (configurer = (Configurer)this.extensions.get(Configurer.class))) {
            String cfgFile = (String)properties.get("cxf.config.file");
            configurer = new ConfigurerImpl(cfgFile);
            this.extensions.put(Configurer.class, configurer);
        }
        this.id = this.getBusId(properties);
        DefaultResourceManager resourceManager = new DefaultResourceManager();
        properties.put(BUS_ID_PROPERTY_NAME, BUS_PROPERTY_NAME);
        properties.put(BUS_PROPERTY_NAME, (Object)this);
        PropertiesResolver propertiesResolver = new PropertiesResolver(properties);
        resourceManager.addResourceResolver((ResourceResolver)propertiesResolver);
        SinglePropertyResolver busResolver = new SinglePropertyResolver(BUS_PROPERTY_NAME, (Object)this);
        resourceManager.addResourceResolver((ResourceResolver)busResolver);
        this.extensions.put(ResourceManager.class, resourceManager);
        new ExtensionManagerImpl(BUS_EXTENSION_RESOURCE, Thread.currentThread().getContextClassLoader(), this.extensions, (ResourceManager)resourceManager);
        this.state = BusState.INITIAL;
        this.lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.initComplete();
        }
    }

    public final <T> T getExtension(Class<T> extensionType) {
        Object obj = this.extensions.get(extensionType);
        if (null != obj) {
            return extensionType.cast(obj);
        }
        return null;
    }

    public <T> void setExtension(T extension, Class<T> extensionType) {
        this.extensions.put(extensionType, extension);
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            if (this.state == BusState.RUNNING) {
                return;
            }
            this.state = BusState.RUNNING;
            while (this.state == BusState.RUNNING) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        this.lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.preShutdown();
        }
        CXFBusImpl cXFBusImpl = this;
        synchronized (cXFBusImpl) {
            this.state = BusState.SHUTDOWN;
            ((Object)((Object)this)).notifyAll();
        }
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.postShutdown();
        }
    }

    protected BusState getState() {
        return this.state;
    }

    private String getBusId(Map<String, Object> properties) {
        String busId = null;
        if (null != properties && null != (busId = (String)properties.get(BUS_ID_PROPERTY_NAME)) && !"".equals(busId)) {
            return busId;
        }
        busId = System.getProperty(BUS_ID_PROPERTY_NAME);
        if (null != busId && !"".equals(busId)) {
            return busId;
        }
        return DEFAULT_BUS_ID;
    }
}

