/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.bus.spring.SpringBusImpl;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class SpringBusFactory
implements BusFactory {
    private static final String DEFAULT_BUS_ID = "cxf";
    private static final Logger LOG = LogUtils.getL7dLogger(SpringBusImpl.class);
    private static Bus defaultBus;
    private ApplicationContext context;

    public SpringBusFactory() {
    }

    public SpringBusFactory(ApplicationContext context) {
        this.context = context;
    }

    public synchronized Bus getDefaultBus() {
        if (null == defaultBus) {
            defaultBus = this.createBus();
        }
        return defaultBus;
    }

    public void setDefaultBus(Bus bus) {
        defaultBus = bus;
    }

    public Bus createBus() {
        return this.createBus(null);
    }

    public Bus createBus(String cfgFile) {
        boolean includeDefaults = true;
        if (this.context != null) {
            includeDefaults = !this.context.containsBean(DEFAULT_BUS_ID);
        }
        return this.createBus(cfgFile, includeDefaults);
    }

    public Bus createBus(String cfgFile, boolean includeDefaults) {
        BusApplicationContext bac = null;
        try {
            bac = new BusApplicationContext(cfgFile, includeDefaults, this.context);
        }
        catch (BeansException ex) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
        }
        bac.refresh();
        Bus bus = (Bus)bac.getBean(DEFAULT_BUS_ID);
        ConfigurerImpl configurer = new ConfigurerImpl((ApplicationContext)bac);
        bus.setExtension((Object)configurer, Configurer.class);
        return bus;
    }
}

