/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.BusState;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBusImpl
extends AbstractBasicInterceptorProvider
implements Bus {
    private Map<Class, Object> extensions = new HashMap<Class, Object>();
    private BusLifeCycleManager lifeCycleManager;
    private String id;
    private BusState state = BusState.INITIAL;

    public SpringBusImpl() {
        this.lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.initComplete();
        }
    }

    public void setExtensions(Map<Class, Object> e) {
        this.extensions = e;
    }

    public void setId(String i) {
        this.id = i;
    }

    public final <T> T getExtension(Class<T> extensionType) {
        Object obj = this.extensions.get(extensionType);
        if (null != obj) {
            return extensionType.cast(obj);
        }
        return null;
    }

    public <T> void setExtension(T extension, Class<T> extensionType) {
        this.extensions.put(extensionType, extension);
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SpringBusImpl springBusImpl = this;
        synchronized (springBusImpl) {
            if (this.state == BusState.RUNNING) {
                return;
            }
            this.state = BusState.RUNNING;
            while (this.state == BusState.RUNNING) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        this.lifeCycleManager = this.getExtension(BusLifeCycleManager.class);
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.preShutdown();
        }
        SpringBusImpl springBusImpl = this;
        synchronized (springBusImpl) {
            this.state = BusState.SHUTDOWN;
            ((Object)((Object)this)).notifyAll();
        }
        if (null != this.lifeCycleManager) {
            this.lifeCycleManager.postShutdown();
        }
    }

    protected BusState getState() {
        return this.state;
    }
}

