/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.interceptor.ClientOutFaultObserver;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientImpl
extends AbstractBasicInterceptorProvider
implements Client,
MessageObserver {
    public static final String FINISHED = "exchange.finished";
    private static final Logger LOG = LogUtils.getL7dLogger(ClientImpl.class);
    protected Bus bus;
    protected Endpoint endpoint;
    protected Conduit initedConduit;
    protected ClientOutFaultObserver outFaultObserver;
    protected int synchronousTimeout = 10000;

    public ClientImpl(Bus b, Endpoint e) {
        this(b, e, null);
    }

    public ClientImpl(Bus b, Endpoint e, Conduit c) {
        this.bus = b;
        this.endpoint = e;
        this.outFaultObserver = new ClientOutFaultObserver(this.bus);
        if (null != c) {
            this.initedConduit = c;
        }
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context) throws Exception {
        Map requestContext = null;
        Map responseContext = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Invoke, operation info: " + oi + ", params: " + params);
        }
        Message message = this.endpoint.getBinding().createMessage();
        if (null != context) {
            requestContext = (Map)context.get("RequestContext");
            responseContext = (Map)context.get("ResponseContext");
        }
        this.setContext(requestContext, message);
        this.setParameters(params, message);
        ExchangeImpl exchange = new ExchangeImpl();
        if (null != requestContext) {
            exchange.putAll(requestContext);
        }
        exchange.setOneWay(oi.getOutput() == null);
        exchange.setOutMessage(message);
        this.setOutMessageProperties(message, oi);
        this.setExchangeProperties((Exchange)exchange, requestContext, oi);
        PhaseInterceptorChain chain = this.setupInterceptorChain();
        message.setInterceptorChain((InterceptorChain)chain);
        this.modifyChain((InterceptorChain)chain, requestContext);
        chain.setFaultObserver((MessageObserver)this.outFaultObserver);
        Conduit conduit = this.getConduit();
        exchange.setConduit(conduit);
        conduit.setMessageObserver((MessageObserver)this);
        exchange.put(Client.class, (Object)this);
        chain.doIntercept(message);
        Exception ex = (Exception)message.getContent(Exception.class);
        if (ex != null) {
            throw ex;
        }
        ex = (Exception)message.getExchange().get(Exception.class);
        if (ex != null) {
            throw ex;
        }
        if (!oi.getOperationInfo().isOneWay()) {
            ExchangeImpl exchangeImpl = exchange;
            synchronized (exchangeImpl) {
                this.waitResponse((Exchange)exchange);
            }
        }
        List resList = null;
        Message inMsg = exchange.getInMessage();
        if (inMsg != null) {
            if (null != responseContext) {
                responseContext.putAll(inMsg);
                LOG.info("set responseContext to be" + responseContext);
            }
            resList = (List)inMsg.getContent(List.class);
        }
        if ((ex = this.getException((Exchange)exchange)) != null) {
            throw ex;
        }
        if (resList != null) {
            return resList.toArray();
        }
        return null;
    }

    protected Exception getException(Exchange exchange) {
        if (exchange.getInFaultMessage() != null) {
            return (Exception)exchange.getInFaultMessage().getContent(Exception.class);
        }
        if (exchange.getOutFaultMessage() != null) {
            return (Exception)exchange.getOutFaultMessage().getContent(Exception.class);
        }
        return null;
    }

    private void setContext(Map<String, Object> ctx, Message message) {
        if (ctx != null) {
            message.putAll(ctx);
            LOG.info("set requestContext to message be" + ctx);
        }
    }

    private void waitResponse(Exchange exchange) {
        long start;
        long end;
        for (int remaining = this.synchronousTimeout; !Boolean.TRUE.equals(exchange.get((Object)FINISHED)) && remaining > 0; remaining -= (int)(end - start)) {
            start = System.currentTimeMillis();
            try {
                exchange.wait(remaining);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            end = System.currentTimeMillis();
        }
        if (!Boolean.TRUE.equals(exchange.get((Object)FINISHED))) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"RESPONSE_TIMEOUT");
        }
    }

    private void setParameters(Object[] params, Message message) {
        if (params == null) {
            message.setContent(List.class, Collections.emptyList());
        } else {
            message.setContent(List.class, Arrays.asList(params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        message = this.endpoint.getBinding().createMessage(message);
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.TRUE);
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getInPhases());
        message.setInterceptorChain((InterceptorChain)chain);
        message.getExchange().put(Endpoint.class, (Object)this.endpoint);
        List il = this.bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add(il);
        il = this.endpoint.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add(il);
        il = this.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + il);
        }
        chain.add(il);
        il = this.endpoint.getBinding().getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + il);
        }
        chain.add(il);
        chain.setFaultObserver((MessageObserver)this.outFaultObserver);
        try {
            String startingInterceptorID = (String)message.get((Object)"starting_after_interceptor_id");
            if (startingInterceptorID != null) {
                chain.doIntercept(message, startingInterceptorID);
            } else {
                chain.doIntercept(message);
            }
        }
        finally {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                if (!this.isPartialResponse(message)) {
                    message.getExchange().put((Object)FINISHED, (Object)Boolean.TRUE);
                    message.getExchange().setInMessage(message);
                    message.getExchange().notifyAll();
                }
            }
        }
    }

    protected Conduit getConduit() {
        if (null == this.initedConduit) {
            EndpointInfo ei = this.endpoint.getEndpointInfo();
            String transportID = ei.getTransportId();
            try {
                ConduitInitiator ci = ((ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator(transportID);
                this.initedConduit = ci.getConduit(ei);
            }
            catch (BusException ex) {
                throw new Fault((Throwable)ex);
            }
            catch (IOException ex) {
                throw new Fault((Throwable)ex);
            }
        }
        return this.initedConduit;
    }

    protected void setOutMessageProperties(Message message, BindingOperationInfo boi) {
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        message.put(BindingMessageInfo.class, (Object)boi.getInput());
        message.put(MessageInfo.class, (Object)boi.getOperationInfo().getInput());
    }

    protected void setExchangeProperties(Exchange exchange, Map<String, Object> ctx, BindingOperationInfo boi) {
        exchange.put(Service.class, (Object)this.endpoint.getService());
        exchange.put(Endpoint.class, (Object)this.endpoint);
        exchange.put(ServiceInfo.class, (Object)this.endpoint.getService().getServiceInfo());
        exchange.put(InterfaceInfo.class, (Object)this.endpoint.getService().getServiceInfo().getInterface());
        exchange.put(Binding.class, (Object)this.endpoint.getBinding());
        exchange.put(BindingInfo.class, (Object)this.endpoint.getEndpointInfo().getBinding());
        exchange.put(BindingOperationInfo.class, (Object)boi);
        exchange.put(OperationInfo.class, (Object)boi.getOperationInfo());
    }

    protected PhaseInterceptorChain setupInterceptorChain() {
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getOutPhases());
        List il = this.bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add(il);
        il = this.endpoint.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add(il);
        il = this.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by client: " + il);
        }
        chain.add(il);
        il = this.endpoint.getBinding().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by binding: " + il);
        }
        chain.add(il);
        return chain;
    }

    protected void modifyChain(InterceptorChain chain, Map<String, Object> ctx) {
    }

    protected void setEndpoint(Endpoint e) {
        this.endpoint = e;
    }

    public int getSynchronousTimeout() {
        return this.synchronousTimeout;
    }

    public void setSynchronousTimeout(int synchronousTimeout) {
        this.synchronousTimeout = synchronousTimeout;
    }

    private boolean isPartialResponse(Message in) {
        return in.getContent(List.class) == null && this.getException(in.getExchange()) == null;
    }
}

