/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.interceptor.AbstractAttributedInterceptorProvider;
import org.apache.cxf.interceptor.InFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.interceptor.OutFaultChainInitiatorObserver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;

public class EndpointImpl
extends AbstractAttributedInterceptorProvider
implements Endpoint,
Configurable {
    private static final Logger LOG = LogUtils.getL7dLogger(EndpointImpl.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Service service;
    private Binding binding;
    private EndpointInfo endpointInfo;
    private Executor executor;
    private Bus bus;
    private MessageObserver inFaultObserver;
    private MessageObserver outFaultObserver;
    private boolean schemaValidation;

    public EndpointImpl(Bus bus, Service s, QName endpointName) throws EndpointException {
        this(bus, s, s.getServiceInfo().getEndpoint(endpointName));
    }

    public EndpointImpl(Bus bus, Service s, EndpointInfo ei) throws EndpointException {
        if (ei == null) {
            throw new NullPointerException("EndpointInfo can not be null!");
        }
        this.bus = bus;
        this.service = s;
        this.endpointInfo = ei;
        this.createBinding(this.endpointInfo.getBinding());
        this.inFaultObserver = new InFaultChainInitiatorObserver(bus);
        this.outFaultObserver = new OutFaultChainInitiatorObserver(bus);
        this.getOutInterceptors().add(new MessageSenderInterceptor());
        this.getOutFaultInterceptors().add(new MessageSenderInterceptor());
    }

    public String getBeanName() {
        return this.endpointInfo.getName().toString();
    }

    public EndpointInfo getEndpointInfo() {
        return this.endpointInfo;
    }

    public Service getService() {
        return this.service;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor e) {
        this.executor = e;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    final void createBinding(BindingInfo bi) throws EndpointException {
        if (null != bi) {
            String namespace = bi.getBindingId();
            BindingFactory bf = null;
            try {
                bf = ((BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class)).getBindingFactory(namespace);
                this.binding = bf.createBinding(bi);
            }
            catch (BusException ex) {
                throw new EndpointException(ex);
            }
            if (null == bf) {
                Message msg = new Message("NO_BINDING_FACTORY", BUNDLE, new Object[]{namespace});
                throw new EndpointException(msg);
            }
        }
    }

    public MessageObserver getInFaultObserver() {
        return this.inFaultObserver;
    }

    public MessageObserver getOutFaultObserver() {
        return this.outFaultObserver;
    }

    public void setEnableSchemaValidation(boolean value) {
        this.schemaValidation = value;
    }

    public boolean getEnableSchemaValidation() {
        return this.schemaValidation;
    }

    public void setInFaultObserver(MessageObserver observer) {
        this.inFaultObserver = observer;
    }

    public void setOutFaultObserver(MessageObserver observer) {
        this.outFaultObserver = observer;
    }
}

