/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFaultChainIntiatorObserver
implements MessageObserver {
    private static final Logger LOG = Logger.getLogger(AbstractFaultChainIntiatorObserver.class.getName());
    private Bus bus;

    public AbstractFaultChainIntiatorObserver(Bus bus) {
        this.bus = bus;
    }

    public void onMessage(Message m) {
        Message faultMessage = this.getFaultMessage(m);
        if (faultMessage == null) {
            faultMessage = new MessageImpl();
        }
        faultMessage = ((Binding)m.getExchange().get(Binding.class)).createMessage(faultMessage);
        this.setFaultMessage(m, faultMessage);
        MessageImpl.copyContent((Message)m, (Message)faultMessage);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(this.getPhases());
        this.initializeInterceptors(faultMessage.getExchange(), chain);
        faultMessage.setInterceptorChain((InterceptorChain)chain);
        try {
            chain.doIntercept(faultMessage);
        }
        catch (Exception ex) {
            LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"Error occured during error handling, give up!", (Throwable)ex, (Object[])new Object[0]);
        }
    }

    protected abstract boolean isOutboundObserver();

    protected abstract List<Phase> getPhases();

    protected void initializeInterceptors(Exchange ex, PhaseInterceptorChain chain) {
    }

    public Bus getBus() {
        return this.bus;
    }

    private Message getFaultMessage(Message original) {
        return this.isOutboundObserver() ? original.getExchange().getOutFaultMessage() : original.getExchange().getInFaultMessage();
    }

    private void setFaultMessage(Message original, Message fault) {
        if (this.isOutboundObserver()) {
            original.getExchange().setOutFaultMessage(fault);
        } else {
            original.getExchange().setInFaultMessage(fault);
        }
    }
}

