/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataReaderFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInDatabindingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "anyType", "xsd");
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractInDatabindingInterceptor.class);

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
    }

    protected DataReader getDataReader(Message message, Class<?> input) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataReaderFactory factory = service.getDataBinding().getDataReaderFactory();
        this.setSchemaInMessage(service, message);
        DataReader dataReader = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != input) continue;
            dataReader = factory.createReader(input);
            break;
        }
        if (dataReader == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAREADER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataReader;
    }

    protected DataReader<Message> getMessageDataReader(Message message) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataReaderFactory factory = service.getDataBinding().getDataReaderFactory();
        this.setSchemaInMessage(service, message);
        DataReader dataReader = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != Message.class) continue;
            dataReader = factory.createReader(Message.class);
            break;
        }
        if (dataReader == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAREADER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataReader;
    }

    protected DataReader<XMLStreamReader> getDataReader(Message message) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataReaderFactory factory = service.getDataBinding().getDataReaderFactory();
        this.setSchemaInMessage(service, message);
        DataReader dataReader = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != XMLStreamReader.class) continue;
            dataReader = factory.createReader(XMLStreamReader.class);
            break;
        }
        if (dataReader == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAREADER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataReader;
    }

    protected DataReader<Node> getNodeDataReader(Message message) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataReaderFactory factory = service.getDataBinding().getDataReaderFactory();
        this.setSchemaInMessage(service, message);
        DataReader dataReader = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != Node.class) continue;
            dataReader = factory.createReader(Node.class);
            break;
        }
        if (dataReader == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAREADER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataReader;
    }

    private void setSchemaInMessage(Service service, Message message) {
        if (message.getContextualProperty(Message.SCHEMA_VALIDATION_ENABLED) != null && Boolean.TRUE.equals(message.getContextualProperty(Message.SCHEMA_VALIDATION_ENABLED))) {
            Schema schema = EndpointReferenceUtils.getSchema((ServiceInfo)service.getServiceInfo());
            service.getDataBinding().getDataReaderFactory().setSchema(schema);
        }
    }

    protected DepthXMLStreamReader getXMLStreamReader(Message message) {
        XMLStreamReader xr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xr instanceof DepthXMLStreamReader) {
            return (DepthXMLStreamReader)xr;
        }
        DepthXMLStreamReader dr = new DepthXMLStreamReader(xr);
        message.setContent(XMLStreamReader.class, (Object)dr);
        return dr;
    }

    protected MessagePartInfo findMessagePart(Exchange exchange, Collection<OperationInfo> operations, QName name, boolean client, int index) {
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        MessagePartInfo lastChoice = null;
        Iterator<OperationInfo> itr = operations.iterator();
        while (itr.hasNext()) {
            OperationInfo op = itr.next();
            BindingOperationInfo boi = ep.getEndpointInfo().getBinding().getOperation(op);
            BindingMessageInfo msgInfo = null;
            msgInfo = client ? boi.getOutput() : boi.getInput();
            if (msgInfo == null) {
                itr.remove();
                continue;
            }
            List bodyParts = msgInfo.getMessageParts();
            if (bodyParts.size() == 0 || bodyParts.size() <= index) {
                itr.remove();
                continue;
            }
            MessagePartInfo p = (MessagePartInfo)msgInfo.getMessageParts().get(index);
            if (name.equals(p.getConcreteName())) {
                exchange.put(BindingOperationInfo.class, (Object)boi);
                exchange.setOneWay(op.isOneWay());
                return p;
            }
            if (XSD_ANY.equals(p.getTypeQName())) {
                lastChoice = p;
                continue;
            }
            itr.remove();
        }
        return lastChoice;
    }

    protected MessageInfo getMessageInfo(Message message, BindingOperationInfo operation, Exchange ex) {
        return this.getMessageInfo(message, operation, this.isRequestor(message));
    }

    protected MessageInfo getMessageInfo(Message message, BindingOperationInfo operation, boolean requestor) {
        MessageInfo msgInfo;
        OperationInfo intfOp = operation.getOperationInfo();
        if (requestor) {
            msgInfo = intfOp.getOutput();
            message.put(MessageInfo.class, (Object)intfOp.getOutput());
        } else {
            msgInfo = intfOp.getInput();
            message.put(MessageInfo.class, (Object)intfOp.getInput());
        }
        return msgInfo;
    }
}

