/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.List;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;

public class BareOutInterceptor
extends AbstractOutDatabindingInterceptor {
    public BareOutInterceptor() {
        this.setPhase("marshal");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(Message message) {
        List objs;
        Exchange exchange = message.getExchange();
        BindingOperationInfo operation = (BindingOperationInfo)exchange.get((Object)BindingOperationInfo.class.getName());
        if (operation == null) {
            return;
        }
        DataWriter<Message> dataWriter = this.getMessageDataWriter(message);
        int countParts = 0;
        List parts = null;
        if (!this.isRequestor(message)) {
            if (operation.getOutput() == null) return;
            parts = operation.getOutput().getMessageInfo().getMessageParts();
        } else {
            parts = operation.getInput().getMessageInfo().getMessageParts();
        }
        countParts = parts.size();
        if (countParts > 0 && (objs = (List)message.getContent(List.class)) != null) {
            Object[] args = objs.toArray();
            Object[] els = parts.toArray();
            for (int idx = 0; idx < countParts; ++idx) {
                Object arg = args[idx];
                MessagePartInfo part = (MessagePartInfo)els[idx];
                if (part.getProperty("SKIPPED") != null) continue;
                dataWriter.write(arg, part, (Object)message);
            }
        }
        message.getInterceptorChain().finishSubChain();
    }
}

