/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingChainInterceptor
extends AbstractPhaseInterceptor<Message> {
    public OutgoingChainInterceptor() {
        this.setPhase("post-invoke");
    }

    public void handleMessage(Message message) {
        Exchange ex = message.getExchange();
        BindingOperationInfo bin = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        if (null != bin && null != bin.getOperationInfo() && bin.getOperationInfo().isOneWay()) {
            return;
        }
        Message out = ex.getOutMessage();
        if (out != null) {
            OutgoingChainInterceptor.getBackChannelConduit(ex);
            if (bin != null) {
                out.put(MessageInfo.class, (Object)bin.getOperationInfo().getOutput());
                out.put(BindingMessageInfo.class, (Object)bin.getOutput());
            }
            out.getInterceptorChain().doIntercept(out);
        }
    }

    protected static Conduit getBackChannelConduit(Exchange ex) {
        Conduit conduit = null;
        if (ex.getOutMessage().getConduit() == null && ex.getConduit() == null && ex.getDestination() != null) {
            try {
                EndpointReferenceType target = (EndpointReferenceType)ex.get(EndpointReferenceType.class);
                conduit = ex.getDestination().getBackChannel(ex.getInMessage(), null, target);
                ex.setConduit(conduit);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return conduit;
    }
}

