/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.staxutils.StaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(StaxOutInterceptor.class);
    private static Map<Object, XMLOutputFactory> factories = new HashMap<Object, XMLOutputFactory>();

    public StaxOutInterceptor() {
        this.setPhase("pre-protocol");
    }

    public void handleMessage(Message message) {
        XMLStreamWriter writer;
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (os == null) {
            return;
        }
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding == null && message.getExchange().getInMessage() != null) {
            encoding = (String)message.getExchange().getInMessage().get((Object)Message.ENCODING);
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        try {
            writer = StaxOutInterceptor.getXMLOutputFactory(message).createXMLStreamWriter(os, encoding);
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STREAM_CREATE_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
        message.setContent(XMLStreamWriter.class, (Object)writer);
        boolean result = message.getInterceptorChain().doIntercept(message);
        try {
            if (writer != null) {
                writer.close();
            }
            if (!result && message.getContent(Exception.class) != null) {
                if (message.getContent(Exception.class) instanceof Fault) {
                    throw (Fault)message.getContent(Exception.class);
                }
                throw new Fault((Throwable)message.getContent(Exception.class));
            }
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
    }

    public static XMLOutputFactory getXMLOutputFactory(Message m) throws Fault {
        Object o = m.getContextualProperty(XMLOutputFactory.class.getName());
        if (o instanceof XMLOutputFactory) {
            return (XMLOutputFactory)o;
        }
        if (o != null) {
            XMLOutputFactory xif = factories.get(o);
            if (xif == null) {
                Class cls;
                if (o instanceof Class) {
                    cls = (Class)o;
                } else if (o instanceof String) {
                    try {
                        cls = ClassLoaderUtils.loadClass((String)((String)o), StaxInInterceptor.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new Fault((Throwable)e);
                    }
                } else {
                    throw new Fault(new org.apache.cxf.common.i18n.Message("INVALID_INPUT_FACTORY", BUNDLE, new Object[]{o}));
                }
                try {
                    xif = (XMLOutputFactory)cls.newInstance();
                    factories.put(o, xif);
                }
                catch (InstantiationException e) {
                    throw new Fault((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new Fault((Throwable)e);
                }
            }
            return xif;
        }
        return StaxUtils.getXMLOutputFactory();
    }
}

