/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.resource.XmlSchemaURIResolver;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.TypeInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl11.WSDLBindingFactory;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLServiceBuilder {
    public static final String WSDL_SCHEMA_LIST = WSDLServiceBuilder.class.getName() + ".SCHEMA";
    public static final String WSDL_DEFINITION = WSDLServiceBuilder.class.getName() + ".DEFINITION";
    public static final String WSDL_SERVICE = WSDLServiceBuilder.class.getName() + ".SERVICE";
    public static final String WSDL_PORTTYPE = WSDLServiceBuilder.class.getName() + ".WSDL_PORTTYPE";
    public static final String WSDL_PORT = WSDLServiceBuilder.class.getName() + ".PORT";
    public static final String WSDL_BINDING = WSDLServiceBuilder.class.getName() + ".BINDING";
    public static final String WSDL_OPERATION = WSDLServiceBuilder.class.getName() + ".OPERATION";
    public static final String WSDL_BINDING_OPERATION = WSDLServiceBuilder.class.getName() + ".BINDING_OPERATION";
    private static final Logger LOG = Logger.getLogger(WSDLServiceBuilder.class.getName());
    private Bus bus;

    public WSDLServiceBuilder(Bus bus) {
        this.bus = bus;
    }

    private void copyExtensors(AbstractPropertiesHolder info, List<?> extList) {
        if (info != null) {
            for (ExtensibilityElement ext : CastUtils.cast(extList, ExtensibilityElement.class)) {
                info.addExtensor((Object)ext);
            }
        }
    }

    public ServiceInfo buildService(Definition d, QName name) {
        Service service = d.getService(name);
        return this.buildService(d, service);
    }

    public ServiceInfo buildService(Definition def, Service serv) {
        ServiceInfo service = new ServiceInfo();
        service.setProperty(WSDL_DEFINITION, (Object)def);
        service.setProperty(WSDL_SERVICE, (Object)serv);
        TypeInfo typeInfo = new TypeInfo(service);
        XmlSchemaCollection schemas = this.getSchemas(def, typeInfo);
        service.setProperty(WSDL_SCHEMA_LIST, (Object)schemas);
        service.setTypeInfo(typeInfo);
        service.setTargetNamespace(def.getTargetNamespace());
        service.setName(serv.getQName());
        this.copyExtensors((AbstractPropertiesHolder)service, def.getExtensibilityElements());
        PortType portType = null;
        for (Port port : CastUtils.cast(serv.getPorts().values(), Port.class)) {
            if (portType == null) {
                portType = port.getBinding().getPortType();
                continue;
            }
            if (port.getBinding().getPortType() == portType) continue;
            throw new IllegalStateException("All endpoints must share the same portType");
        }
        this.buildInterface(service, portType);
        for (Port port : CastUtils.cast(serv.getPorts().values(), Port.class)) {
            Binding binding = port.getBinding();
            BindingInfo bi = service.getBinding(binding.getQName());
            if (bi == null) {
                bi = this.buildBinding(service, binding);
            }
            this.buildEndpoint(service, bi, port);
        }
        return service;
    }

    private XmlSchemaCollection getSchemas(Definition def, TypeInfo typeInfo) {
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        ArrayList<Definition> defList = new ArrayList<Definition>();
        this.parseImports(def, defList);
        this.extractSchema(def, schemaCol, typeInfo);
        for (Definition def2 : defList) {
            this.extractSchema(def2, schemaCol, typeInfo);
        }
        return schemaCol;
    }

    private void parseImports(Definition def, List<Definition> defList) {
        ArrayList importList = new ArrayList();
        Collection ilist = CastUtils.cast(def.getImports().values());
        for (List list : ilist) {
            importList.addAll(list);
        }
        for (Import impt : importList) {
            this.parseImports(impt.getDefinition(), defList);
            defList.add(impt.getDefinition());
        }
    }

    private void extractSchema(Definition def, XmlSchemaCollection schemaCol, TypeInfo typeInfo) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            for (Object obj : typesElement.getExtensibilityElements()) {
                Element elem;
                Element schemaElem = null;
                if (obj instanceof Schema) {
                    Schema schema = (Schema)obj;
                    schemaElem = schema.getElement();
                } else if (obj instanceof UnknownExtensibilityElement && (elem = ((UnknownExtensibilityElement)obj).getElement()).getLocalName().equals("schema")) {
                    schemaElem = elem;
                }
                if (schemaElem == null) continue;
                for (Object prefix : def.getNamespaces().keySet()) {
                    String ns = (String)def.getNamespaces().get(prefix);
                    if ("".equals(prefix) || schemaElem.hasAttribute("xmlns:" + prefix)) continue;
                    schemaElem.setAttribute("xmlns:" + prefix, ns);
                }
                schemaCol.setBaseUri(def.getDocumentBaseURI());
                schemaCol.setSchemaResolver((URIResolver)new XmlSchemaURIResolver());
                XmlSchema xmlSchema = schemaCol.read(schemaElem);
                SchemaInfo schemaInfo = new SchemaInfo(typeInfo, xmlSchema.getTargetNamespace());
                schemaInfo.setElement(schemaElem);
                typeInfo.addSchema(schemaInfo);
            }
        }
    }

    public EndpointInfo buildEndpoint(ServiceInfo service, BindingInfo bi, Port port) {
        List elements = port.getExtensibilityElements();
        String ns = null;
        if (null != elements && elements.size() > 0) {
            ns = ((ExtensibilityElement)elements.get(0)).getElementType().getNamespaceURI();
        } else {
            ExtensibilityElement extElem = (ExtensibilityElement)port.getBinding().getExtensibilityElements().get(0);
            if (extElem instanceof SOAPBindingImpl) {
                ns = ((SOAPBindingImpl)extElem).getTransportURI();
            }
        }
        EndpointInfo ei = null;
        try {
            DestinationFactory factory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(ns);
            if (factory instanceof WSDLEndpointFactory) {
                WSDLEndpointFactory wFactory = (WSDLEndpointFactory)factory;
                ei = wFactory.createEndpointInfo(service, bi, port);
            }
        }
        catch (BusException e) {
            // empty catch block
        }
        if (ei == null) {
            ei = new EndpointInfo(service, ns);
        }
        ei.setName(new QName(service.getName().getNamespaceURI(), port.getName()));
        ei.setBinding(bi);
        this.copyExtensors((AbstractPropertiesHolder)ei, port.getExtensibilityElements());
        service.addEndpoint(ei);
        return ei;
    }

    public BindingInfo buildBinding(ServiceInfo service, Binding binding) {
        BindingInfo bi = null;
        String ns = ((ExtensibilityElement)binding.getExtensibilityElements().get(0)).getElementType().getNamespaceURI();
        try {
            BindingFactory factory = ((BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class)).getBindingFactory(ns);
            if (factory instanceof WSDLBindingFactory) {
                WSDLBindingFactory wFactory = (WSDLBindingFactory)factory;
                bi = wFactory.createBindingInfo(service, binding);
            }
        }
        catch (BusException e) {
            // empty catch block
        }
        if (bi == null) {
            bi = new BindingInfo(service, ns);
            bi.setName(binding.getQName());
            this.copyExtensors((AbstractPropertiesHolder)bi, binding.getExtensibilityElements());
            for (BindingOperation bop : CastUtils.cast((List)binding.getBindingOperations(), BindingOperation.class)) {
                BindingOperationInfo bop2;
                LOG.fine("binding operation name is " + bop.getName());
                String inName = null;
                String outName = null;
                if (bop.getBindingInput() != null) {
                    inName = bop.getBindingInput().getName();
                }
                if (bop.getBindingOutput() != null) {
                    outName = bop.getBindingOutput().getName();
                }
                if ((bop2 = bi.buildOperation(new QName(service.getName().getNamespaceURI(), bop.getName()), inName, outName)) == null) continue;
                this.copyExtensors((AbstractPropertiesHolder)bop2, bop.getExtensibilityElements());
                bi.addOperation(bop2);
                if (bop.getBindingInput() != null) {
                    this.copyExtensors((AbstractPropertiesHolder)bop2.getInput(), bop.getBindingInput().getExtensibilityElements());
                    this.handleHeader(bop2.getInput());
                }
                if (bop.getBindingOutput() != null) {
                    this.copyExtensors((AbstractPropertiesHolder)bop2.getOutput(), bop.getBindingOutput().getExtensibilityElements());
                    this.handleHeader(bop2.getOutput());
                }
                for (BindingFault f : CastUtils.cast(bop.getBindingFaults().values(), BindingFault.class)) {
                    this.copyExtensors((AbstractPropertiesHolder)bop2.getFault(new QName(service.getTargetNamespace(), f.getName())), bop.getBindingFault(f.getName()).getExtensibilityElements());
                }
            }
        }
        service.addBinding(bi);
        return bi;
    }

    private void handleHeader(BindingMessageInfo bindingMessageInfo) {
        List extensiblilityElement = bindingMessageInfo.getExtensors(ExtensibilityElement.class);
        if (extensiblilityElement == null) {
            return;
        }
    }

    public void buildInterface(ServiceInfo si, PortType p) {
        InterfaceInfo inf = si.createInterface(p.getQName());
        inf.setProperty(WSDL_PORTTYPE, (Object)p);
        for (Operation op : CastUtils.cast((List)p.getOperations(), Operation.class)) {
            this.buildInterfaceOperation(inf, op);
        }
    }

    private void buildInterfaceOperation(InterfaceInfo inf, Operation op) {
        Output output;
        OperationInfo opInfo = inf.addOperation(new QName(inf.getName().getNamespaceURI(), op.getName()));
        opInfo.setProperty(WSDL_OPERATION, (Object)op);
        Input input = op.getInput();
        List paramOrder = op.getParameterOrdering();
        if (input != null) {
            MessageInfo minfo = opInfo.createMessage(input.getMessage().getQName());
            opInfo.setInput(input.getName(), minfo);
            this.buildMessage((AbstractMessageContainer)minfo, input.getMessage(), paramOrder);
        }
        if ((output = op.getOutput()) != null) {
            MessageInfo minfo = opInfo.createMessage(output.getMessage().getQName());
            opInfo.setOutput(output.getName(), minfo);
            this.buildMessage((AbstractMessageContainer)minfo, output.getMessage(), paramOrder);
        }
        Map m = op.getFaults();
        for (Map.Entry rawentry : m.entrySet()) {
            Map.Entry entry = CastUtils.cast(rawentry, String.class, Fault.class);
            FaultInfo finfo = opInfo.addFault(new QName(inf.getName().getNamespaceURI(), (String)entry.getKey()), ((Fault)entry.getValue()).getMessage().getQName());
            this.buildMessage((AbstractMessageContainer)finfo, ((Fault)entry.getValue()).getMessage(), paramOrder);
        }
        this.checkForWrapped(opInfo);
    }

    private void checkForWrapped(OperationInfo opInfo) {
        MessageInfo inputMessage = opInfo.getInput();
        MessageInfo outputMessage = opInfo.getOutput();
        boolean passedRule = true;
        if (inputMessage == null || inputMessage.size() != 1 || outputMessage != null && outputMessage.size() > 1) {
            passedRule = false;
        }
        if (!passedRule) {
            return;
        }
        XmlSchemaCollection schemas = (XmlSchemaCollection)opInfo.getInterface().getService().getProperty(WSDL_SCHEMA_LIST);
        XmlSchemaElement inputEl = null;
        XmlSchemaElement outputEl = null;
        MessagePartInfo inputPart = inputMessage.getMessagePartByIndex(0);
        if (!inputPart.isElement()) {
            passedRule = false;
        } else {
            QName inputElementName = inputPart.getElementQName();
            inputEl = schemas.getElementByQName(inputElementName);
            if (inputEl == null || !opInfo.getName().getLocalPart().equals(inputElementName.getLocalPart())) {
                passedRule = false;
            }
        }
        if (!passedRule) {
            return;
        }
        MessagePartInfo outputPart = null;
        if (outputMessage != null && outputMessage.size() == 1 && (outputPart = outputMessage.getMessagePartByIndex(0)) != null) {
            if (!outputPart.isElement() || schemas.getElementByQName(outputPart.getElementQName()) == null) {
                passedRule = false;
            } else {
                outputEl = schemas.getElementByQName(outputPart.getElementQName());
            }
        }
        if (!passedRule) {
            return;
        }
        MessageInfo unwrappedInput = new MessageInfo(opInfo, inputMessage.getName());
        MessageInfo unwrappedOutput = null;
        XmlSchemaComplexType xsct = null;
        if (inputEl.getSchemaType() instanceof XmlSchemaComplexType) {
            xsct = (XmlSchemaComplexType)inputEl.getSchemaType();
            if (this.hasAttributes(xsct) || !this.isWrappableSequence(xsct, inputEl.getQName().getNamespaceURI(), unwrappedInput)) {
                passedRule = false;
            }
        } else {
            passedRule = false;
        }
        if (!passedRule) {
            return;
        }
        if (outputMessage != null) {
            unwrappedOutput = new MessageInfo(opInfo, outputMessage.getName());
            if (outputEl != null && outputEl.getSchemaType() instanceof XmlSchemaComplexType) {
                xsct = (XmlSchemaComplexType)outputEl.getSchemaType();
                if (this.hasAttributes(xsct) || !this.isWrappableSequence(xsct, outputEl.getQName().getNamespaceURI(), unwrappedOutput)) {
                    passedRule = false;
                }
            } else {
                passedRule = false;
            }
        }
        if (!passedRule) {
            return;
        }
        UnwrappedOperationInfo unwrapped = new UnwrappedOperationInfo(opInfo);
        opInfo.setUnwrappedOperation((OperationInfo)unwrapped);
        unwrapped.setInput(opInfo.getInputName(), unwrappedInput);
        if (outputMessage != null) {
            unwrapped.setOutput(opInfo.getOutputName(), unwrappedOutput);
        }
    }

    private boolean hasAttributes(XmlSchemaComplexType complexType) {
        return complexType.getAnyAttribute() != null || complexType.getAttributes().getCount() > 0;
    }

    private boolean isWrappableSequence(XmlSchemaComplexType type, String namespaceURI, MessageInfo wrapper) {
        if (type.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence seq = (XmlSchemaSequence)type.getParticle();
            XmlSchemaObjectCollection items = seq.getItems();
            for (int x = 0; x < items.getCount(); ++x) {
                MessagePartInfo mpi;
                XmlSchemaObject o = items.getItem(x);
                if (!(o instanceof XmlSchemaElement)) {
                    return false;
                }
                XmlSchemaElement el = (XmlSchemaElement)o;
                if (el.getSchemaTypeName() != null) {
                    mpi = wrapper.addMessagePart(new QName(namespaceURI, el.getName()));
                    mpi.setTypeQName(el.getSchemaTypeName());
                    mpi.setXmlSchema((XmlSchemaAnnotated)el);
                    continue;
                }
                if (el.getRefName() != null) {
                    mpi = wrapper.addMessagePart(el.getRefName());
                    mpi.setTypeQName(el.getRefName());
                    mpi.setXmlSchema((XmlSchemaAnnotated)el);
                    continue;
                }
                mpi = wrapper.addMessagePart(new QName(namespaceURI, el.getName()));
                mpi.setElementQName(mpi.getName());
                mpi.setElement(true);
                mpi.setXmlSchema((XmlSchemaAnnotated)el);
            }
            return true;
        }
        return type.getParticle() == null;
    }

    private void buildMessage(AbstractMessageContainer minfo, Message msg, List paramOrder) {
        MessagePartInfo pi;
        XmlSchemaCollection schemas = (XmlSchemaCollection)minfo.getOperation().getInterface().getService().getProperty(WSDL_SCHEMA_LIST);
        List orderedParam = msg.getOrderedParts(paramOrder);
        for (Part part : CastUtils.cast((List)orderedParam, Part.class)) {
            pi = minfo.addMessagePart(part.getName());
            if (part.getTypeName() != null) {
                pi.setTypeQName(part.getTypeName());
                pi.setElement(false);
                pi.setXmlSchema((XmlSchemaAnnotated)schemas.getTypeByQName(part.getTypeName()));
                continue;
            }
            pi.setElementQName(part.getElementName());
            pi.setElement(true);
            pi.setXmlSchema((XmlSchemaAnnotated)schemas.getElementByQName(part.getElementName()));
        }
        for (Part part : CastUtils.cast(msg.getParts().values(), Part.class)) {
            if (orderedParam.contains(part)) continue;
            pi = minfo.addMessagePart(part.getName());
            if (part.getTypeName() != null) {
                pi.setTypeQName(part.getTypeName());
                pi.setElement(false);
                pi.setXmlSchema((XmlSchemaAnnotated)schemas.getTypeByQName(part.getTypeName()));
                continue;
            }
            pi.setElementQName(part.getElementName());
            pi.setElement(true);
            pi.setXmlSchema((XmlSchemaAnnotated)schemas.getElementByQName(part.getElementName()));
        }
    }
}

