/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.net.URL;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

public class WSDLServiceFactory
extends AbstractServiceFactoryBean {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLServiceFactory.class);
    private URL wsdlUrl;
    private QName serviceName;
    private Definition definition;

    public WSDLServiceFactory(Bus b, Definition d, QName sn) {
        this.setBus(b);
        this.definition = d;
        this.serviceName = sn;
    }

    public WSDLServiceFactory(Bus b, URL url, QName sn) {
        this.setBus(b);
        this.wsdlUrl = url;
        this.serviceName = sn;
        try {
            this.definition = ((WSDLManager)this.getBus().getExtension(WSDLManager.class)).getDefinition(this.wsdlUrl);
        }
        catch (WSDLException ex) {
            throw new ServiceConstructionException(new Message("SERVICE_CREATION_MSG", LOG, new Object[0]), ex);
        }
    }

    public Service create() {
        javax.wsdl.Service wsdlService = this.definition.getService(this.serviceName);
        if (wsdlService == null) {
            throw new ServiceConstructionException(new Message("NO_SUCH_SERVICE_EXC", LOG, new Object[]{this.serviceName}));
        }
        ServiceInfo si = new WSDLServiceBuilder(this.getBus()).buildService(this.definition, wsdlService);
        ServiceImpl service = new ServiceImpl(si);
        this.setService(service);
        return service;
    }
}

