/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesLoaderUtils {
    private PropertiesLoaderUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadAllProperties(String resourceName, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        Enumeration<URL> urls = classLoader.getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = null;
            try {
                UrlResource ur = new UrlResource(url);
                is = ur.getInputStream();
                properties.loadFromXML(new BufferedInputStream(is));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return properties;
    }

    public static Collection<String> getPropertyNames(Properties properties, String value) {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!value.equals(properties.getProperty(name))) continue;
            names.add(name);
        }
        return names;
    }
}

