/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanMap<V>
implements ApplicationContextAware,
InitializingBean,
Map<String, V> {
    private ApplicationContext context;
    private Class<?> type;
    private String idsProperty;
    private Map<String, String> idToBeanName = new ConcurrentHashMap<String, String>();
    private Map<String, V> putStore = new ConcurrentHashMap<String, V>();

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.context = ctx;
    }

    public void afterPropertiesSet() throws Exception {
        this.processBeans(this.context);
    }

    private void processBeans(ApplicationContext beanFactory) {
        if (beanFactory == null) {
            return;
        }
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)beanFactory;
        for (int i = 0; i < beanNames.length; ++i) {
            Class beanType;
            BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanNames[i]);
            if (!def.isSingleton() || def.isAbstract() || (beanType = ctxt.getType(beanNames[i])) == null || !this.type.isAssignableFrom(beanType)) continue;
            try {
                Collection<String> ids = this.getIds(ctxt.getBean(beanNames[i]));
                if (ids == null) continue;
                for (String id : ids) {
                    this.idToBeanName.put(id, beanNames[i]);
                }
                continue;
            }
            catch (BeanIsAbstractException e) {
                // empty catch block
            }
        }
        this.processBeans(ctxt.getParent());
    }

    private Collection<String> getIds(Object bean) {
        try {
            PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)this.idsProperty);
            Method method = pd.getReadMethod();
            Collection<String> c = CastUtils.cast((Collection)method.invoke(bean, new Object[0]));
            return c;
        }
        catch (IllegalArgumentException e) {
            throw new BeanInitializationException("Could not retrieve ids.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInitializationException("Could not access id getter.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BeanInitializationException("Could not invoke id getter.", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new BeanInitializationException("Could not invoke id getter.", (Throwable)e);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getIdsProperty() {
        return this.idsProperty;
    }

    public void setIdsProperty(String idsProperty) {
        this.idsProperty = idsProperty;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.idToBeanName.containsKey(key) || this.putStore.containsKey(key);
    }

    @Override
    public boolean containsValue(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> entries = new HashSet<Map.Entry<String, V>>();
        for (String k : this.keySet()) {
            entries.add(new Entry(this, k));
        }
        return entries;
    }

    @Override
    public V get(Object key) {
        String name = this.idToBeanName.get(key);
        if (name != null) {
            return (V)this.context.getBean(name);
        }
        return this.putStore.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.idToBeanName.isEmpty() && this.putStore.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.idToBeanName.keySet());
        keys.addAll(this.putStore.keySet());
        return keys;
    }

    @Override
    public V put(String key, V value) {
        this.idToBeanName.remove(key);
        return this.putStore.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        this.putStore.putAll(m);
    }

    @Override
    public V remove(Object key) {
        V v = this.get(key);
        if (v != null) {
            this.idToBeanName.remove(key);
        } else {
            v = this.putStore.get(key);
        }
        return v;
    }

    @Override
    public int size() {
        return this.idToBeanName.size() + this.putStore.size();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        values.addAll(this.putStore.values());
        for (String id : this.idToBeanName.keySet()) {
            values.add(this.get(id));
        }
        return values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V>
    implements Map.Entry<String, V> {
        private SpringBeanMap<V> map;
        private String key;

        public Entry(SpringBeanMap<V> map, String key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.map.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return this.map.put(this.key, value);
        }
    }
}

