/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.cxf.common.classloader.ClassLoaderUtils;

public class URIResolver {
    private File file;
    private URI uri;
    private InputStream is;
    private Class calling;

    public URIResolver() {
    }

    public URIResolver(String path) throws IOException {
        this("", path);
    }

    public URIResolver(String baseUriStr, String uriStr) throws IOException {
        this(baseUriStr, uriStr, null);
    }

    public URIResolver(String baseUriStr, String uriStr, Class calling) throws IOException {
        Class<?> clazz = this.calling = calling != null ? calling : this.getClass();
        if (uriStr.startsWith("classpath:")) {
            this.tryClasspath(uriStr);
        } else if (baseUriStr != null && baseUriStr.startsWith("jar:")) {
            this.tryJar(baseUriStr, uriStr);
        } else if (uriStr.startsWith("jar:")) {
            this.tryJar(uriStr);
        } else {
            this.tryFileSystem(baseUriStr, uriStr);
        }
    }

    public void resolve(String baseUriStr, String uriStr, Class callingCls) throws IOException {
        Class<?> clazz = this.calling = callingCls != null ? callingCls : this.getClass();
        if (uriStr.startsWith("classpath:")) {
            this.tryClasspath(uriStr);
        } else if (baseUriStr != null && baseUriStr.startsWith("jar:")) {
            this.tryJar(baseUriStr, uriStr);
        } else if (uriStr.startsWith("jar:")) {
            this.tryJar(uriStr);
        } else {
            this.tryFileSystem(baseUriStr, uriStr);
        }
    }

    private void tryFileSystem(String baseUriStr, String uriStr) throws IOException, MalformedURLException {
        block13: {
            try {
                File uriFile = new File(uriStr);
                uriFile = new File(uriFile.getAbsolutePath());
                URI relative = uriFile.exists() ? uriFile.toURI() : new URI(uriStr);
                if (relative.isAbsolute()) {
                    this.uri = relative;
                    this.is = relative.toURL().openStream();
                    break block13;
                }
                if (baseUriStr == null) break block13;
                File baseFile = new File(baseUriStr);
                if (!baseFile.exists() && baseUriStr.startsWith("file:/")) {
                    baseFile = new File(baseUriStr.substring(6));
                }
                URI base = baseFile.exists() ? baseFile.toURI() : new URI(baseUriStr);
                if (!(base = base.resolve(relative)).isAbsolute()) break block13;
                try {
                    baseFile = new File(base);
                    if (baseFile.exists()) {
                        this.is = base.toURL().openStream();
                        this.uri = base;
                        break block13;
                    }
                    this.tryClasspath(base.toString().startsWith("file:") ? base.toString().substring(5) : base.toString());
                }
                catch (Throwable th) {
                    this.tryClasspath(base.toString().startsWith("file:") ? base.toString().substring(5) : base.toString());
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (this.uri != null && "file".equals(this.uri.getScheme())) {
            this.file = new File(this.uri);
        }
        if (this.is == null && this.file != null && this.file.exists()) {
            this.uri = this.file.toURI();
            try {
                this.is = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("File was deleted! " + uriStr, e);
            }
        } else if (this.is == null) {
            this.tryClasspath(uriStr);
        }
    }

    private void tryJar(String baseStr, String uriStr) throws IOException {
        int i = baseStr.indexOf(33);
        if (i == -1) {
            this.tryFileSystem(baseStr, uriStr);
        }
        baseStr = baseStr.substring(i + 1);
        try {
            URI u = new URI(baseStr).resolve(uriStr);
            this.tryClasspath(u.toString());
            if (this.is != null) {
                return;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        this.tryFileSystem("", uriStr);
    }

    private void tryJar(String uriStr) throws IOException {
        int i = uriStr.indexOf(33);
        if (i == -1) {
            return;
        }
        uriStr = uriStr.substring(i + 1);
        this.tryClasspath(uriStr);
    }

    private void tryClasspath(String uriStr) throws IOException {
        URL url;
        if (uriStr.startsWith("classpath:")) {
            uriStr = uriStr.substring(10);
        }
        if ((url = ClassLoaderUtils.getResource(uriStr, this.calling)) == null) {
            this.tryRemote(uriStr);
        } else {
            block7: {
                try {
                    this.uri = url.toURI();
                }
                catch (URISyntaxException e) {
                    int pos;
                    String urlStr = url.toString();
                    if (!urlStr.startsWith("jar:") || (pos = urlStr.indexOf(33)) == -1) break block7;
                    try {
                        this.uri = new URI("classpath:" + urlStr.substring(pos + 1));
                    }
                    catch (URISyntaxException ue) {
                        // empty catch block
                    }
                }
            }
            this.is = url.openStream();
        }
    }

    private void tryRemote(String uriStr) throws IOException {
        try {
            URL url = new URL(uriStr);
            this.uri = new URI(url.toString());
            this.is = url.openStream();
        }
        catch (MalformedURLException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public boolean isFile() {
        if (this.file != null) {
            return this.file.exists();
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isResolved() {
        return this.is != null;
    }
}

