/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.dv;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.util.NamespaceContextAdapter;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XmlString;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxb.DatatypeFactory;
import org.xml.sax.ErrorHandler;

public class DefaultValuePlugin
extends Plugin {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultValuePlugin.class);

    public String getOptionName() {
        return "Xdv";
    }

    public String getUsage() {
        return "-Xdv: Initialize fields mapped from elements with their default values";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        LOG.fine("Running default value plugin.");
        for (ClassOutline co : outline.getClasses()) {
            for (FieldOutline f : co.getDeclaredFields()) {
                JExpression dvExpr;
                XmlString xmlDefaultValue = null;
                XSSimpleType xsType = null;
                boolean isElement = false;
                if (f.getPropertyInfo().getSchemaComponent() instanceof XSParticle) {
                    XSParticle particle = (XSParticle)f.getPropertyInfo().getSchemaComponent();
                    XSTerm term = particle.getTerm();
                    XSElementDecl element = null;
                    if (term.isElementDecl()) {
                        element = particle.getTerm().asElementDecl();
                        xmlDefaultValue = element.getDefaultValue();
                        xsType = element.getType();
                        isElement = true;
                    }
                } else if (f.getPropertyInfo().getSchemaComponent() instanceof XSAttributeUse) {
                    XSAttributeUse attributeUse = (XSAttributeUse)f.getPropertyInfo().getSchemaComponent();
                    XSAttributeDecl decl = attributeUse.getDecl();
                    xmlDefaultValue = decl.getDefaultValue();
                    xsType = decl.getType();
                }
                if (null == xmlDefaultValue || null == xmlDefaultValue.value || null == (dvExpr = this.getDefaultValueExpression(f, co, outline, (XSType)xsType, isElement, xmlDefaultValue))) continue;
                this.updateGetter(co, f, co.implClass, dvExpr);
            }
        }
        return true;
    }

    JExpression getDefaultValueExpression(FieldOutline f, ClassOutline co, Outline outline, XSType xsType, boolean isElement, XmlString xmlDefaultValue) {
        JType type = f.getRawType();
        String typeName = type.fullName();
        String defaultValue = xmlDefaultValue.value;
        JExpression dv = null;
        if ("java.lang.Boolean".equals(typeName) && isElement) {
            dv = JExpr.direct((String)(Boolean.valueOf(defaultValue) != false ? "Boolean.TRUE" : "Boolean.FALSE"));
        } else if ("java.lang.Byte".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg((JExpression)JExpr.cast((JType)type.unboxify(), (JExpression)JExpr.lit((int)new Byte(Short.valueOf(defaultValue).byteValue()).byteValue())));
        } else if ("java.lang.Double".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((double)new Double(Double.valueOf(defaultValue))));
        } else if ("java.lang.Float".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((float)new Float(Float.valueOf(defaultValue).floatValue()).floatValue()));
        } else if ("java.lang.Integer".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((int)new Integer(Integer.valueOf(defaultValue))));
        } else if ("java.lang.Long".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((long)new Long(Long.valueOf(defaultValue))));
        } else if ("java.lang.Short".equals(typeName) && isElement) {
            dv = JExpr._new((JType)type).arg((JExpression)JExpr.cast((JType)type.unboxify(), (JExpression)JExpr.lit((int)new Short(Short.valueOf(defaultValue)).shortValue())));
        } else if ("java.lang.String".equals(type.fullName()) && isElement) {
            dv = JExpr.lit((String)defaultValue);
        } else if ("java.math.BigInteger".equals(type.fullName()) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((String)defaultValue));
        } else if ("java.math.BigDecimal".equals(type.fullName()) && isElement) {
            dv = JExpr._new((JType)type).arg(JExpr.lit((String)defaultValue));
        } else if ("byte[]".equals(type.fullName()) && xsType.isSimpleType() && isElement) {
            while (!"anySimpleType".equals(xsType.getBaseType().getName())) {
                xsType = xsType.getBaseType();
            }
            if ("base64Binary".equals(xsType.getName())) {
                dv = outline.getCodeModel().ref(DatatypeConverter.class).staticInvoke("parseBase64Binary").arg(defaultValue);
            } else if ("hexBinary".equals(xsType.getName())) {
                dv = JExpr._new((JClass)outline.getCodeModel().ref(HexBinaryAdapter.class)).invoke("unmarshal").arg(defaultValue);
            }
        } else if ("javax.xml.namespace.QName".equals(typeName)) {
            NamespaceContextAdapter nsc = new NamespaceContextAdapter(xmlDefaultValue);
            QName qn = DatatypeConverter.parseQName((String)xmlDefaultValue.value, (NamespaceContext)nsc);
            dv = JExpr._new((JClass)outline.getCodeModel().ref(QName.class)).arg(qn.getNamespaceURI()).arg(qn.getLocalPart()).arg(qn.getPrefix());
        } else if ("javax.xml.datatype.Duration".equals(typeName)) {
            dv = outline.getCodeModel().ref(DatatypeFactory.class).staticInvoke("createDuration").arg(defaultValue);
        }
        return dv;
    }

    private void updateGetter(ClassOutline co, FieldOutline fo, JDefinedClass dc, JExpression dvExpr) {
        String fieldName = fo.getPropertyInfo().getName(false);
        JType type = fo.getRawType();
        String typeName = type.fullName();
        String getterName = ("java.lang.Boolean".equals(typeName) ? "is" : "get") + fo.getPropertyInfo().getName(true);
        JMethod method = dc.getMethod(getterName, new JType[0]);
        JDocComment doc = method.javadoc();
        int mods = method.mods().getValue();
        JType mtype = method.type();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Updating getter: " + getterName);
        }
        dc.methods().remove(method);
        method = dc.method(mods, mtype, getterName);
        method.javadoc().append((Object)doc);
        JFieldRef fr = JExpr.ref((String)fieldName);
        JExpression test = JOp.eq((JExpression)JExpr._null(), (JExpression)fr);
        JConditional jc = method.body()._if(test);
        jc._then()._return(dvExpr);
        jc._else()._return((JExpression)fr);
    }
}

