/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.counters;

import org.apache.cxf.management.counters.Counter;

public class TransportClientCounters {
    private static final String[] COUNTER_NAMES = new String[]{"Invoke", "InvokeOneWay", "InvokeAsync", "InvokeError"};
    private Counter[] counters;
    private String owner;

    public TransportClientCounters(String o) {
        this.owner = o;
        this.counters = new Counter[COUNTER_NAMES.length];
        this.initCounters();
    }

    public String getOwner() {
        return this.owner;
    }

    public Counter getInvoke() {
        return this.counters[0];
    }

    public Counter getInvokeOneWay() {
        return this.counters[1];
    }

    public Counter getInvokeAsync() {
        return this.counters[2];
    }

    public Counter getInvokeError() {
        return this.counters[3];
    }

    private void initCounters() {
        for (int i = 0; i < COUNTER_NAMES.length; ++i) {
            Counter c;
            this.counters[i] = c = new Counter(COUNTER_NAMES[i]);
        }
    }

    public void resetCounters() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i].reset();
        }
    }

    public void stopCounters() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i].stop();
        }
    }
}

