/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.soap;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.soap.VersionTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPCodec
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(MAPCodec.class);
    private static SOAPFactory soapFactory;
    protected final Map<String, Exchange> uncorrelatedExchanges = Collections.synchronizedMap(new HashMap());
    private VersionTransformer transformer;

    public MAPCodec() {
        this.setPhase("pre-protocol");
        this.addBefore("org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor");
        this.transformer = new VersionTransformer(this);
    }

    public Set<QName> getUnderstoodHeaders() {
        return VersionTransformer.HEADERS;
    }

    public void handleMessage(SoapMessage message) {
        this.mediate(message);
    }

    public void handleFault(SoapMessage message) {
    }

    private void mediate(SoapMessage message) {
        if (ContextUtils.isOutbound((Message)message)) {
            this.encode(message, ContextUtils.retrieveMAPs((Message)message, false, true));
        } else {
            ContextUtils.storeMAPs(this.decode(message), (Message)message, false);
        }
    }

    private void encode(SoapMessage message, AddressingProperties maps) {
        if (maps != null) {
            this.cacheExchange(message, maps);
            LOG.log(Level.INFO, "\nOutbound WS-Addressing headers");
            try {
                Element header = (Element)message.getHeaders(Element.class);
                this.discardMAPs(header, maps);
                header.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsa", maps.getNamespaceURI());
                JAXBContext jaxbContext = VersionTransformer.getExposedJAXBContext(maps.getNamespaceURI());
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getMessageID(), "MessageID", AttributedURIType.class, header, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getTo(), "To", AttributedURIType.class, header, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getReplyTo(), "ReplyTo", EndpointReferenceType.class, header, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getFaultTo(), "FaultTo", EndpointReferenceType.class, header, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getRelatesTo(), "RelatesTo", RelatesToType.class, header, marshaller);
                this.encodeAsExposed(maps.getNamespaceURI(), maps.getAction(), "Action", AttributedURIType.class, header, marshaller);
                this.propogateAction(maps.getAction(), message);
                this.applyMAPValidation(message);
            }
            catch (SOAPException se) {
                LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", se);
            }
            catch (JAXBException je) {
                LOG.log(Level.WARNING, "SOAP_HEADER_ENCODE_FAILURE_MSG", je);
            }
        }
    }

    private <T> void encodeAsExposed(String exposeAs, T value, String localName, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value != null) {
            LOG.log(Level.INFO, "{0} : {1}", new Object[]{localName, this.getLogText(value)});
            this.transformer.encodeAsExposed(exposeAs, value, localName, clz, header, marshaller);
        }
    }

    public AddressingProperties unmarshalMAPs(SoapMessage message) {
        AddressingPropertiesImpl maps = null;
        try {
            Element header = (Element)message.getHeaders(Element.class);
            if (header != null) {
                LOG.log(Level.INFO, "\nInbound WS-Addressing headers");
                Unmarshaller unmarshaller = null;
                NodeList headerElements = header.getChildNodes();
                int headerCount = headerElements.getLength();
                for (int i = 0; i < headerCount; ++i) {
                    if (!(headerElements.item(i) instanceof Element)) continue;
                    Element headerElement = (Element)headerElements.item(i);
                    String headerURI = headerElement.getNamespaceURI();
                    if (unmarshaller == null) {
                        JAXBContext jaxbContext = VersionTransformer.getExposedJAXBContext(headerURI);
                        unmarshaller = jaxbContext.createUnmarshaller();
                    }
                    if (this.transformer.isSupported(headerURI)) {
                        String localName;
                        if (maps == null) {
                            maps = new AddressingPropertiesImpl();
                            maps.exposeAs(headerURI);
                        }
                        if ("MessageID".equals(localName = headerElement.getLocalName())) {
                            maps.setMessageID(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("To".equals(localName)) {
                            maps.setTo(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("ReplyTo".equals(localName)) {
                            maps.setReplyTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("FaultTo".equals(localName)) {
                            maps.setFaultTo(this.decodeAsNative(headerURI, EndpointReferenceType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if ("RelatesTo".equals(localName)) {
                            maps.setRelatesTo(this.decodeAsNative(headerURI, RelatesToType.class, headerElement, unmarshaller));
                            continue;
                        }
                        if (!"Action".equals(localName)) continue;
                        maps.setAction(this.decodeAsNative(headerURI, AttributedURIType.class, headerElement, unmarshaller));
                        continue;
                    }
                    if (!headerURI.contains("/addressing")) continue;
                    LOG.log(Level.WARNING, "UNSUPPORTED_VERSION_MSG", headerURI);
                }
                this.restoreExchange(message, maps);
            }
        }
        catch (JAXBException je) {
            LOG.log(Level.WARNING, "SOAP_HEADER_DECODE_FAILURE_MSG", je);
        }
        return maps;
    }

    public <T> T decodeAsNative(String encodedAs, Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        T value = this.transformer.decodeAsNative(encodedAs, clz, headerElement, unmarshaller);
        LOG.log(Level.INFO, "{0} : {1}", new Object[]{headerElement.getLocalName(), this.getLogText(value)});
        return value;
    }

    private <T> String getLogText(T value) {
        String text = "unknown";
        if (value == null) {
            text = "null";
        } else if (value instanceof AttributedURIType) {
            text = ((AttributedURIType)value).getValue();
        } else if (value instanceof EndpointReferenceType) {
            text = ((EndpointReferenceType)value).getAddress() != null ? ((EndpointReferenceType)value).getAddress().getValue() : "null";
        } else if (value instanceof RelatesToType) {
            text = ((RelatesToType)value).getValue();
        }
        return text;
    }

    private AddressingProperties decode(SoapMessage message) {
        return this.unmarshalMAPs(message);
    }

    protected <T> void encodeMAP(T value, QName qname, Class<T> clz, Element header, Marshaller marshaller) throws JAXBException {
        if (value != null) {
            marshaller.marshal((Object)new JAXBElement(qname, clz, value), (Node)header);
        }
    }

    protected <T> T decodeMAP(Class<T> clz, Element headerElement, Unmarshaller unmarshaller) throws JAXBException {
        JAXBElement element = unmarshaller.unmarshal((Node)headerElement, clz);
        return (T)element.getValue();
    }

    private void discardMAPs(Element header, AddressingProperties maps) throws SOAPException {
        NodeList headerElements = header.getElementsByTagNameNS(maps.getNamespaceURI(), "*");
        for (int i = 0; i < headerElements.getLength(); ++i) {
            Node headerElement = headerElements.item(i);
            if (!"http://www.w3.org/2005/08/addressing".equals(headerElement.getNamespaceURI())) continue;
            header.removeChild(headerElement);
        }
    }

    private void propogateAction(AttributedURIType action, SoapMessage message) {
        List soapActionHeaders;
        Map mimeHeaders;
        if (action != null && !"".equals(action.getValue()) && (mimeHeaders = CastUtils.cast((Map)((Map)message.get((Object)"org.apache.cxf.mime.headers")))) != null && (soapActionHeaders = (List)mimeHeaders.get("SOAPAction")) != null && soapActionHeaders.size() != 0 && !"".equals(soapActionHeaders.get(0))) {
            LOG.log(Level.INFO, "encoding wsa:Action in SOAPAction header {0}", action.getValue());
            soapActionHeaders.clear();
            soapActionHeaders.add("\"" + action.getValue() + "\"");
        }
    }

    private void applyMAPValidation(SoapMessage message) throws SOAPException {
        String faultName = ContextUtils.retrieveMAPFaultName((Message)message);
        if (faultName != null) {
            String reason = ContextUtils.retrieveMAPFaultReason((Message)message);
            throw this.createSOAPFaultException(faultName, "wsa", "http://www.w3.org/2005/08/addressing", reason);
        }
    }

    private static synchronized SOAPFactory getSOAPFactory() throws SOAPException {
        if (soapFactory == null) {
            soapFactory = SOAPFactory.newInstance();
        }
        return soapFactory;
    }

    private SOAPFaultException createSOAPFaultException(String localName, String prefix, String namespace, String reason) throws SOAPException {
        SOAPFactory factory = MAPCodec.getSOAPFactory();
        SOAPFault fault = factory.createFault();
        Name qname = factory.createName(localName, prefix, namespace);
        fault.setFaultCode(qname);
        fault.setFaultString(reason);
        return new SOAPFaultException(fault);
    }

    private void cacheExchange(SoapMessage message, AddressingProperties maps) {
        if (maps.getRelatesTo() == null) {
            this.uncorrelatedExchanges.put(maps.getMessageID().getValue(), message.getExchange());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreExchange(SoapMessage message, AddressingProperties maps) {
        Exchange correlatedExchange;
        if (maps.getRelatesTo() != null && (correlatedExchange = this.uncorrelatedExchanges.get(maps.getRelatesTo().getValue())) != null) {
            Exchange exchange = correlatedExchange;
            synchronized (exchange) {
                Exchange tmpExchange = message.getExchange();
                message.setExchange(correlatedExchange);
                Endpoint endpoint = (Endpoint)correlatedExchange.get(Endpoint.class);
                if (Boolean.TRUE.equals(tmpExchange.get((Object)"deferred.fault.observer.notification")) && endpoint != null) {
                    message.getInterceptorChain().abort();
                    if (endpoint.getInFaultObserver() != null) {
                        endpoint.getInFaultObserver().onMessage((Message)message);
                    }
                }
            }
        }
    }
}

