/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.codehaus.jra.ResourceUtil;

public class URIMapper {
    private List<ResourceInfo> resources = new ArrayList<ResourceInfo>();
    private Map<OperationInfo, String> operations = new HashMap<OperationInfo, String>();

    public BindingOperationInfo getOperation(String uri, String verb, Message m) {
        ResourceInfo bestMatch = null;
        int bestScore = 0;
        for (ResourceInfo r : this.resources) {
            int newScore;
            if (!r.getVerb().equals(verb) || (newScore = ResourceUtil.getMatchScore((String)uri, (String)r.getUri())) <= bestScore) continue;
            bestMatch = r;
            bestScore = newScore;
        }
        if (bestScore > -1 && bestMatch != null) {
            return bestMatch.getOperation();
        }
        return null;
    }

    public void bind(BindingOperationInfo bop, String uri, String verb) {
        ResourceInfo info = new ResourceInfo();
        info.setUri(uri);
        info.setVerb(verb);
        info.setOperation(bop);
        this.operations.put(bop.getOperationInfo(), uri);
        this.resources.add(info);
    }

    public String getLocation(BindingOperationInfo bop) {
        return this.operations.get(bop.getOperationInfo());
    }

    public List getParameters(MessageInfo msgInfo, String path) {
        String resource = this.operations.get(msgInfo.getOperation());
        Map paramMap = ResourceUtil.getURIParameters((String)path, (String)resource);
        ArrayList params = new ArrayList(msgInfo.getMessageParts().size());
        int i = 0;
        for (MessagePartInfo p : msgInfo.getMessageParts()) {
            params.add(i, paramMap.get(p.getName().getLocalPart()));
            ++i;
        }
        return params;
    }

    public static class ResourceInfo {
        private String uri;
        private String verb;
        private BindingOperationInfo operation;

        public BindingOperationInfo getOperation() {
            return this.operation;
        }

        public void setOperation(BindingOperationInfo operation) {
            this.operation = operation;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getVerb() {
            return this.verb;
        }

        public void setVerb(String verb) {
            this.verb = verb;
        }
    }
}

